/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.ldap;

import java.util.ArrayList;
import javax.naming.Name;
import junit.framework.TestCase;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.ldap.LdapAuthoritiesPopulator;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.ldap.LdapAuthenticationProvider;
import org.springframework.security.providers.ldap.LdapAuthenticator;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.ldap.LdapUserDetailsMapper;
import org.springframework.security.userdetails.ldap.UserDetailsContextMapper;

public class LdapAuthenticationProviderTests
extends TestCase {
    public LdapAuthenticationProviderTests(String string) {
        super(string);
    }

    public LdapAuthenticationProviderTests() {
    }

    public void testSupportsUsernamePasswordAuthenticationToken() {
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator(), (LdapAuthoritiesPopulator)new MockAuthoritiesPopulator());
        LdapAuthenticationProviderTests.assertTrue((boolean)ldapProvider.supports(UsernamePasswordAuthenticationToken.class));
    }

    public void testDefaultMapperIsSet() {
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator(), (LdapAuthoritiesPopulator)new MockAuthoritiesPopulator());
        LdapAuthenticationProviderTests.assertTrue((boolean)(ldapProvider.getUserDetailsContextMapper() instanceof LdapUserDetailsMapper));
    }

    public void testEmptyOrNullUserNameThrowsException() {
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator(), (LdapAuthoritiesPopulator)new MockAuthoritiesPopulator());
        try {
            ldapProvider.authenticate((Authentication)new UsernamePasswordAuthenticationToken(null, (Object)"password"));
            LdapAuthenticationProviderTests.fail((String)"Expected BadCredentialsException for empty username");
        }
        catch (BadCredentialsException expected) {
            // empty catch block
        }
        try {
            ldapProvider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"", (Object)"bobspassword"));
            LdapAuthenticationProviderTests.fail((String)"Expected BadCredentialsException for null username");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testEmptyPasswordIsRejected() {
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator());
        try {
            ldapProvider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"jen", (Object)""));
            LdapAuthenticationProviderTests.fail((String)"Expected BadCredentialsException for empty password");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testNormalUsage() {
        MockAuthoritiesPopulator populator = new MockAuthoritiesPopulator();
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator(), (LdapAuthoritiesPopulator)populator);
        LdapUserDetailsMapper userMapper = new LdapUserDetailsMapper();
        userMapper.setRoleAttributes(new String[]{"ou"});
        ldapProvider.setUserDetailsContextMapper((UserDetailsContextMapper)userMapper);
        LdapAuthenticationProviderTests.assertNotNull((Object)ldapProvider.getAuthoritiesPopulator());
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"benspassword");
        Authentication authResult = ldapProvider.authenticate((Authentication)authRequest);
        LdapAuthenticationProviderTests.assertEquals((Object)"benspassword", (Object)authResult.getCredentials());
        UserDetails user = (UserDetails)authResult.getPrincipal();
        LdapAuthenticationProviderTests.assertEquals((int)2, (int)user.getAuthorities().length);
        LdapAuthenticationProviderTests.assertEquals((String)"{SHA}nFCebWjxfaLbHHG1Qk5UU4trbvQ=", (String)user.getPassword());
        LdapAuthenticationProviderTests.assertEquals((String)"ben", (String)user.getUsername());
        LdapAuthenticationProviderTests.assertEquals((String)"ben", (String)populator.getRequestedUsername());
        ArrayList<String> authorities = new ArrayList<String>();
        authorities.add(user.getAuthorities()[0].getAuthority());
        authorities.add(user.getAuthorities()[1].getAuthority());
        LdapAuthenticationProviderTests.assertTrue((boolean)authorities.contains("ROLE_FROM_ENTRY"));
        LdapAuthenticationProviderTests.assertTrue((boolean)authorities.contains("ROLE_FROM_POPULATOR"));
    }

    public void testPasswordIsSetFromUserDataIfUseAuthenticationRequestCredentialsIsFalse() {
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator(), (LdapAuthoritiesPopulator)new MockAuthoritiesPopulator());
        ldapProvider.setUseAuthenticationRequestCredentials(false);
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"benspassword");
        Authentication authResult = ldapProvider.authenticate((Authentication)authRequest);
        LdapAuthenticationProviderTests.assertEquals((Object)"{SHA}nFCebWjxfaLbHHG1Qk5UU4trbvQ=", (Object)authResult.getCredentials());
    }

    public void testUseWithNullAuthoritiesPopulatorReturnsCorrectRole() {
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator());
        LdapUserDetailsMapper userMapper = new LdapUserDetailsMapper();
        userMapper.setRoleAttributes(new String[]{"ou"});
        ldapProvider.setUserDetailsContextMapper((UserDetailsContextMapper)userMapper);
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)"ben", (Object)"benspassword");
        UserDetails user = (UserDetails)ldapProvider.authenticate((Authentication)authRequest).getPrincipal();
        LdapAuthenticationProviderTests.assertEquals((int)1, (int)user.getAuthorities().length);
        LdapAuthenticationProviderTests.assertEquals((String)"ROLE_FROM_ENTRY", (String)user.getAuthorities()[0].getAuthority());
    }

    class MockAuthoritiesPopulator
    implements LdapAuthoritiesPopulator {
        String username;

        MockAuthoritiesPopulator() {
        }

        public GrantedAuthority[] getGrantedAuthorities(DirContextOperations userCtx, String username) {
            this.username = username;
            return new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_FROM_POPULATOR")};
        }

        String getRequestedUsername() {
            return this.username;
        }
    }

    class MockAuthenticator
    implements LdapAuthenticator {
        MockAuthenticator() {
        }

        public DirContextOperations authenticate(Authentication authentication) {
            DirContextAdapter ctx = new DirContextAdapter();
            ctx.setAttributeValue("ou", (Object)"FROM_ENTRY");
            String username = authentication.getName();
            String password = (String)authentication.getCredentials();
            if (username.equals("ben") && password.equals("benspassword")) {
                ctx.setDn((Name)new DistinguishedName("cn=ben,ou=people,dc=springframework,dc=org"));
                ctx.setAttributeValue("userPassword", (Object)"{SHA}nFCebWjxfaLbHHG1Qk5UU4trbvQ=");
                return ctx;
            }
            if (username.equals("jen") && password.equals("")) {
                ctx.setDn((Name)new DistinguishedName("cn=jen,ou=people,dc=springframework,dc=org"));
                return ctx;
            }
            throw new BadCredentialsException("Authentication failed.");
        }
    }
}

