/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.dao.salt;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.providers.dao.salt.SystemWideSaltSource;

public class SystemWideSaltSourceTests
extends TestCase {
    public SystemWideSaltSourceTests() {
    }

    public SystemWideSaltSourceTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(SystemWideSaltSourceTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsMissingSystemWideSalt() throws Exception {
        SystemWideSaltSource saltSource = new SystemWideSaltSource();
        try {
            saltSource.afterPropertiesSet();
            SystemWideSaltSourceTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SystemWideSaltSourceTests.assertEquals((String)"A systemWideSalt must be set", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        SystemWideSaltSource saltSource = new SystemWideSaltSource();
        saltSource.setSystemWideSalt("helloWorld");
        SystemWideSaltSourceTests.assertEquals((String)"helloWorld", (String)saltSource.getSystemWideSalt());
    }

    public void testNormalOperation() throws Exception {
        SystemWideSaltSource saltSource = new SystemWideSaltSource();
        saltSource.setSystemWideSalt("helloWorld");
        saltSource.afterPropertiesSet();
        SystemWideSaltSourceTests.assertEquals((Object)"helloWorld", (Object)saltSource.getSalt(null));
    }
}

