/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method.aopalliance;

import java.lang.reflect.Method;
import java.util.Collection;
import junit.framework.TestCase;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.security.AccessDecisionManager;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.AfterInvocationManager;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationCredentialsNotFoundException;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.ITargetObject;
import org.springframework.security.MockAccessDecisionManager;
import org.springframework.security.MockAfterInvocationManager;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.MockRunAsManager;
import org.springframework.security.RunAsManager;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.intercept.method.MethodDefinitionSource;
import org.springframework.security.intercept.method.MockMethodDefinitionSource;
import org.springframework.security.intercept.method.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.runas.RunAsManagerImpl;

public class MethodSecurityInterceptorTests
extends TestCase {
    public MethodSecurityInterceptorTests() {
    }

    public MethodSecurityInterceptorTests(String arg0) {
        super(arg0);
    }

    public final void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.clearContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    private ITargetObject makeInterceptedTarget() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/springframework/security/intercept/method/aopalliance/applicationContext.xml");
        return (ITargetObject)context.getBean("target");
    }

    private ITargetObject makeInterceptedTargetRejectsAuthentication() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/springframework/security/intercept/method/aopalliance/applicationContext.xml");
        MockAuthenticationManager authenticationManager = new MockAuthenticationManager(false);
        MethodSecurityInterceptor si = (MethodSecurityInterceptor)context.getBean("securityInterceptor");
        si.setAuthenticationManager((AuthenticationManager)authenticationManager);
        return (ITargetObject)context.getBean("target");
    }

    private ITargetObject makeInterceptedTargetWithoutAnAfterInvocationManager() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/springframework/security/intercept/method/aopalliance/applicationContext.xml");
        MethodSecurityInterceptor si = (MethodSecurityInterceptor)context.getBean("securityInterceptor");
        si.setAfterInvocationManager(null);
        return (ITargetObject)context.getBean("target");
    }

    public void testCallingAPublicMethodFacadeWillNotRepeatSecurityChecksWhenPassedToTheSecuredMethodItFronts() throws Exception {
        ITargetObject target = this.makeInterceptedTarget();
        String result = target.publicMakeLowerCase("HELLO");
        MethodSecurityInterceptorTests.assertEquals((String)"hello Authentication empty", (String)result);
    }

    public void testCallingAPublicMethodWhenPresentingAnAuthenticationObjectWillNotChangeItsIsAuthenticatedProperty() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password");
        MethodSecurityInterceptorTests.assertTrue((!token.isAuthenticated() ? 1 : 0) != 0);
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        ITargetObject target = this.makeInterceptedTarget();
        String result = target.publicMakeLowerCase("HELLO");
        MethodSecurityInterceptorTests.assertEquals((String)"hello org.springframework.security.providers.UsernamePasswordAuthenticationToken false", (String)result);
    }

    public void testDeniesWhenAppropriate() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_NO_BENEFIT_TO_THIS_GRANTED_AUTHORITY")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        ITargetObject target = this.makeInterceptedTarget();
        try {
            target.makeUpperCase("HELLO");
            MethodSecurityInterceptorTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            MethodSecurityInterceptorTests.assertTrue((boolean)true);
        }
    }

    public void testGetters() {
        MockAccessDecisionManager accessDecision = new MockAccessDecisionManager();
        MockRunAsManager runAs = new MockRunAsManager();
        MockAuthenticationManager authManager = new MockAuthenticationManager();
        MockMethodDefinitionSource methodSource = new MockMethodDefinitionSource(false, true);
        MockAfterInvocationManager afterInvocation = new MockAfterInvocationManager();
        MethodSecurityInterceptor si = new MethodSecurityInterceptor();
        si.setAccessDecisionManager((AccessDecisionManager)accessDecision);
        si.setRunAsManager((RunAsManager)runAs);
        si.setAuthenticationManager((AuthenticationManager)authManager);
        si.setObjectDefinitionSource((MethodDefinitionSource)methodSource);
        si.setAfterInvocationManager((AfterInvocationManager)afterInvocation);
        MethodSecurityInterceptorTests.assertEquals((Object)accessDecision, (Object)si.getAccessDecisionManager());
        MethodSecurityInterceptorTests.assertEquals((Object)runAs, (Object)si.getRunAsManager());
        MethodSecurityInterceptorTests.assertEquals((Object)authManager, (Object)si.getAuthenticationManager());
        MethodSecurityInterceptorTests.assertEquals((Object)((Object)methodSource), (Object)si.getObjectDefinitionSource());
        MethodSecurityInterceptorTests.assertEquals((Object)afterInvocation, (Object)si.getAfterInvocationManager());
    }

    public void testMethodCallWithRunAsReplacement() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_UPPER")});
        SecurityContext ctx = SecurityContextHolder.getContext();
        ctx.setAuthentication((Authentication)token);
        ITargetObject target = this.makeInterceptedTarget();
        String result = target.makeUpperCase("hello");
        MethodSecurityInterceptorTests.assertEquals((String)"HELLO org.springframework.security.MockRunAsAuthenticationToken true", (String)result);
        MethodSecurityInterceptorTests.assertSame((Object)ctx, (Object)SecurityContextHolder.getContext());
        MethodSecurityInterceptorTests.assertSame((Object)token, (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testMethodCallWithoutRunAsReplacement() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_LOWER")});
        MethodSecurityInterceptorTests.assertTrue((boolean)token.isAuthenticated());
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        ITargetObject target = this.makeInterceptedTargetWithoutAnAfterInvocationManager();
        String result = target.makeLowerCase("HELLO");
        MethodSecurityInterceptorTests.assertEquals((String)"hello org.springframework.security.providers.UsernamePasswordAuthenticationToken true", (String)result);
    }

    public void testRejectionOfEmptySecurityContext() throws Exception {
        ITargetObject target = this.makeInterceptedTarget();
        try {
            target.makeUpperCase("hello");
            MethodSecurityInterceptorTests.fail((String)"Should have thrown AuthenticationCredentialsNotFoundException");
        }
        catch (AuthenticationCredentialsNotFoundException expected) {
            MethodSecurityInterceptorTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsAccessDecisionManagersThatDoNotSupportMethodInvocation() throws Exception {
        MethodSecurityInterceptor si = new MethodSecurityInterceptor();
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManagerWhichOnlySupportsStrings());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setObjectDefinitionSource((MethodDefinitionSource)new MockMethodDefinitionSource(false, true));
        si.setRunAsManager((RunAsManager)new MockRunAsManager());
        try {
            si.afterPropertiesSet();
            MethodSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodSecurityInterceptorTests.assertEquals((String)"AccessDecisionManager does not support secure object class: interface org.aopalliance.intercept.MethodInvocation", (String)expected.getMessage());
        }
    }

    public void testRejectsCallsWhenAuthenticationIsIncorrect() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password");
        MethodSecurityInterceptorTests.assertTrue((!token.isAuthenticated() ? 1 : 0) != 0);
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        ITargetObject target = this.makeInterceptedTargetRejectsAuthentication();
        try {
            target.makeLowerCase("HELLO");
            MethodSecurityInterceptorTests.fail((String)"Should have thrown AuthenticationException");
        }
        catch (AuthenticationException expected) {
            MethodSecurityInterceptorTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsCallsWhenObjectDefinitionSourceDoesNotSupportObject() throws Throwable {
        MethodSecurityInterceptor interceptor = new MethodSecurityInterceptor();
        interceptor.setObjectDefinitionSource((MethodDefinitionSource)new MockObjectDefinitionSourceWhichOnlySupportsStrings());
        interceptor.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        interceptor.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        interceptor.setRunAsManager((RunAsManager)new MockRunAsManager());
        try {
            interceptor.afterPropertiesSet();
            MethodSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodSecurityInterceptorTests.assertEquals((String)"ObjectDefinitionSource does not support secure object class: interface org.aopalliance.intercept.MethodInvocation", (String)expected.getMessage());
        }
    }

    public void testRejectsCallsWhenObjectIsNull() throws Throwable {
        MethodSecurityInterceptor interceptor = new MethodSecurityInterceptor();
        try {
            interceptor.invoke(null);
            MethodSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodSecurityInterceptorTests.assertEquals((String)"Object was null", (String)expected.getMessage());
        }
    }

    public void testRejectsRunAsManagersThatDoNotSupportMethodInvocation() throws Exception {
        MethodSecurityInterceptor si = new MethodSecurityInterceptor();
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setObjectDefinitionSource((MethodDefinitionSource)new MockMethodDefinitionSource(false, true));
        si.setRunAsManager((RunAsManager)new MockRunAsManagerWhichOnlySupportsStrings());
        si.setAfterInvocationManager((AfterInvocationManager)new MockAfterInvocationManager());
        try {
            si.afterPropertiesSet();
            MethodSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodSecurityInterceptorTests.assertEquals((String)"RunAsManager does not support secure object class: interface org.aopalliance.intercept.MethodInvocation", (String)expected.getMessage());
        }
    }

    public void testStartupCheckForAccessDecisionManager() throws Exception {
        MethodSecurityInterceptor si = new MethodSecurityInterceptor();
        si.setRunAsManager((RunAsManager)new MockRunAsManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setAfterInvocationManager((AfterInvocationManager)new MockAfterInvocationManager());
        si.setObjectDefinitionSource((MethodDefinitionSource)new MockMethodDefinitionSource(false, true));
        try {
            si.afterPropertiesSet();
            MethodSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodSecurityInterceptorTests.assertEquals((String)"An AccessDecisionManager is required", (String)expected.getMessage());
        }
    }

    public void testStartupCheckForAuthenticationManager() throws Exception {
        MethodSecurityInterceptor si = new MethodSecurityInterceptor();
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setRunAsManager((RunAsManager)new MockRunAsManager());
        si.setAfterInvocationManager((AfterInvocationManager)new MockAfterInvocationManager());
        si.setObjectDefinitionSource((MethodDefinitionSource)new MockMethodDefinitionSource(false, true));
        try {
            si.afterPropertiesSet();
            MethodSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodSecurityInterceptorTests.assertEquals((String)"An AuthenticationManager is required", (String)expected.getMessage());
        }
    }

    public void testStartupCheckForMethodDefinitionSource() throws Exception {
        MethodSecurityInterceptor si = new MethodSecurityInterceptor();
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        try {
            si.afterPropertiesSet();
            MethodSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodSecurityInterceptorTests.assertEquals((String)"An ObjectDefinitionSource is required", (String)expected.getMessage());
        }
    }

    public void testStartupCheckForRunAsManager() throws Exception {
        MethodSecurityInterceptor si = new MethodSecurityInterceptor();
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setRunAsManager(null);
        si.setObjectDefinitionSource((MethodDefinitionSource)new MockMethodDefinitionSource(false, true));
        try {
            si.afterPropertiesSet();
            MethodSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodSecurityInterceptorTests.assertEquals((String)"A RunAsManager is required", (String)expected.getMessage());
        }
    }

    public void testStartupCheckForValidAfterInvocationManager() throws Exception {
        MethodSecurityInterceptor si = new MethodSecurityInterceptor();
        si.setRunAsManager((RunAsManager)new MockRunAsManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setAfterInvocationManager((AfterInvocationManager)new MockAfterInvocationManagerWhichOnlySupportsStrings());
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setObjectDefinitionSource((MethodDefinitionSource)new MockMethodDefinitionSource(false, true));
        try {
            si.afterPropertiesSet();
            MethodSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodSecurityInterceptorTests.assertTrue((boolean)expected.getMessage().startsWith("AfterInvocationManager does not support secure object class:"));
        }
    }

    public void testValidationFailsIfInvalidAttributePresented() throws Exception {
        MethodSecurityInterceptor si = new MethodSecurityInterceptor();
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setRunAsManager((RunAsManager)new RunAsManagerImpl());
        MethodSecurityInterceptorTests.assertTrue((boolean)si.isValidateConfigAttributes());
        si.setObjectDefinitionSource((MethodDefinitionSource)new MockMethodDefinitionSource(true, true));
        try {
            si.afterPropertiesSet();
            MethodSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            MethodSecurityInterceptorTests.assertEquals((String)"Unsupported configuration attributes: [ANOTHER_INVALID, INVALID_ATTRIBUTE]", (String)expected.getMessage());
        }
    }

    public void testValidationNotAttemptedIfIsValidateConfigAttributesSetToFalse() throws Exception {
        MethodSecurityInterceptor si = new MethodSecurityInterceptor();
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        MethodSecurityInterceptorTests.assertTrue((boolean)si.isValidateConfigAttributes());
        si.setValidateConfigAttributes(false);
        MethodSecurityInterceptorTests.assertTrue((!si.isValidateConfigAttributes() ? 1 : 0) != 0);
        si.setObjectDefinitionSource((MethodDefinitionSource)new MockMethodDefinitionSource(true, true));
        si.afterPropertiesSet();
        MethodSecurityInterceptorTests.assertTrue((boolean)true);
    }

    public void testValidationNotAttemptedIfMethodDefinitionSourceCannotReturnIterator() throws Exception {
        MethodSecurityInterceptor si = new MethodSecurityInterceptor();
        si.setAccessDecisionManager((AccessDecisionManager)new MockAccessDecisionManager());
        si.setRunAsManager((RunAsManager)new MockRunAsManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        MethodSecurityInterceptorTests.assertTrue((boolean)si.isValidateConfigAttributes());
        si.setObjectDefinitionSource((MethodDefinitionSource)new MockMethodDefinitionSource(true, false));
        si.afterPropertiesSet();
        MethodSecurityInterceptorTests.assertTrue((boolean)true);
    }

    private class MockRunAsManagerWhichOnlySupportsStrings
    implements RunAsManager {
        private MockRunAsManagerWhichOnlySupportsStrings() {
        }

        public Authentication buildRunAs(Authentication authentication, Object object, ConfigAttributeDefinition config) {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public boolean supports(Class clazz) {
            return String.class.isAssignableFrom(clazz);
        }

        public boolean supports(ConfigAttribute attribute) {
            return true;
        }
    }

    private class MockObjectDefinitionSourceWhichOnlySupportsStrings
    implements MethodDefinitionSource {
        private MockObjectDefinitionSourceWhichOnlySupportsStrings() {
        }

        public Collection getConfigAttributeDefinitions() {
            return null;
        }

        public ConfigAttributeDefinition getAttributes(Method method, Class targetClass) {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public boolean supports(Class clazz) {
            return String.class.isAssignableFrom(clazz);
        }

        public ConfigAttributeDefinition getAttributes(Object object) {
            throw new UnsupportedOperationException("mock method not implemented");
        }
    }

    private class MockAfterInvocationManagerWhichOnlySupportsStrings
    implements AfterInvocationManager {
        private MockAfterInvocationManagerWhichOnlySupportsStrings() {
        }

        public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public boolean supports(Class clazz) {
            return String.class.isAssignableFrom(clazz);
        }

        public boolean supports(ConfigAttribute attribute) {
            return true;
        }
    }

    private class MockAccessDecisionManagerWhichOnlySupportsStrings
    implements AccessDecisionManager {
        private MockAccessDecisionManagerWhichOnlySupportsStrings() {
        }

        public void decide(Authentication authentication, Object object, ConfigAttributeDefinition config) throws AccessDeniedException {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public boolean supports(Class clazz) {
            return String.class.isAssignableFrom(clazz);
        }

        public boolean supports(ConfigAttribute attribute) {
            return true;
        }
    }
}

