/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.firewall;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.firewall.RequestWrapper;

public class RequestWrapperTests {
    private static Map<String, String> testPaths = new LinkedHashMap<String, String>();

    @BeforeClass
    public static void createTestMap() {
        testPaths.put("/path1;x=y;z=w/path2;x=y/path3;x=y", "/path1/path2/path3");
        testPaths.put("/path1;x=y/path2;x=y/", "/path1/path2/");
        testPaths.put("/path1//path2/", "/path1/path2/");
        testPaths.put("//path1/path2//", "/path1/path2/");
        testPaths.put(";x=y;z=w", "");
    }

    @Test
    public void pathParametersAreRemovedFromServletPath() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        for (Map.Entry<String, String> entry : testPaths.entrySet()) {
            String path = entry.getKey();
            String expectedResult = entry.getValue();
            request.setServletPath(path);
            RequestWrapper wrapper = new RequestWrapper((HttpServletRequest)request);
            Assert.assertEquals((Object)expectedResult, (Object)wrapper.getServletPath());
            wrapper.reset();
            Assert.assertEquals((Object)path, (Object)wrapper.getServletPath());
        }
    }

    @Test
    public void pathParametersAreRemovedFromPathInfo() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        for (Map.Entry<String, String> entry : testPaths.entrySet()) {
            String path = entry.getKey();
            String expectedResult = entry.getValue();
            if (expectedResult.length() == 0) {
                expectedResult = null;
            }
            request.setPathInfo(path);
            RequestWrapper wrapper = new RequestWrapper((HttpServletRequest)request);
            Assert.assertEquals((Object)expectedResult, (Object)wrapper.getPathInfo());
            wrapper.reset();
            Assert.assertEquals((Object)path, (Object)wrapper.getPathInfo());
        }
    }

    @Test
    public void resetWhenForward() throws Exception {
        String denormalizedPath = testPaths.keySet().iterator().next();
        String forwardPath = "/forward/path";
        HttpServletRequest mockRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse mockResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        RequestDispatcher mockDispatcher = (RequestDispatcher)Mockito.mock(RequestDispatcher.class);
        Mockito.when((Object)mockRequest.getServletPath()).thenReturn((Object)"");
        Mockito.when((Object)mockRequest.getPathInfo()).thenReturn((Object)denormalizedPath);
        Mockito.when((Object)mockRequest.getRequestDispatcher(forwardPath)).thenReturn((Object)mockDispatcher);
        RequestWrapper wrapper = new RequestWrapper(mockRequest);
        RequestDispatcher dispatcher = wrapper.getRequestDispatcher(forwardPath);
        dispatcher.forward((ServletRequest)mockRequest, (ServletResponse)mockResponse);
        ((HttpServletRequest)Mockito.verify((Object)mockRequest)).getRequestDispatcher(forwardPath);
        ((RequestDispatcher)Mockito.verify((Object)mockDispatcher)).forward((ServletRequest)mockRequest, (ServletResponse)mockResponse);
        Assert.assertEquals((Object)denormalizedPath, (Object)wrapper.getPathInfo());
        ((HttpServletRequest)Mockito.verify((Object)mockRequest, (VerificationMode)Mockito.times((int)2))).getPathInfo();
        wrapper.getServletPath();
        ((HttpServletRequest)Mockito.verify((Object)mockRequest, (VerificationMode)Mockito.times((int)2))).getServletPath();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockRequest, mockResponse, mockDispatcher});
    }

    @Test
    public void requestDispatcherNotWrappedAfterReset() {
        String path = "/forward/path";
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        RequestDispatcher dispatcher = (RequestDispatcher)Mockito.mock(RequestDispatcher.class);
        Mockito.when((Object)request.getRequestDispatcher(path)).thenReturn((Object)dispatcher);
        RequestWrapper wrapper = new RequestWrapper(request);
        wrapper.reset();
        Assert.assertSame((Object)dispatcher, (Object)wrapper.getRequestDispatcher(path));
    }
}

