/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.context;

import junit.framework.TestCase;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.context.SecurityContextImpl;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class SecurityContextHolderTests
extends TestCase {
    public final void setUp() throws Exception {
        SecurityContextHolder.setStrategyName((String)"MODE_INHERITABLETHREADLOCAL");
    }

    public void testContextHolderGetterSetterClearer() {
        SecurityContextImpl sc = new SecurityContextImpl();
        sc.setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)"Foobar", (Object)"pass"));
        SecurityContextHolder.setContext((SecurityContext)sc);
        SecurityContextHolderTests.assertEquals((Object)sc, (Object)SecurityContextHolder.getContext());
        SecurityContextHolder.clearContext();
        SecurityContextHolderTests.assertNotSame((Object)sc, (Object)SecurityContextHolder.getContext());
        SecurityContextHolder.clearContext();
    }

    public void testNeverReturnsNull() {
        SecurityContextHolderTests.assertNotNull((Object)SecurityContextHolder.getContext());
        SecurityContextHolder.clearContext();
    }

    public void testRejectsNulls() {
        try {
            SecurityContextHolder.setContext(null);
            SecurityContextHolderTests.fail((String)"Should have rejected null");
        }
        catch (IllegalArgumentException expected) {
            SecurityContextHolderTests.assertTrue((boolean)true);
        }
    }
}

