/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.util;

import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;

public class LocaleHandler
extends BasicHandler {
    private static final String PROPERTY_CHANGED_LOCALE_CONTEXT = "com.jaspersoft.jasperserver.changed.locale.context";
    private static final String PROPERTY_ORIGINAL_LOCALE_CONTEXT = "com.jaspersoft.jasperserver.original.locale.context";
    private static final List headers = new ArrayList(1);

    public List getUnderstoodHeaders() {
        return headers;
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (msgContext.getPastPivot()) {
            this.resetLocale(msgContext);
        } else {
            this.setLocale(msgContext);
        }
    }

    public void onFault(MessageContext msgContext) {
        this.resetLocale(msgContext);
    }

    protected void setLocale(MessageContext msgContext) throws AxisFault {
        String localeCode;
        SOAPEnvelope envelope = msgContext.getCurrentMessage().getSOAPEnvelope();
        SOAPHeaderElement header = envelope.getHeaderByName("http://www.jasperforge.org/jasperserver/ws", "locale");
        if (header != null && (localeCode = header.getValue()) != null && localeCode.length() > 0) {
            LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
            msgContext.setProperty(PROPERTY_CHANGED_LOCALE_CONTEXT, (Object)Boolean.TRUE);
            msgContext.setProperty(PROPERTY_ORIGINAL_LOCALE_CONTEXT, (Object)localeContext);
            Locale locale = LocaleHelper.getInstance().getLocale(localeCode);
            LocaleContextHolder.setLocale((Locale)locale);
        }
    }

    protected void resetLocale(MessageContext msgContext) {
        if (msgContext.containsProperty(PROPERTY_CHANGED_LOCALE_CONTEXT)) {
            LocaleContext originalContext = (LocaleContext)msgContext.getProperty(PROPERTY_ORIGINAL_LOCALE_CONTEXT);
            LocaleContextHolder.setLocaleContext((LocaleContext)originalContext);
            msgContext.removeProperty(PROPERTY_CHANGED_LOCALE_CONTEXT);
            msgContext.removeProperty(PROPERTY_ORIGINAL_LOCALE_CONTEXT);
        }
    }

    static {
        headers.add(new QName("http://www.jasperforge.org/jasperserver/ws", "locale"));
    }
}

