/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.scheduling;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobSummary;
import com.jaspersoft.jasperserver.remote.common.AbstractRemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.common.CallTemplate;
import com.jaspersoft.jasperserver.remote.common.RemoteServiceWrapperWithCheckedException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.JobsService;
import com.jaspersoft.jasperserver.ws.axis2.scheduling.ReportJobBeanTraslator;
import com.jaspersoft.jasperserver.ws.axis2.scheduling.ReportSchedulerService;
import com.jaspersoft.jasperserver.ws.axis2.util.RemoteServiceFromWsCallTemplate;
import com.jaspersoft.jasperserver.ws.scheduling.Job;
import com.jaspersoft.jasperserver.ws.scheduling.JobSummary;
import java.util.List;
import org.apache.axis.AxisFault;

@CallTemplate(value=RemoteServiceFromWsCallTemplate.class)
public class ReportSchedulerServiceImpl
extends RemoteServiceWrapperWithCheckedException<JobsService, AxisFault>
implements ReportSchedulerService {
    private ReportJobBeanTraslator beanTraslator;

    @Override
    public void deleteJob(final long id) throws AxisFault {
        this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Object>(){

            public Object call(JobsService service) throws RemoteException {
                service.deleteJob(id);
                return null;
            }
        });
    }

    @Override
    public void deleteJobs(final long[] ids) throws AxisFault {
        this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Object>(){

            public Object call(JobsService service) throws RemoteException {
                service.deleteJobs(ids);
                return null;
            }
        });
    }

    @Override
    public Job getJob(final long id) throws AxisFault {
        ReportJob reportJob = (ReportJob)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<ReportJob>(){

            public ReportJob call(JobsService service) throws RemoteException {
                return service.getJob(id);
            }
        });
        if (reportJob == null) {
            throw new JSException("report.scheduling.ws.job.not.found", new Object[]{id});
        }
        return this.beanTraslator.toServiceBean(reportJob);
    }

    @Override
    public Job scheduleJob(Job job) throws AxisFault {
        final ReportJob reportJob = new ReportJob();
        this.beanTraslator.copy(reportJob, job);
        ReportJob savedJob = (ReportJob)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<ReportJob>(){

            public ReportJob call(JobsService service) throws RemoteException {
                return service.scheduleJob(reportJob);
            }
        });
        return this.beanTraslator.toServiceBean(savedJob);
    }

    @Override
    public Job updateJob(Job job) throws AxisFault {
        final ReportJob reportJob = new ReportJob();
        this.beanTraslator.copy(reportJob, job);
        ReportJob savedJob = (ReportJob)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<ReportJob>(){

            public ReportJob call(JobsService service) throws RemoteException {
                return service.updateJob(reportJob);
            }
        });
        return this.beanTraslator.toServiceBean(savedJob);
    }

    @Override
    public JobSummary[] getAllJobs() throws AxisFault {
        List scheduledJobs = (List)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<List<ReportJobSummary>>(){

            public List<ReportJobSummary> call(JobsService service) throws RemoteException {
                return service.getAllJobs();
            }
        });
        return this.toSummaryArray(scheduledJobs);
    }

    @Override
    public JobSummary[] getReportJobs(final String reportURI) throws AxisFault {
        List scheduledJobs = (List)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<List<ReportJobSummary>>(){

            public List<ReportJobSummary> call(JobsService service) throws RemoteException {
                return service.getReportJobs(reportURI);
            }
        });
        return this.toSummaryArray(scheduledJobs);
    }

    protected JobSummary[] toSummaryArray(List reportJobSummaries) {
        JobSummary[] jobs;
        if (reportJobSummaries == null || reportJobSummaries.isEmpty()) {
            jobs = null;
        } else {
            jobs = new JobSummary[reportJobSummaries.size()];
            int idx = 0;
            for (ReportJobSummary reportJob : reportJobSummaries) {
                jobs[idx] = this.beanTraslator.toServiceSummary(reportJob);
                ++idx;
            }
        }
        return jobs;
    }

    public ReportJobBeanTraslator getBeanTraslator() {
        return this.beanTraslator;
    }

    public void setBeanTraslator(ReportJobBeanTraslator beanTraslator) {
        this.beanTraslator = beanTraslator;
    }

    public void setJobsService(JobsService jobsService) {
        this.remoteService = jobsService;
    }
}

