/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.security;

import com.jaspersoft.jasperserver.api.engine.scheduling.ReportJobsInternalService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.acl.basic.AclObjectIdentity;
import org.springframework.security.acl.basic.BasicAclDao;
import org.springframework.security.acl.basic.BasicAclEntry;
import org.springframework.security.acl.basic.NamedEntityObjectIdentity;
import org.springframework.security.acl.basic.SimpleAclEntry;

public class ReportJobAclDao
implements BasicAclDao {
    private static final Log log = LogFactory.getLog(ReportJobAclDao.class);
    private ReportJobsInternalService reportJobsInternalService;
    private String administratorRole;

    public BasicAclEntry[] getAcls(AclObjectIdentity objectIdentity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving ACLs for " + objectIdentity));
        }
        String jobOwner = this.getJobOwner(objectIdentity);
        return this.makeJobAclEntries(objectIdentity, jobOwner);
    }

    protected final String getJobOwner(AclObjectIdentity jobIdentity) {
        NamedEntityObjectIdentity namedId = (NamedEntityObjectIdentity)jobIdentity;
        long jobId = Long.parseLong(namedId.getId());
        return this.getReportJobsInternalService().getJobOwner(jobId);
    }

    protected BasicAclEntry[] makeJobAclEntries(AclObjectIdentity objectIdentity, String jobOwner) {
        SimpleAclEntry userReadEntry = new SimpleAclEntry((Object)jobOwner, objectIdentity, null, SimpleAclEntry.READ_WRITE_DELETE);
        SimpleAclEntry admReadEntry = new SimpleAclEntry((Object)this.getAdministratorRole(), objectIdentity, null, SimpleAclEntry.ADMINISTRATION);
        return new BasicAclEntry[]{userReadEntry, admReadEntry};
    }

    public String getAdministratorRole() {
        return this.administratorRole;
    }

    public void setAdministratorRole(String administratorRole) {
        this.administratorRole = administratorRole;
    }

    public ReportJobsInternalService getReportJobsInternalService() {
        return this.reportJobsInternalService;
    }

    public void setReportJobsInternalService(ReportJobsInternalService reportJobsInternalService) {
        this.reportJobsInternalService = reportJobsInternalService;
    }
}

