/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.JRTimezoneResultSetDataSource;
import com.jaspersoft.jasperserver.api.security.validators.Validator;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRJdbcQueryExecuter;
import org.quartz.DateBuilder;

public class JRTimezoneJdbcQueryExecuter
extends JRJdbcQueryExecuter {
    private static InheritableFlaggedThreadLocal parentTimezone = new InheritableFlaggedThreadLocal();
    private final TimezoneAdjustInfo timezoneAdjust;
    private final boolean timezoneSet;

    public JRTimezoneJdbcQueryExecuter(JRDataset dataset, Map map) {
        super(dataset, map);
        TimezoneAdjustInfo parentTimezoneAdjust = parentTimezone.isInherited() ? (TimezoneAdjustInfo)parentTimezone.get() : null;
        TimeZone timezoneParam = (TimeZone)this.getValueParameter("DATABASE_TIMEZONE").getValue();
        if (parentTimezoneAdjust != null && (timezoneParam == null || parentTimezoneAdjust.timezone != null && parentTimezoneAdjust.timezone.equals(timezoneParam))) {
            this.timezoneSet = false;
            this.timezoneAdjust = parentTimezoneAdjust;
        } else {
            this.timezoneSet = true;
            this.timezoneAdjust = new TimezoneAdjustInfo(timezoneParam);
            parentTimezone.set(this.timezoneAdjust);
        }
    }

    protected JRValueParameter getValueParameter(String parameterName) {
        JRValueParameter param = super.getValueParameter(parameterName);
        Object value = param.getValue();
        if (value instanceof Date && this.timezoneAdjust.timezone != null && this.timezoneAdjust.adjustedDates.add(new IdentityObjectWrapper(value))) {
            Date initialDate = (Date)value;
            Date date = DateBuilder.translateTime((Date)initialDate, (TimeZone)this.timezoneAdjust.timezone, (TimeZone)TimeZone.getTimeZone("GMT"));
            initialDate.setTime(date.getTime());
        }
        return param;
    }

    public JRDataSource createDatasource() throws JRException {
        Validator.validateSQL((String)this.getQueryString());
        JRDataSource dataSource = super.createDatasource();
        return new JRTimezoneResultSetDataSource(dataSource, this.timezoneAdjust.timezone);
    }

    public synchronized void close() {
        if (this.timezoneSet) {
            parentTimezone.remove();
        }
        super.close();
    }

    protected static class IdentityObjectWrapper {
        protected final Object object;

        public IdentityObjectWrapper(Object object) {
            this.object = object;
        }

        public int hashCode() {
            return System.identityHashCode(this.object);
        }

        public boolean equals(Object o) {
            if (!(o instanceof IdentityObjectWrapper)) {
                return false;
            }
            return this.object == ((IdentityObjectWrapper)o).object;
        }
    }

    protected static class TimezoneAdjustInfo {
        protected final TimeZone timezone;
        protected final Set adjustedDates;

        public TimezoneAdjustInfo(TimeZone timezone) {
            this.timezone = timezone;
            this.adjustedDates = new HashSet();
        }
    }

    protected static class InheritableFlaggedThreadLocal
    extends InheritableThreadLocal {
        protected InheritableFlaggedThreadLocal() {
        }

        protected Object childValue(Object parentValue) {
            InheritableValue child;
            if (parentValue == null) {
                child = null;
            } else {
                InheritableValue parent = (InheritableValue)parentValue;
                child = new InheritableValue(parent.getValue(), true);
            }
            return child;
        }

        @Override
        public Object get() {
            InheritableValue value = (InheritableValue)super.get();
            return value == null ? null : value.getValue();
        }

        @Override
        public void set(Object value) {
            InheritableValue inheritableValue = new InheritableValue(value, false);
            super.set(inheritableValue);
        }

        public boolean isInherited() {
            InheritableValue value = (InheritableValue)super.get();
            return value == null ? false : value.isInherited();
        }
    }

    protected static class InheritableValue {
        private final Object value;
        private final boolean inherited;

        public InheritableValue(Object value, boolean inherited) {
            this.value = value;
            this.inherited = inherited;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isInherited() {
            return this.inherited;
        }
    }
}

