/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.BuiltInParameterProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.EngineServiceImpl;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.RepositoryContextManager;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo.RepositoryURLHandlerFactory;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControlsContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCache;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCacheableItem;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.util.RepositoryUtils;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportLoadingService {
    protected static final Log log = LogFactory.getLog(ReportLoadingService.class);
    private RepositoryService repository;
    private RepositoryCache compiledReportsCache;
    private RepositoryCacheableItem cacheableCompiledReports;
    private RepositoryContextManager repositoryContextManager;
    private List builtInParameterProviders = new ArrayList();
    private String reportParameterLabelKeyPrefix;

    public void setRepositoryService(RepositoryService repository) {
        this.repository = repository;
    }

    public void setCompiledReportsCache(RepositoryCache compiledReportsCache) {
        this.compiledReportsCache = compiledReportsCache;
    }

    public void setCacheableCompiledReports(RepositoryCacheableItem cacheableCompiledReports) {
        this.cacheableCompiledReports = cacheableCompiledReports;
    }

    public void setRepositoryContextManager(RepositoryContextManager repositoryContextManager) {
        this.repositoryContextManager = repositoryContextManager;
    }

    public void setBuiltInParameterProviders(List builtInParameterProviders) {
        this.builtInParameterProviders = builtInParameterProviders;
    }

    public void setReportParameterLabelKeyPrefix(String reportParameterLabelKeyPrefix) {
        this.reportParameterLabelKeyPrefix = reportParameterLabelKeyPrefix;
    }

    public RepositoryService getRepositoryService() {
        return this.repository;
    }

    public List getBuiltInParameterProviders() {
        return this.builtInParameterProviders;
    }

    public String getReportParameterLabelKeyPrefix() {
        return this.reportParameterLabelKeyPrefix;
    }

    public JasperReport getJasperReport(ExecutionContext context, FileResource reportRes, boolean inMemoryUnit) {
        try {
            JasperReport report;
            if (inMemoryUnit) {
                InputStream fileResourceData = this.getFileResourceDataStream(context, reportRes);
                report = this.compileReport(fileResourceData);
            } else {
                InputStream compiledReport = this.getCompiledReport(context, reportRes);
                try {
                    report = (JasperReport)JRLoader.loadObject((InputStream)compiledReport);
                }
                catch (JRException e) {
                    Throwable cause = e.getCause();
                    if (cause == null || !(cause instanceof InvalidClassException)) {
                        throw e;
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)"InvalidClassException caught while loading compiled report, clearing the compiled report cache");
                    }
                    this.clearCompiledReportCache();
                    compiledReport = this.getCompiledReport(context, reportRes);
                    report = (JasperReport)JRLoader.loadObject((InputStream)compiledReport);
                }
            }
            return report;
        }
        catch (JRException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    public InputStream getFileResourceDataStream(ExecutionContext context, FileResource fileResource) {
        InputStream data;
        if (fileResource.hasData()) {
            data = fileResource.getDataStream();
        } else {
            FileResourceData resourceData = this.repository.getResourceData(context, fileResource.getURIString());
            data = resourceData.getDataStream();
        }
        return data;
    }

    private InputStream getCompiledReport(ExecutionContext context, FileResource jrxml) {
        return this.compiledReportsCache.cache(context, jrxml, this.cacheableCompiledReports);
    }

    private void clearCompiledReportCache() {
        this.compiledReportsCache.clearCache(this.cacheableCompiledReports);
    }

    public JasperReport compileReport(InputStream jrxmlData) {
        try {
            JasperDesign design = JRXmlLoader.load((InputStream)jrxmlData);
            JasperReport report = JasperCompileManager.compileReport((JasperDesign)design);
            return report;
        }
        catch (JRException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    public void setThreadRepositoryContext(ExecutionContext context, ResourceContainer reportUnit, String reportUnitURI) {
        context = EngineServiceImpl.getRuntimeExecutionContext(context);
        this.repositoryContextManager.setRepositoryContext(context, reportUnitURI, reportUnit);
    }

    public void resetThreadRepositoryContext() {
        this.repositoryContextManager.resetRepositoryContext();
    }

    public Map getReportParameters(ExecutionContext context, JasperReport report, Map requestParameters) {
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        reportParameters.put("REPORT_URL_HANDLER_FACTORY", RepositoryURLHandlerFactory.getInstance());
        if (context != null && context.getLocale() != null && reportParameters.get("REPORT_LOCALE") == null) {
            reportParameters.put("REPORT_LOCALE", context.getLocale());
        }
        if (context != null && context.getTimeZone() != null) {
            reportParameters.put("REPORT_TIME_ZONE", context.getTimeZone());
        }
        if (requestParameters != null) {
            reportParameters.putAll(requestParameters);
        }
        this.setBuiltinParameters(context, true, report.getParameters(), reportParameters, null);
        return reportParameters;
    }

    public void setBuiltinParameters(ExecutionContext context, boolean onlyExistingParameters, JRParameter[] existingJRParameters, Map parametersMap, List additionalParameters) {
        for (Object o : this.getBuiltInParameterProviders()) {
            BuiltInParameterProvider pProvider = (BuiltInParameterProvider)o;
            List results = pProvider.getParameters(context, additionalParameters, parametersMap);
            for (Object[] aResult : results) {
                this.setBuiltInParameter(context, onlyExistingParameters, existingJRParameters, parametersMap, additionalParameters, aResult);
            }
            if (!onlyExistingParameters) continue;
            for (JRParameter jrParameter : existingJRParameters) {
                Object[] aResult;
                Object parameterMapValue = parametersMap.get(jrParameter.getName());
                if (parameterMapValue != null || (aResult = pProvider.getParameter(context, additionalParameters, parametersMap, jrParameter.getName())) == null) continue;
                this.setBuiltInParameter(context, onlyExistingParameters, existingJRParameters, parametersMap, additionalParameters, aResult);
            }
        }
    }

    public void setBuiltInParameter(ExecutionContext context, boolean onlyExistingParameters, JRParameter[] existingJRParameters, Map parametersMap, List additionalParameters, Object[] aResult) {
        JRParameter jrParameter = (JRParameter)aResult[0];
        Object aValue = aResult[1];
        boolean set = false;
        Object parameterFromMap = parametersMap.get(jrParameter.getName());
        JRParameter existingJRParameter = null;
        if (onlyExistingParameters) {
            for (JRParameter existingJRParameterFromArray : existingJRParameters) {
                if (!existingJRParameterFromArray.getName().equals(jrParameter.getName())) continue;
                existingJRParameter = existingJRParameterFromArray;
                break;
            }
        }
        if (onlyExistingParameters) {
            if (existingJRParameter != null) {
                if (existingJRParameter.getDefaultValueExpression() != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Report parameter " + jrParameter.getName() + " has a default value expression, not setting value"));
                    }
                } else if (!existingJRParameter.getValueClass().isAssignableFrom(jrParameter.getValueClass())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Report parameter " + jrParameter.getName() + " type " + jrParameter.getValueClassName() + " not compatible with java.lang.String, not setting value"));
                    }
                } else {
                    set = true;
                }
            }
        } else if (parameterFromMap == null) {
            set = true;
        }
        if (set) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting report parameter " + jrParameter.getName() + " to " + aValue));
            }
            if (!onlyExistingParameters) {
                additionalParameters.add(jrParameter);
            }
            parametersMap.put(jrParameter.getName(), aValue);
        }
    }

    public <T extends Resource> T getFinalResource(ExecutionContext context, ResourceReference res, Class<T> type) {
        if (res == null) {
            return null;
        }
        Object finalRes = res.isLocal() ? res.getLocalResource() : this.getRepositoryResource(context, res.getReferenceURI(), type);
        return (T)finalRes;
    }

    private <T extends Resource> T getRepositoryResource(ExecutionContext context, String uri, Class<T> type) {
        return (T)this.getRepositoryService().getResource(context, uri, type);
    }

    public List<ResourceReference> getInputControlReferences(ExecutionContext context, InputControlsContainer container) {
        Object dataSource;
        ArrayList<ResourceReference> inputControlRefs = new ArrayList<ResourceReference>();
        if (container.getInputControls() != null) {
            inputControlRefs.addAll(container.getInputControls());
        }
        if ((dataSource = this.getFinalResource(ExecutionContextImpl.getRuntimeExecutionContext((ExecutionContext)context), container.getDataSource(), null)) instanceof InputControlsContainer && ((InputControlsContainer)dataSource).getInputControls() != null) {
            ArrayList<String> containerInputControlNames = new ArrayList<String>(inputControlRefs.size());
            for (ResourceReference ref : inputControlRefs) {
                containerInputControlNames.add(this.getInputControlParameterName(ref));
            }
            for (ResourceReference dataSourceControlRef : ((InputControlsContainer)dataSource).getInputControls()) {
                String dataSourceControlName = this.getInputControlParameterName(dataSourceControlRef);
                if (containerInputControlNames.contains(dataSourceControlName)) continue;
                inputControlRefs.add(dataSourceControlRef);
            }
        }
        return inputControlRefs;
    }

    protected String getInputControlParameterName(ResourceReference inputControlRef) {
        String name = null;
        if (inputControlRef.isLocal()) {
            name = inputControlRef.getLocalResource().getName();
        } else {
            String referenceURI = inputControlRef.getReferenceURI();
            if (referenceURI != null) {
                name = RepositoryUtils.getName((String)referenceURI);
            }
        }
        return name;
    }

    public List<InputControl> getInputControls(ExecutionContext context, InputControlsContainer container) {
        List<ResourceReference> inputControlRefs = this.getInputControlReferences(context, container);
        ArrayList<InputControl> inputControls = new ArrayList<InputControl>(inputControlRefs.size());
        for (ResourceReference ref : inputControlRefs) {
            inputControls.add(this.getFinalResource(context, ref, InputControl.class));
        }
        return inputControls;
    }
}

