/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CompiledReportProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.RepositoryContextManager;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryUtil;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;

public class DefaultRepositoryContextManager
implements RepositoryContextManager {
    private RepositoryService repository;
    private CompiledReportProvider compiledReportProvider;

    public DefaultRepositoryContextManager() {
    }

    public DefaultRepositoryContextManager(RepositoryService repository, CompiledReportProvider compiledReportProvider) {
        this.repository = repository;
        this.compiledReportProvider = compiledReportProvider;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public CompiledReportProvider getCompiledReportProvider() {
        return this.compiledReportProvider;
    }

    public void setCompiledReportProvider(CompiledReportProvider compiledReportProvider) {
        this.compiledReportProvider = compiledReportProvider;
    }

    @Override
    public void setRepositoryContext(ExecutionContext context, String reportUnitURI, ResourceContainer inMemoryReportUnit) {
        RepositoryContext repositoryContext = this.createRepositoryContext(context, reportUnitURI, inMemoryReportUnit);
        RepositoryUtil.setThreadRepositoryContext(repositoryContext);
    }

    protected RepositoryContext createRepositoryContext(ExecutionContext context, String reportUnitURI, ResourceContainer inMemoryReportUnit) {
        RepositoryContext repositoryContext = new RepositoryContext();
        repositoryContext.setRepository(this.repository);
        repositoryContext.setContextResourceURI(reportUnitURI);
        repositoryContext.setReportUnit(inMemoryReportUnit);
        repositoryContext.setDataSource(this.getDataSource(inMemoryReportUnit));
        repositoryContext.setExecutionContext(context);
        repositoryContext.setCompiledReportProvider(this.compiledReportProvider);
        return repositoryContext;
    }

    protected ReportDataSource getDataSource(ResourceContainer inMemoryReportUnit) {
        if (inMemoryReportUnit != null && inMemoryReportUnit instanceof ReportUnit) {
            ReportUnit reportUnit = (ReportUnit)inMemoryReportUnit;
            ResourceReference reference = reportUnit.getDataSource();
            if (reference == null) {
                return null;
            }
            Resource resource = reference.isLocal() ? reference.getLocalResource() : this.getDirectRepository().getResource(ExecutionContextImpl.getRuntimeExecutionContext(), reference.getReferenceURI());
            if (resource != null && resource instanceof ReportDataSource) {
                return (ReportDataSource)resource;
            }
        }
        return null;
    }

    protected RepositoryService getDirectRepository() {
        return this.repository;
    }

    @Override
    public void resetRepositoryContext() {
        RepositoryUtil.clearThreadRepositoryContext();
    }

    @Override
    public String getRepositoryPathKey(String path) {
        return path;
    }

    @Override
    public String getRepositoryUriForKey(String pathKey) {
        return pathKey;
    }
}

