/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.directwebremoting.dwrp.DefaultConverterManager;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.guice.Converting;
import org.directwebremoting.guice.ConvertingImpl;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.InternalConverter;
import org.directwebremoting.util.Logger;

public class InternalConverterManager
implements ConverterManager {
    private final ConverterManager converterManager = InternalConverterManager.getConverterManager();
    private static final ThreadLocal<String> typeName = new ThreadLocal();
    private static final Logger log = Logger.getLogger(InternalConverterManager.class);

    public InternalConverterManager() {
        this.addConverters();
    }

    public void addConverterType(String id, String className) {
        this.converterManager.addConverterType(id, className);
    }

    public void addConverter(String match, String type, Map params) throws IllegalArgumentException, InstantiationException, IllegalAccessException {
        this.converterManager.addConverter(match, type, params);
    }

    public void addConverter(String match, Converter converter) throws IllegalArgumentException {
        this.converterManager.addConverter(match, converter);
    }

    public Collection getConverterMatchStrings() {
        return this.converterManager.getConverterMatchStrings();
    }

    public Converter getConverterByMatchString(String match) {
        return this.converterManager.getConverterByMatchString(match);
    }

    public boolean isConvertable(Class paramType) {
        return this.converterManager.isConvertable(paramType);
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx, TypeHintContext incc) throws MarshallException {
        return this.converterManager.convertInbound(paramType, iv, inctx, incc);
    }

    public OutboundVariable convertOutbound(Object object, OutboundContext outctx) throws MarshallException {
        return this.converterManager.convertOutbound(object, outctx);
    }

    public void setExtraTypeInfo(TypeHintContext thc, Class type) {
        this.converterManager.setExtraTypeInfo(thc, type);
    }

    public Class getExtraTypeInfo(TypeHintContext thc) {
        return this.converterManager.getExtraTypeInfo(thc);
    }

    public void setConverters(Map converters) {
        this.converterManager.setConverters(converters);
    }

    private void addConverters() {
        Injector injector = DwrGuiceUtil.getInjector();
        for (Key key : injector.getBindings().keySet()) {
            Class cvtType;
            Class atype = key.getAnnotationType();
            if (atype == null || !Converting.class.isAssignableFrom(atype)) continue;
            Converting ann = (Converting)Converting.class.cast(key.getAnnotation());
            String match = ann.match();
            Class type = ann.type();
            Class impl = ann.impl();
            if ("".equals(match)) {
                match = type.getName();
            }
            Provider provider = null;
            if (impl.equals(Void.class)) {
                provider = injector.getProvider(key);
                cvtType = type;
            } else {
                try {
                    Key ikey = Key.get(Converter.class, (Annotation)new ConvertingImpl(impl));
                    provider = injector.getProvider(ikey);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                if (provider == null) {
                    final String implMatch = impl.getName();
                    provider = new Provider<Converter>(){

                        public Converter get() {
                            return InternalConverterManager.this.getConverterByMatchString(implMatch);
                        }
                    };
                }
                cvtType = impl;
            }
            this.addConverter(match, new InternalConverter(cvtType, (Provider<Converter>)provider));
        }
    }

    static void setTypeName(String name) {
        typeName.set(name);
    }

    private static ConverterManager getConverterManager() {
        String name = typeName.get();
        try {
            Class<?> cls = Class.forName(name);
            return (ConverterManager)cls.newInstance();
        }
        catch (Exception e) {
            if (name != null && !"".equals(name)) {
                log.warn("Couldn't make ConverterManager from type: " + name);
            }
            return new DefaultConverterManager();
        }
    }
}

