/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.vote;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.AuthorizationServiceException;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.acls.Acl;
import org.springframework.security.acls.AclService;
import org.springframework.security.acls.NotFoundException;
import org.springframework.security.acls.Permission;
import org.springframework.security.acls.objectidentity.ObjectIdentity;
import org.springframework.security.acls.objectidentity.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.objectidentity.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.sid.Sid;
import org.springframework.security.acls.sid.SidRetrievalStrategy;
import org.springframework.security.acls.sid.SidRetrievalStrategyImpl;
import org.springframework.security.vote.AbstractAclVoter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AclEntryVoter
extends AbstractAclVoter {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$vote$AclEntryVoter == null ? (class$org$springframework$security$vote$AclEntryVoter = AclEntryVoter.class$("org.springframework.security.vote.AclEntryVoter")) : class$org$springframework$security$vote$AclEntryVoter));
    private AclService aclService;
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();
    private String internalMethod;
    private String processConfigAttribute;
    private Permission[] requirePermission;
    static /* synthetic */ Class class$org$springframework$security$vote$AclEntryVoter;

    public AclEntryVoter(AclService aclService, String processConfigAttribute, Permission[] requirePermission) {
        Assert.notNull((Object)processConfigAttribute, (String)"A processConfigAttribute is mandatory");
        Assert.notNull((Object)aclService, (String)"An AclService is mandatory");
        if (requirePermission == null || requirePermission.length == 0) {
            throw new IllegalArgumentException("One or more requirePermission entries is mandatory");
        }
        this.aclService = aclService;
        this.processConfigAttribute = processConfigAttribute;
        this.requirePermission = requirePermission;
    }

    protected String getInternalMethod() {
        return this.internalMethod;
    }

    public void setInternalMethod(String internalMethod) {
        this.internalMethod = internalMethod;
    }

    protected String getProcessConfigAttribute() {
        return this.processConfigAttribute;
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        Assert.notNull((Object)objectIdentityRetrievalStrategy, (String)"ObjectIdentityRetrievalStrategy required");
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        Assert.notNull((Object)sidRetrievalStrategy, (String)"SidRetrievalStrategy required");
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().equals(this.getProcessConfigAttribute());
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        Iterator iter = config.getConfigAttributes().iterator();
        while (iter.hasNext()) {
            Acl acl;
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            Object domainObject = this.getDomainObjectInstance(object);
            if (domainObject == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Voting to abstain - domainObject is null");
                }
                return 0;
            }
            if (StringUtils.hasText((String)this.internalMethod)) {
                try {
                    Class<?> clazz = domainObject.getClass();
                    Method method = clazz.getMethod(this.internalMethod, new Class[0]);
                    domainObject = method.invoke(domainObject, new Object[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new AuthorizationServiceException("Object of class '" + domainObject.getClass() + "' does not provide the requested internalMethod: " + this.internalMethod);
                }
                catch (IllegalAccessException iae) {
                    logger.debug((Object)"IllegalAccessException", (Throwable)iae);
                    throw new AuthorizationServiceException("Problem invoking internalMethod: " + this.internalMethod + " for object: " + domainObject);
                }
                catch (InvocationTargetException ite) {
                    logger.debug((Object)"InvocationTargetException", (Throwable)ite);
                    throw new AuthorizationServiceException("Problem invoking internalMethod: " + this.internalMethod + " for object: " + domainObject);
                }
            }
            ObjectIdentity objectIdentity = this.objectIdentityRetrievalStrategy.getObjectIdentity(domainObject);
            Sid[] sids = this.sidRetrievalStrategy.getSids(authentication);
            try {
                acl = this.aclService.readAclById(objectIdentity, sids);
            }
            catch (NotFoundException nfe) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Voting to deny access - no ACLs apply for this principal");
                }
                return -1;
            }
            try {
                if (acl.isGranted(this.requirePermission, sids, false)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Voting to grant access");
                    }
                    return 1;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Voting to deny access - ACLs returned, but insufficient permissions for this principal");
                }
                return -1;
            }
            catch (NotFoundException nfe) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Voting to deny access - no ACLs apply for this principal");
                }
                return -1;
            }
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

