#include <stdlib.h>
#include <string.h>

#ifdef __APPLE__
  #include <mach-o/dyld.h>
  #include <OpenGL/gl.h>
  #include <OpenGL/glu.h>
  #include <GLUT/glut.h>
void *NSGLGetProcAddress(const char *name)
{
    NSSymbol symbol;
    char *symbolName;
    // Prepend a '_' for the Unix C symbol mangling convention
    symbolName = (char*) malloc(strlen (name) + 2);
    strcpy(symbolName + 1, name);
    symbolName[0] = '_';
    symbol = NULL;
    if (NSIsSymbolNameDefined(symbolName)) symbol = NSLookupAndBindSymbol(symbolName);
    free(symbolName);
    return symbol ? NSAddressOfSymbol(symbol) : NULL;
}
  #define GLCHAR char
  #define GLGETPROCADDRESS NSGLGetProcAddress
#elif defined (WIN32)
  #include <GL/glut.h>
  #define GLCHAR char
  #define GLGETPROCADDRESS wglGetProcAddress
#elif defined (sgi)
  #include <GL/gl.h>
  #include <GL/glx.h>
  #include <GL/glut.h>
  #define GLCHAR char
  #define GLGETPROCADDRESS glXGetProcAddress /*NULL;(void)*/ // Indigo2 R8000 Extreme has no glXGetProcAddress ??
#else
  #define GL_GLEXT_PROTOTYPES
  #include <GL/gl.h>
  #include <GL/glext.h>
  #include <GL/glx.h>
  #include <GL/glxext.h>
  #include <GL/glut.h>
  #define GLCHAR GLubyte
  #define GLGETPROCADDRESS glXGetProcAddressARB
#endif

#include "extensions.h"

/*
bool CheckExtension(const char *ext)
{
	const char *p = (const char *)glGetString(GL_EXTENSIONS);
	const char *end;
	if (p == NULL) return false;
	end = p + strlen(p);
	while (p < end)
	{
		GLuint n = strcspn(p, " ");
		if (strlen(ext) == n && strncmp(ext, p, n) == 0)
			return true;
		p += n + 1;
	}
	return false;
}
*/

#if defined(__APPLE__) || defined(__linux__)
glActiveTextureARBProcPtr			pfglActiveTextureARB = NULL;
glClientActiveTextureARBProcPtr		pfglClientActiveTextureARB = NULL;
glGenProgramsARBProcPtr				pfglGenProgramsARB  = NULL;
glDeleteProgramsARBProcPtr			pfglDeleteProgramsARB = NULL;
glBindProgramARBProcPtr				pfglBindProgramARB = NULL;
glProgramStringARBProcPtr			pfglProgramStringARB = NULL;
glProgramEnvParameter4fARBProcPtr	pfglProgramEnvParameter4fARB = NULL;
glGetProgramivARBProcPtr			pfglGetProgramivARB = NULL;
#endif

// Checks to see if a extension exists in the ext string
bool CheckExtension(const char* ext)
{

	char* extstring=0;
	
	extstring = new char[strlen((char*)glGetString(GL_EXTENSIONS)) + 1];
	strcpy(extstring,(char*)glGetString(GL_EXTENSIONS));

	if (strstr(extstring,ext))  {
		delete [] extstring;
		return true;
	}

	delete [] extstring;
	return false;
}


bool InitExtensionsARB(void)
{
#if defined(__APPLE__) || defined(__linux__)
	// GL_ARB_multitexture
	pfglActiveTextureARB          = (glActiveTextureARBProcPtr) GLGETPROCADDRESS((GLCHAR const*)"glActiveTextureARB");
	pfglClientActiveTextureARB    = (glClientActiveTextureARBProcPtr) GLGETPROCADDRESS((GLCHAR const*)"glClientActiveTextureARB");
	if (!pfglActiveTextureARB) return false;
	if (!pfglClientActiveTextureARB) return false;

        // GL_ARB_fragment_program
        pfglGenProgramsARB           = (glGenProgramsARBProcPtr) GLGETPROCADDRESS((GLCHAR const*)"glGenProgramsARB");
	pfglDeleteProgramsARB        = (glDeleteProgramsARBProcPtr) GLGETPROCADDRESS((GLCHAR const*)"glDeleteProgramsARB");
	pfglBindProgramARB           = (glBindProgramARBProcPtr) GLGETPROCADDRESS((GLCHAR const*)"glBindProgramARB");
	pfglProgramStringARB         = (glProgramStringARBProcPtr) GLGETPROCADDRESS((GLCHAR const*)"glProgramStringARB");
	pfglProgramEnvParameter4fARB = (glProgramEnvParameter4fARBProcPtr) GLGETPROCADDRESS((GLCHAR const*)"glProgramEnvParameter4fARB");
	pfglGetProgramivARB          = (glGetProgramivARBProcPtr) GLGETPROCADDRESS((GLCHAR const*)"glGetProgramivARB");
	if (!pfglGenProgramsARB) return false;
	if (!pfglDeleteProgramsARB) return false;
	if (!pfglBindProgramARB) return false;
	if (!pfglProgramStringARB) return false;
	if (!pfglProgramEnvParameter4fARB) return false;
	if (!pfglGetProgramivARB) return false;

#elif !defined(sgi)
	// everybody else
	// GL_ARB_multitexture
	glActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC) GLGETPROCADDRESS("glActiveTextureARB");
	glClientActiveTextureARB = (PFNGLCLIENTACTIVETEXTUREARBPROC) GLGETPROCADDRESS("glClientActiveTextureARB");

  // GL_ARB_fragment_program
  glGenProgramsARB           = (PFNGLGENPROGRAMSARBPROC) GLGETPROCADDRESS("glGenProgramsARB");
	glDeleteProgramsARB        = (PFNGLDELETEPROGRAMSARBPROC) GLGETPROCADDRESS("glDeleteProgramsARB");
	glBindProgramARB           = (PFNGLBINDPROGRAMARBPROC) GLGETPROCADDRESS("glBindProgramARB");
	glProgramStringARB         = (PFNGLPROGRAMSTRINGARBPROC) GLGETPROCADDRESS("glProgramStringARB");
	glProgramEnvParameter4fARB = (PFNGLPROGRAMENVPARAMETER4FARBPROC) GLGETPROCADDRESS("glProgramEnvParameter4fARB");
	glGetProgramivARB          = (PFNGLGETPROGRAMIVARBPROC) GLGETPROCADDRESS("glGetProgramivARB");

#endif
  return true;
}


bool InitExtensionsATI(void)
{
#if defined(WIN32)
  // GL_EXT_texture3D
	glTexImage3DEXT = (PFNGLTEXIMAGE3DEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glTexImage3DEXT");
	//if (!glTexImage3DEXT) return false;

	// GL_ATI_vertex_array_object
	glNewObjectBufferATI = (PFNGLNEWOBJECTBUFFERATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glNewObjectBufferATI");
	glIsObjectBufferATI = (PFNGLISOBJECTBUFFERATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glIsObjectBufferATI");
	glUpdateObjectBufferATI = (PFNGLUPDATEOBJECTBUFFERATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glUpdateObjectBufferATI");
	glGetObjectBufferfvATI = (PFNGLGETOBJECTBUFFERFVATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetObjectBufferfvATI");
	glGetObjectBufferivATI = (PFNGLGETOBJECTBUFFERIVATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetObjectBufferivATI");
	glFreeObjectBufferATI = (PFNGLFREEOBJECTBUFFERATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glFreeObjectBufferATI");
	glArrayObjectATI = (PFNGLARRAYOBJECTATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glArrayObjectATI");
	glGetArrayObjectfvATI = (PFNGLGETARRAYOBJECTFVATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetArrayObjectfvATI");
	glGetArrayObjectivATI = (PFNGLGETARRAYOBJECTIVATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetArrayObjectivATI");
	glVariantArrayObjectATI = (PFNGLVARIANTARRAYOBJECTATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glVariantArrayObjectATI");
	glGetVariantArrayObjectfvATI = (PFNGLGETVARIANTARRAYOBJECTFVATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetVariantArrayObjectfvATI");
	glGetVariantArrayObjectivATI = (PFNGLGETVARIANTARRAYOBJECTIVATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetVariantArrayObjectivATI");
	//if (!glNewObjectBufferATI) return false;
	//if (!glIsObjectBufferATI) return false;
	//if (!glUpdateObjectBufferATI) return false;
	//if (!glGetObjectBufferfvATI) return false;
	//if (!glGetObjectBufferivATI) return false;
	//if (!glFreeObjectBufferATI) return false;
	//if (!glArrayObjectATI) return false;
	//if (!glGetArrayObjectfvATI) return false;
	//if (!glGetArrayObjectivATI) return false;
	//if (!glVariantArrayObjectATI) return false;
	//if (!glGetVariantArrayObjectfvATI) return false;
	//if (!glGetVariantArrayObjectivATI) return false;

	// GL_ATI_element_array
	glElementPointerATI = (PFNGLELEMENTPOINTERATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glElementPointerATI");
	glDrawElementArrayATI = (PFNGLDRAWELEMENTARRAYATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glDrawElementArrayATI");
	glDrawRangeElementArrayATI = (PFNGLDRAWRANGEELEMENTARRAYATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glDrawRangeElementArrayATI");
	//if (!glElementPointerATI) return false;
	//if (!glDrawElementArrayATI) return false;
	//if (!glDrawRangeElementArrayATI) return false;

	// GL_EXT_vertex_shader
	glBeginVertexShaderEXT = (PFNGLBEGINVERTEXSHADEREXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glBeginVertexShaderEXT");
	glEndVertexShaderEXT = (PFNGLENDVERTEXSHADEREXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glEndVertexShaderEXT");
	glBindVertexShaderEXT = (PFNGLBINDVERTEXSHADEREXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glBindVertexShaderEXT");
	glGenVertexShadersEXT = (PFNGLGENVERTEXSHADERSEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGenVertexShadersEXT");
	glDeleteVertexShaderEXT = (PFNGLDELETEVERTEXSHADEREXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glDeleteVertexShaderEXT");
	glShaderOp1EXT = (PFNGLSHADEROP1EXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glShaderOp1EXT");
	glShaderOp2EXT = (PFNGLSHADEROP2EXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glShaderOp2EXT");
	glShaderOp3EXT = (PFNGLSHADEROP3EXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glShaderOp3EXT");
	glSwizzleEXT = (PFNGLSWIZZLEEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glSwizzleEXT");
	glWriteMaskEXT = (PFNGLWRITEMASKEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glWriteMaskEXT");
	glInsertComponentEXT = (PFNGLINSERTCOMPONENTEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glInsertComponentEXT");
	glExtractComponentEXT = (PFNGLEXTRACTCOMPONENTEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glExtractComponentEXT");
	glGenSymbolsEXT = (PFNGLGENSYMBOLSEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGenSymbolsEXT");
	glSetInvariantEXT = (PFNGLSETINVARIANTEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glSetInvariantEXT");
	glSetLocalConstantEXT = (PFNGLSETLOCALCONSTANTEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glSetLocalConstantEXT");
	glVariantbvEXT = (PFNGLVARIANTBVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glVariantbvEXT");
	glVariantsvEXT = (PFNGLVARIANTSVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glVariantsvEXT");
	glVariantivEXT = (PFNGLVARIANTIVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glVariantivEXT");
	glVariantfvEXT = (PFNGLVARIANTFVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glVariantfvEXT");
	glVariantdvEXT = (PFNGLVARIANTDVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glVariantdvEXT");
	glVariantubvEXT = (PFNGLVARIANTUBVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glVariantubvEXT");
	glVariantusvEXT = (PFNGLVARIANTUSVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glVariantusvEXT");
	glVariantuivEXT = (PFNGLVARIANTUIVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glVariantuivEXT");
	glVariantPointerEXT = (PFNGLVARIANTPOINTEREXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glVariantPointerEXT");
	glEnableVariantClientStateEXT = (PFNGLENABLEVARIANTCLIENTSTATEEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glEnableVariantClientStateEXT");
	glDisableVariantClientStateEXT = (PFNGLDISABLEVARIANTCLIENTSTATEEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glDisableVariantClientStateEXT");
	glBindLightParameterEXT = (PFNGLBINDLIGHTPARAMETEREXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glBindLightParameterEXT");
	glBindMaterialParameterEXT = (PFNGLBINDMATERIALPARAMETEREXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glBindMaterialParameterEXT");
	glBindTexGenParameterEXT = (PFNGLBINDTEXGENPARAMETEREXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glBindTexGenParameterEXT");
	glBindTextureUnitParameterEXT = (PFNGLBINDTEXTUREUNITPARAMETEREXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glBindTextureUnitParameterEXT");
	glBindParameterEXT = (PFNGLBINDPARAMETEREXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glBindParameterEXT");
	glIsVariantEnabledEXT = (PFNGLISVARIANTENABLEDEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glIsVariantEnabledEXT");
	glGetVariantBooleanvEXT = (PFNGLGETVARIANTBOOLEANVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetVariantBooleanvEXT");
	glGetVariantIntegervEXT = (PFNGLGETVARIANTINTEGERVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetVariantIntegervEXT");
	glGetVariantFloatvEXT = (PFNGLGETVARIANTFLOATVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetVariantFloatvEXT");
	glGetVariantPointervEXT = (PFNGLGETVARIANTPOINTERVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetVariantPointervEXT");
	glGetInvariantBooleanvEXT = (PFNGLGETINVARIANTBOOLEANVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetInvariantBooleanvEXT");
	glGetInvariantIntegervEXT = (PFNGLGETINVARIANTINTEGERVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetInvariantIntegervEXT");
	glGetInvariantFloatvEXT = (PFNGLGETINVARIANTFLOATVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetInvariantFloatvEXT");
	glGetLocalConstantBooleanvEXT = (PFNGLGETLOCALCONSTANTBOOLEANVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetLocalConstantBooleanvEXT");
	glGetLocalConstantIntegervEXT = (PFNGLGETLOCALCONSTANTINTEGERVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetLocalConstantIntegervEXT");
	glGetLocalConstantFloatvEXT = (PFNGLGETLOCALCONSTANTFLOATVEXTPROC)GLGETPROCADDRESS((GLCHAR const*)"glGetLocalConstantFloatvEXT");

	// GL_ATI_fragment_shader
	glGenFragmentShadersATI = (PFNGLGENFRAGMENTSHADERSATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glGenFragmentShadersATI");
	glBindFragmentShaderATI = (PFNGLBINDFRAGMENTSHADERATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glBindFragmentShaderATI");
	glDeleteFragmentShaderATI = (PFNGLDELETEFRAGMENTSHADERATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glDeleteFragmentShaderATI");
	glBeginFragmentShaderATI = (PFNGLBEGINFRAGMENTSHADERATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glBeginFragmentShaderATI");
	glEndFragmentShaderATI = (PFNGLENDFRAGMENTSHADERATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glEndFragmentShaderATI");
	glPassTexCoordATI = (PFNGLPASSTEXCOORDATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glPassTexCoordATI");
	glSampleMapATI = (PFNGLSAMPLEMAPATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glSampleMapATI");
	glColorFragmentOp1ATI = (PFNGLCOLORFRAGMENTOP1ATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glColorFragmentOp1ATI");
	glColorFragmentOp2ATI = (PFNGLCOLORFRAGMENTOP2ATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glColorFragmentOp2ATI");
	glColorFragmentOp3ATI = (PFNGLCOLORFRAGMENTOP3ATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glColorFragmentOp3ATI");
	glAlphaFragmentOp1ATI = (PFNGLALPHAFRAGMENTOP1ATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glAlphaFragmentOp1ATI");
	glAlphaFragmentOp2ATI = (PFNGLALPHAFRAGMENTOP2ATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glAlphaFragmentOp2ATI");
	glAlphaFragmentOp3ATI = (PFNGLALPHAFRAGMENTOP3ATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glAlphaFragmentOp3ATI");
	glSetFragmentShaderConstantATI = (PFNGLSETFRAGMENTSHADERCONSTANTATIPROC)GLGETPROCADDRESS((GLCHAR const*)"glSetFragmentShaderConstantATI");
	if (!glGenFragmentShadersATI) return false;
	if (!glBindFragmentShaderATI) return false;
	if (!glDeleteFragmentShaderATI) return false;
	if (!glBeginFragmentShaderATI) return false;
	if (!glEndFragmentShaderATI) return false;
	if (!glPassTexCoordATI) return false;
	if (!glSampleMapATI) return false;
	if (!glColorFragmentOp1ATI) return false;
	if (!glColorFragmentOp2ATI) return false;
	if (!glColorFragmentOp3ATI) return false;
	if (!glAlphaFragmentOp1ATI) return false;
	if (!glAlphaFragmentOp2ATI) return false;
	if (!glAlphaFragmentOp3ATI) return false;
	if (!glSetFragmentShaderConstantATI) return false;

#endif
	return true;
}
