#pragma once
#include "VertexProgram.h"


/**
 * Class for Mandelbrot using ATI Vertex Programs
 * Author: Daniele Paccaloni, GPU Vertex Program based on algo by Erik Lindholm (nVidia)
 */
class VertexProgramNV : public VertexProgram
{
protected:
  bool isValid_;

public:
  VertexProgramNV(int iters, int w, int h, double ax, double ay, double ex, double ey);
  virtual ~VertexProgramNV(void);
  virtual bool isValid(void);
  bool initialize(int iters, int w, int h, double ax, double ay, double ex, double ey);
  bool setOrtho2D(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top);
  virtual void prepareWorldSpace(int w, int h, double ax, double ay, double ex, double ey);
  virtual bool checkRequiredExtensions(void);
protected:
  bool initializeGPU_VP(int iters, int w, int h, double ax, double ay, double ex, double ey);

};

