#pragma once
#include "VertexProgram.h"

/**
 * Class for Mandelbrot using ATI Vertex Programs
 * Author: Daniele Paccaloni
 */
class VertexProgramATI : public VertexProgram
{
protected:
  bool isValid_;
  GLuint xform_; // Vertex Shader ID

public:
  VertexProgramATI(int iters, int w, int h, double ax, double ay, double ex, double ey);
  virtual ~VertexProgramATI(void);
  virtual bool isValid(void);
  bool initialize(int iters, int w, int h, double ax, double ay, double ex, double ey);
  bool setOrtho2D(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top);
  virtual void prepareWorldSpace(int w, int h, double ax, double ay, double ex, double ey);
protected:
  // Check for required extensions
  virtual bool checkRequiredExtensions(void);

};

