// File: RELAXPrinter.java - last edit: 
// NANBA Ryosuke 2000-09-16

package com.horobi.relax;

// Copyright (c) 2000 by MURATA Makoto, NANBA Ryosuke.

import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import java.io.PrintWriter;

public class RELAXPrinter implements SAXPrinter {
	PrintWriter writer;
	String tag;
	String indent;
	boolean inImplicitTagSection;

	String step = "  ";

	public RELAXPrinter() {
	}
	public RELAXPrinter(PrintWriter writer) {
		setWriter(writer);
	}
	public void setWriter(PrintWriter writer) {
		this.writer = writer;
	}

	public void setDocumentLocator(Locator locator) {}
	public void startDocument() throws SAXException {
		tag = null;
		indent = "";
		inImplicitTagSection = false;
	}
	public void endDocument() throws SAXException {}
	public void startElement(String name, AttributeList atts)
		throws SAXException {
		String space = " ";
		if(tag != null)
			flushATag();
		tag = "";
		if(name.equals("module"))
			space = "\n        ";
		if(name.equals("tag")
		   || name.equals("interface")
		   || name.equals("elementRule")
		   || name.equals("hedgeRule"))
			tag += "\n";
		tag += indent + "<" + name;
		int n = atts.getLength();
		for(int i=0; i<n; i++){
			tag += space + atts.getName(i) + "=" 
				+ "\"" + atts.getValue(i) + "\"";
		}
		indent += step;
		if(inImplicitTagSection && !name.equals("tag"))
			inImplicitTagSection = false;
	}
	public void endElement(String name) throws SAXException {
		indent = indent.substring(step.length());
		if(tag != null){
			if(inImplicitTagSection)
				tag = tag.substring(1); // remove tag[0](=='\n').
			flushEmptyTag();
			if(name.equals("tag"))
				inImplicitTagSection = true;
		}else{
			writer.println(indent + "</" + name + ">");
		}
	}

	public void characters(char ch[], int start, int length)
		throws SAXException {
		if(tag != null)
			flushATag();
		// TBD:
	}

	public void ignorableWhitespace(char ch[], int start, int length)
		throws SAXException {
		if(tag != null)
			flushATag();
		// TBD:
	}

	public void processingInstruction (String target, String data)
		throws SAXException {
		if(tag != null)
			flushATag();
		// TBD:
	}

	protected void flushEmptyTag() {
		tag += "/>";
		writer.println(tag);
		tag = null;
	}
	protected void flushATag() {
		tag += ">";
		writer.println(tag);
		tag = null;
	}
}
