// File: EasyRELAXPrinter.java - last edit: 
// Ryosuke Nanba 2000-09-13

package com.horobi.relax;

// Copyright (c) 2000 by MURATA Makoto, NANBA Ryosuke.

import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import java.io.PrintWriter;
import java.util.Vector;
import java.util.Hashtable;

/** Easy to read RELAX Printer. this printer only supports input
 *  generated by DTD2RELAX. */
public class EasyRELAXPrinter implements SAXPrinter {
	PrintWriter writer;

	Vector elementRules;
	Hashtable tags;
	Vector hedgeRules;
	String current;
	String currentRole;
	String indent;
	boolean start;

	String step = "  ";
	
	class Rule {
		String role;
		String content;
		Rule(String roleValue) { role = roleValue; }
		public String toString() { return content; }
	}

	public EasyRELAXPrinter(PrintWriter writer) {
		setWriter(writer);
	}
	protected void printModuleContent() {
		for(int i=0; i < elementRules.size(); i++){
			Rule elementRule = (Rule)elementRules.elementAt(i);
			writer.print((String)tags.get(elementRule.role));
			writer.println(elementRule);
		}
		for(int i=0; i < hedgeRules.size(); i++){
			writer.print((String)hedgeRules.elementAt(i));
		}
		elementRules = null;
		tags = null;
		hedgeRules = null;
	}
	protected String attsToString(AttributeList atts, String space) {
		String str = "";
		int n = atts.getLength();
		for(int i=0; i<n; i++){
			str += space + atts.getName(i) + "=" 
				+ "\"" + atts.getValue(i) + "\"";
		}
		return str;
	}

	//// implements SAXPrinter
	public void setWriter(PrintWriter writer) {
		this.writer = writer;
	}

	//// implements DocumentHandler
	public void setDocumentLocator(Locator locator) {}
	public void startDocument() throws SAXException {
		indent = "";
		start = false;
	}
	public void endDocument() throws SAXException {
	}
	public void startElement(String name, AttributeList atts)
		throws SAXException {
		if(start && current != null)
			current += ">\n";
		if(name.equals("module")){
			elementRules = new Vector();
			tags = new Hashtable();
			hedgeRules = new Vector();
			writer.println("<" + name + attsToString(atts, "\n        ")+">");
		}else if(name.equals("interface")
				 || name.equals("elementRule")
				 || name.equals("tag")
				 || name.equals("hedgeRule")){
			current = indent + "<" + name + attsToString(atts, " ");
			if(name.equals("tag")){
				currentRole = atts.getValue("name");
			}else if(name.equals("elementRule")){
				currentRole = atts.getValue("role");
			}
		}else if(current != null){
			current += indent + "<" + name + attsToString(atts, " ");
		}else{
			// ignore...
		}
		indent += step;
		start = true;
	}
	public void endElement(String name) throws SAXException {
		indent = indent.substring(step.length());
		if(name.equals("module")){
			printModuleContent();
			writer.println(indent + "</module>");
			elementRules = null;
			tags = null;
			hedgeRules = null;
		}else if(current != null){
			if(start){ // empty tag.
				current += "/>\n";
			}else{
				current += indent + "</" + name + ">\n";
			}
			if(name.equals("interface")){
				writer.println(current);
				current = null;
			}else if(name.equals("elementRule")){
				Rule rule = new Rule(currentRole);
				rule.content = current;
				elementRules.addElement(rule);
				current = null;
				currentRole = null;
			}else if(name.equals("tag")){
				tags.put(currentRole, current);
				current = null;
				currentRole = null;
			}else if(name.equals("hedgeRule")){
				hedgeRules.addElement(current);
				current = null;
			}else{
				; // do nothing.
			}
		}
		start = false;
	}

	public void characters(char ch[], int st, int len)
		throws SAXException {
		if(start && current != null)
			current += ">\n";
		start = false;
	}

	public void ignorableWhitespace(char ch[], int st, int len)
		throws SAXException {
		if(start && current != null)
			current += ">\n";
		start = false;
	}

	public void processingInstruction (String target, String data)
		throws SAXException {
		if(start && current != null)
			current += ">\n";
		start = false;
	}
}
