// File: DTD2RELAX.java - last edit: 
// ʥХ祦 2000-3-22

// Copyright (c) 2000 by NANBA Ryosuke.

package com.horobi.relax;

import com.ibm.xml.parser.MIME2Java;
import org.xml.sax.SAXException;
import java.awt.event.*;
import javax.swing.JFrame;
import java.io.*;

/* DTDtoRELAXConverterGUI: DTD ޤ RELAX ޤѴ GUI 
 * ץꥱǤ. 
 * @author NANBA Ryosuke
 * @version $Id: DTDtoRELAXConverterGUI.java,v 1.5 2000/05/07 15:37:58 rnanba Exp $ 
 */
public class DTDtoRELAXConverterGUI implements FileConverter {

	public static void main(String args[]) {
		FileConverter converter = new DTDtoRELAXConverterGUI();
		ConverterPanel app = new ConverterPanel(converter);
		JFrame f = new JFrame(converter.getName());
		f.addWindowListener(new WindowAdapter() {
			public void windowClosed(WindowEvent we) { System.exit(0); }
			public void windowClosing(WindowEvent we) { System.exit(0); }
		});
		f.getContentPane().add(app);
		f.pack();
		f.setVisible(true);
		app.revalidate();
	}

	public String getName() {
		return "DTD to RELAX Converter version "+ DTD2RELAX.getVersion();
	}
	public boolean accept(File file) {
		if(file.isFile()){
			String name = file.getName();
			return (name.endsWith(".dtd") || name.endsWith(".DTD"));
		}else{
			return false;
		}
	}
	public String getInputFileDescription() {
		return "*.dtd (DTD Files)";
	}
	public String getOutputFileName(File input) {
		if(!input.isFile())
			return null;
		String name = input.getName();
		int i = name.lastIndexOf(".");
		if(i > 0 && !name.startsWith(".")) // "foo.dtd" etc.
			name = name.substring(0, i);
		//else // "foo", ".foo", "..foo" etc.
		return name + ".rlx";
	}
	public String[] getOptionNames() {
		return new String[] {
			"Top level element",
			"Output encoding",
		};
	}
	public Object[] getOptionDefaults() {
		String encDefaults[] = new String[] {
			"UTF-16", "UTF-8",
		};
		return new Object[] {
			"",
			encDefaults,
		};
	}

	public void convert(File input, File output, String[] options)
		throws IOException, FileNotFoundException {
		InputStream is = new FileInputStream(input);

		FileOutputStream fos = new FileOutputStream(output);
		String mimeCharsetName = options[OUTPUT_ENCODING];
		String encoding;
		OutputStreamWriter osw;
		if(mimeCharsetName == null || mimeCharsetName.length() == 0)
			osw = new OutputStreamWriter(fos);
		else{
			encoding = DTD2RELAX.convertEncoding(mimeCharsetName);
			if(encoding == null)
				throw new IOException("unsupported encoding: '"
									  + mimeCharsetName + "'");
			osw = new OutputStreamWriter(fos, encoding);
		}
		try{
			DTD2RELAX.printSchema(input.getAbsolutePath(), 
								  options[TOP_LEVEL_ELEMENT],
								  new PrintWriter(osw),  
								  mimeCharsetName);
		}catch(SAXException e){
			throw new IOException(e.getMessage());
		}catch(RuntimeException e){
			throw new IOException(e.getMessage());
		}
	}

	static final int TOP_LEVEL_ELEMENT = 0;
	static final int OUTPUT_ENCODING = 1;
}
