// File: DTD2RELAX.java - last edit: 
// NANBA Ryosuke 2000-09-16

// Copyright (c) 2000 by MURATA Makoto, NANBA Ryosuke.

package com.horobi.relax;

//// imports
import com.ibm.xml.parser.MIME2Java;
import org.xml.sax.SAXException;
import java.io.*;
import java.util.*;

/* DTD2RELAX: convert specified DTD file to RELAX module file.
 * @author MURATA Makoto, NANBA Ryosuke
 * @version $Id: DTD2RELAX.java,v 1.16 2000/09/24 03:30:08 nanba Exp $
 */
public class DTD2RELAX {
	static String encoding = "utf-8";
	static final String RELAX_XMLNS = "http://www.xml.gr.jp/xmlns/relaxCore";
	static final String VERSION = "1.1.1";

	static final String PRINTER_KEY = "com.horobi.relax.printer";

	public static String getVersion() {
		return VERSION;
	}
	static int getOptions(String args[]) {
		int i=0;
		while(i < args.length && args[i].charAt(0) == '-'){
			if(args[i].equals("-e")){
				encoding = args[++i];
			}
			i++;
		}
		return i;
	}
	static void usage() {
		System.err.println("java com.horobi.relax.DTD2RELAX "
						   + "[-e encoding] "
						   + "dtdFile [relaxFile] topLevelElem");
	}
	public static String convertEncoding(String mimeEnc) {
		String javaEnc = MIME2Java.convert(mimeEnc);
		if(javaEnc == null){
			if(mimeEnc.equalsIgnoreCase("UTF-16"))
				javaEnc = "Unicode";
			/* FIXME:
			 * 'UnicodeLittle' and 'UnicodeBig' has BOM.
			 * 'UTF-16LE' and 'UTF-16BE' has no BOM. */
			//else if(mimeEnc.equalsIgnoreCase("UTF-16LE"))
			//	javaEnc = "UnicodeLittle";
			//else if(mimeEnc.equalsIgnoreCase("UTF-16BE"))
			//	javaEnc = "UnicodeBig";
		}
		return javaEnc;
	}
    public static void main(String args[])
		throws UnsupportedEncodingException,FileNotFoundException,IOException {
		int shift = getOptions(args);
		if (args.length - shift < 2 
			|| args.length - shift > 3) {
			usage();
			return;
		}
		String inputFilename = args[0 + shift];
		String outputFilename = null;
		String topLevelElement = null;
		if(args.length - shift == 2){ // console output mode.
			topLevelElement = args[1 + shift];
		}else{ // normal mode.
			outputFilename = args[1 + shift];
			topLevelElement = args[2 + shift];
		}
		PrintWriter os;
		
		if(inputFilename == null){
			System.err.println("Specify a DTD file name.");
			return;
		}

		String javaenc = convertEncoding(encoding);
		if(javaenc == null){
			System.err.println("unsupported encoding: '"+encoding+"'");
			return;
		}
		if(outputFilename != null){
			FileOutputStream fos = new FileOutputStream(outputFilename);
			OutputStreamWriter osw = new OutputStreamWriter(fos, javaenc);
			os = new PrintWriter(osw);
		}else{
			OutputStreamWriter osw = new OutputStreamWriter(System.out,
															javaenc);
			os = new PrintWriter(osw);
		}
		try{
			printSchema(inputFilename, topLevelElement, os, encoding);
		}catch(SAXException e){
			System.err.println(e);
		}catch(RuntimeException e){
			System.err.println(e);
		}catch(FileNotFoundException e){
			System.err.println(e);
		}catch(IOException e){
			System.err.println(e);
		}
	}

    static void printSchema(String inputFilename, String topLevelElement,
							PrintWriter writer, String encoding)
		throws SAXException, RuntimeException,
			   FileNotFoundException, IOException {
		DTD2RELAXParser dtd2relax = new DTD2RELAXParser();
		dtd2relax.setFinalElementType(topLevelElement);

		String printerClass = System.getProperty(PRINTER_KEY);
		SAXPrinter printer;
		if(printerClass != null){
			try{
				printer = (SAXPrinter)Class.forName(printerClass)
					.newInstance();
				printer.setWriter(writer);
			}catch(Exception e){
				throw new RuntimeException(e.toString());
			}
		}else{
			printer = new EasyRELAXPrinter(writer);
		}
		dtd2relax.setDocumentHandler(printer);

		if(encoding != null && encoding.length() > 0){
			writer.print("<?xml version=\"1.0\" ");
			writer.println("encoding=\""+encoding+"\"?>");
		}
		writer.println("<!-- generated by DTD2RELAX " + VERSION + " -->");
		dtd2relax.parse(inputFilename);
		writer.close();
	}
}
