<?php
/**
 * Project: 
 * Contenido Content Management System
 * 
 * Description: 
 * Display rights
 * 
 * Requirements: 
 * @con_php_req 5.0
 * 
 *
 * @package    Contenido Backend includes
 * @version    1.3.1
 * @author     Timo A. Hummel, Jan Lengowski
 * @copyright  four for business AG <www.4fb.de>
 * @license    http://www.contenido.org/license/LIZENZ.txt
 * @link       http://www.4fb.de
 * @link       http://www.contenido.org
 * @since      file available since contenido release <= 4.6
 * 
 * {@internal 
 *   created 2003-04-30
 *   modified 2008-06-27, Frederic Schneider, add security fix
 *
 *   $Id: include.lang_edit.php 351 2008-06-27 11:30:37Z frederic.schneider $:
 * }}
 * 
 */

if(!defined('CON_FRAMEWORK')) {
	die('Illegal call');
}

cInclude("classes", "class.htmlelements.php");
cInclude("classes", "class.ui.php");

includePlugins("languages");

$clang = new Language;
$clang->loadByPrimaryKey($idlang);

#Script for refreshing Language Box in Header
$newOption = '';

$db2 = new DB_Contenido;

$sReload = '<script language="javascript">
                var left_bottom = top.content.left.left_bottom;

                if (left_bottom) {
                    var href = left_bottom.location.href;
                    href = href.replace(/&idlang[^&]*/, \'\');
                    left_bottom.location.href = href+"&idlang="+"'.$idlang.'";
                }
            </script>';

if ($action == "lang_newlanguage" || $action == "lang_deletelanguage")
{
    	$page = new UI_Page;
        
        if ($action == "lang_deletelanguage") {
            // finally delete from dropdown in header
            $newOption = '<script>';
            $newOption .= 'var langList = top.header.document.getElementById("cLanguageSelect");';
            $newOption .= 'var thepos="";';
            $newOption .= 'for(var i=0;i<langList.length;i++)';
            $newOption .= '{';
            $newOption .= 'if(langList.options[i].value == '.$idlang.')';
            $newOption .= ' {';
            $newOption .= ' thepos = langList.options[i].index;';
            $newOption .= ' }';
            $newOption .= '}';
            $newOption .= 'langList.remove(thepos);';
            $newOption .= '</script>';
        }
        
        if ($action == "lang_newlanguage") {
            // update language dropdown in header
            $new_idlang = 0;
            $sSql = 'SELECT max(idlang) as newlang FROM '.$cfg["tab"]["lang"].';';
            $db->query($sSql);
            if ($db->next_record()) {
                $new_idlang = $db->f('newlang');
            }

            $newOption = '<script language="javascript">';
            $newOption .= 'var newLang = new Option("'.i18n("New language").' ('.$new_idlang.')", "'.$new_idlang.'", false, false);';
            $newOption .= 'var langList = top.header.document.getElementById("cLanguageSelect");';
            $newOption .= 'langList.options[langList.options.length] = newLang;';
            $newOption .= '</script>';
            $idlang = $new_idlang;
        }
        
        if ($targetclient == $client) {
            $page->addScript('refreshHeader', $newOption);
        }
        $page->addScript('reload', $sReload);
    	$page->render();	
} else
{
	if ($action == "lang_edit")
	{
		callPluginStore("languages");
		
		$language = new Language;
    	$language->loadByPrimaryKey($idlang);
    	
    	$language->setProperty("dateformat", "full", stripslashes($datetimeformat));
    	$language->setProperty("dateformat", "date", stripslashes($dateformat));
    	$language->setProperty("dateformat", "time", stripslashes($timeformat));
        
        // update dropdown in header
        $newOption = '<script language="javascript">';
        $newOption .= 'var langList = top.header.document.getElementById("cLanguageSelect");';
        $newOption .= 'var thepos="";';
        $newOption .= 'for(var i=0;i<langList.length;i++)';
        $newOption .= '{';
        $newOption .= 'if(langList.options[i].value == '.$idlang.')';
        $newOption .= ' {';
        $newOption .= ' langList.options[i].innerHTML = \''.$langname.' ('.$idlang.')\';';
        $newOption .= ' }';
        $newOption .= '}';
        $newOption .= '</script>';
	}
    if(!$perm->have_perm_area_action($area, $action))
    {
    
      $notification->displayNotification("error", i18n("Permission denied"));
      
    } else {
    
    if ( !isset($idlang) && $action != "lang_new")
    {
      $notification->displayNotification("error", "no language id given. Usually, this shouldn't happen, except if you played around with your system. if you didn't play around, please report a bug.");
    
    } else {
    
        if (($action == "lang_edit") && ($perm->have_perm_area_action($area, $action)))
        {
        	langEditLanguage($idlang, $langname, $sencoding, $active, $direction);
            $noti = $notification->returnNotification("info", i18n("Changes saved"))."<br>";
        } 
    
    
        $tpl->reset();
        
        $sql = "SELECT
                    A.idlang AS idlang, A.name AS name, A.active as active, A.encoding as encoding, A.direction as direction,
    				B.idclient AS idclient 
                FROM
                    ".$cfg["tab"]["lang"]." AS A,
    				".$cfg["tab"]["clients_lang"]." AS B
                WHERE
                    A.idlang = '".Contenido_Security::toInteger($idlang)."' AND
    				B.idlang = '".Contenido_Security::toInteger($idlang)."'";
    
        $db->query($sql);
        $db->next_record();
    
    	$form = new UI_Table_Form("lang_properties");
    	$form->setVar("idlang", $idlang);
    	$form->setVar("targetclient", $db->f("idclient"));
    	$form->setVar("action", "lang_edit");
    	$form->setVar("area", $area);
    	$form->setVar("frame", $frame);
    	
    	$form->addHeader(i18n("Edit language"));
    	
    	$eselect = new cHTMLSelectElement("sencoding");
    	
    	$charsets = array();
    	
    	foreach ($cfg['AvailableCharsets'] as $charset)
    	{
    		$charsets[$charset] = $charset;	
    	}
    	
    	$eselect->autoFill($charsets);
    	$eselect->setDefault($db->f("encoding"));
    	
    	$form->add(i18n("Language name"), formGenerateField ("text", "langname", htmlspecialchars($db->f("name")), 40, 255));
    	$form->add(i18n("Encoding"), $eselect);
    	
    	$directionSelect = new cHTMLSelectElement("direction");
    	$directionSelect->autoFill(array("ltr" => i18n("Left to right"), "rtl" => i18n("Right to left")));
    	$directionSelect->setDefault($db->f("direction"));
    	
    	$form->add(i18n("Text direction"), $directionSelect);
    	
    	$form->add(i18n("Active"), formGenerateCheckbox ("active", "1",$db->f("active")));
        
		displayPlugin("languages", $form);
    
        if ($error)
        {
            echo $error;
        }
    
    	$language = new Language;
    	$language->loadByPrimaryKey($idlang);
    	
    	$fulldateformat = new cHTMLTextbox("datetimeformat", $language->getProperty("dateformat", "full"), 30);
    	$dateformat = new cHTMLTextbox("dateformat", $language->getProperty("dateformat", "date"), 30);
    	$timeformat = new cHTMLTextbox("timeformat", $language->getProperty("dateformat", "time"), 30);
    	
      	$form->add(i18n("Date/Time format"), $fulldateformat->render()); 
      	$form->add(i18n("Date format"), $dateformat->render());
      	$form->add(i18n("Time format"), $timeformat->render());
    
    	$page = new UI_Page;
    	$page->setContent($noti.$form->render());
        if ($targetclient == $client) {
            $page->addScript('refreshHeader', $newOption);
        }
        if ($_REQUEST['action'] != '') {
            $page->addScript('reload', $sReload);
        }
    	$page->render();
    }
    } 
}
?>