/* "CodeWorker":	a scripting language for parsing and generating text.

Copyright (C) 1996-1997, 1999-2002 Cdric Lemaire

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

To contact the author: codeworker@free.fr
*/

#ifdef WIN32
#pragma warning (disable : 4786)
#endif

#include "ExprScriptFunction.h"
#include "DtaProject.h"
#include "CppParsingTree.h"
#include "GrfReadonlyHook.h"

namespace CodeWorker {
	GrfReadonlyHook::GrfReadonlyHook(GrfBlock* pParent) : GrfFunction(pParent, "readonlyHook", "", false), _readonlyHook(NULL) {
		DtaProject::getInstance().setReadonlyHook(this);
	}

	GrfReadonlyHook::GrfReadonlyHook(READONLYHOOK_FUNCTION readonlyHook) : GrfFunction(NULL, "readonlyHook", "", false), _readonlyHook(readonlyHook) {
		DtaProject::getInstance().setReadonlyHook(this);
	}

	GrfReadonlyHook::~GrfReadonlyHook() {
		if (DtaProject::existInstance()) DtaProject::getInstance().setReadonlyHook(NULL);
	}

	bool GrfReadonlyHook::setParameterName(const char* sFilenameVariable) {
		if (!getParameterTypes().empty()) return false;
		return addParameterAndType(sFilenameVariable, VALUE_EXPRTYPE, NULL);
	}

	SEQUENCE_INTERRUPTION_LIST GrfReadonlyHook::executeHook(DtaScriptVariable& visibility, const std::string& sReadonlyFile) {
		if (_readonlyHook != NULL) {
			_readonlyHook(sReadonlyFile);
		} else {
			std::auto_ptr<ExprScriptFunction> pFunctionCall(new ExprScriptFunction(this));
			pFunctionCall->addParameter(new ExprScriptConstant(sReadonlyFile.c_str()));
			launchExecution(visibility, *pFunctionCall);
		}
		return NO_INTERRUPTION;
	}
}
