//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2008 by Eran Ifrah                            
// file name            : replaceinfilespanel.h              
//                                                                          
// -------------------------------------------------------------------------
// A                                                                        
//              _____           _      _     _ _                            
//             /  __ \         | |    | |   (_) |                           
//             | /  \/ ___   __| | ___| |    _| |_ ___                      
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )                     
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/                     
//              \____/\___/ \__,_|\___\_____/_|\__\___|                     
//                                                                          
//                                                  F i l e                 
//                                                                          
//    This program is free software; you can redistribute it and/or modify  
//    it under the terms of the GNU General Public License as published by  
//    the Free Software Foundation; either version 2 of the License, or     
//    (at your option) any later version.                                   
//                                                                          
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
 #ifndef __replaceinfilespanel__
#define __replaceinfilespanel__

/**
@file
Subclass of ReplaceInFilesBasePanel, which is generated by wxFormBuilder.
*/

#include "replaceinfilesbasepanel.h"
#include "search_thread.h"


/** Implementing ReplaceInFilesBasePanel */
class ReplaceInFilesPanel : public ReplaceInFilesBasePanel
{
	wxString m_findWhat;
	wxArrayString m_results;
	size_t m_flags;
	
protected:

	// Handlers for ReplaceInFilesBasePanel events.
	void OnItemSelected( wxCommandEvent& event );
	void OnItemDClicked( wxCommandEvent& event );
	void OnReplaceAll( wxCommandEvent& event );
	void OnReplaceAllUI( wxUpdateUIEvent& event );
	void OnClearResults(wxCommandEvent &e);
	void OnClearResultsUI( wxUpdateUIEvent& event );
	
	//private methods
	void DoReplaceSelection();
	void ParseEntry(int index, long &line, long &col, long &matchLen, wxString &fileName, wxString &pattern);
	void AdjustItems(unsigned int from, int diff, const wxString &fileName, long line);
	void GetFileArray(wxArrayString &files);
	
public:
	/** Constructor */
	ReplaceInFilesPanel( wxWindow* parent );
	void AddResults(SearchResultList *res);
	void ShowResults();
	void Clear();
	
};

#endif // __replaceinfilespanel__
