<?php
/*=========================================================================

  Program:   CDash - Cross-Platform Dashboard System
  Module:    $Id: showprojectupdategraph.php 2628 2010-08-05 21:01:24Z david.cole $
  Language:  PHP
  Date:      $Date: 2010-08-05 23:01:24 +0200 (jeu., 05 août 2010) $
  Version:   $Revision: 2628 $

  Copyright (c) 2002 Kitware, Inc.  All rights reserved.
  See Copyright.txt or http://www.cmake.org/HTML/Copyright.html for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

// To be able to access files in this CDash installation regardless
// of getcwd() value:
//
$cdashpath = str_replace('\\', '/', dirname(dirname(__FILE__)));
set_include_path($cdashpath . PATH_SEPARATOR . get_include_path());

require_once("cdash/config.php");
require_once("cdash/pdo.php");
require_once("cdash/common.php");

$projectid = $_GET["projectid"];
if(!isset($projectid) || !is_numeric($projectid))
  {
  echo "Not a valid projectid!";
  return;
  }
$timestamp = $_GET["timestamp"];
  
$db = pdo_connect("$CDASH_DB_HOST", "$CDASH_DB_LOGIN","$CDASH_DB_PASS");
pdo_select_db("$CDASH_DB_NAME",$db);

// Find the project variables
$files = pdo_query("SELECT d.date,count(df.dailyupdateid) FROM dailyupdate as d 
                    LEFT JOIN dailyupdatefile AS df ON (df.dailyupdateid=d.id)
                    WHERE d.projectid=".$projectid." 
                    AND date<='".date("Y-m-d",$timestamp)."'
                    GROUP BY d.date ORDER BY d.date");
?>

    
<br>
<script language="javascript" type="text/javascript">
$(function () {
    var d1 = [];
    var dates = [];
    <?php
    $i=0;
    while($files_array = pdo_fetch_array($files))
      {
      $t = strtotime($files_array[0])*1000; //flot expects milliseconds
    ?>
      d1.push([<?php echo $t; ?>,<?php echo $files_array[1]; ?>]);
      dates[<?php echo $t; ?>] = '<?php echo $files_array[0]; ?>';
    <?php
    $i++;
      }
    ?>
    
    var options = {
      lines: { show: true },
      points: { show: true },
      xaxis: { mode: "time" }, 
      grid: {backgroundColor: "#fffaff",
      clickable: true,
      hoverable: true,
      hoverFill: '#444',
      hoverRadius: 4},
      selection: { mode: "x" },
      colors: ["#0000FF", "#dba255", "#919733"]
    };
  
    $("#grapholder").bind("selected", function (event, area) {
    plot = $.plot($("#grapholder"), [{label: "Number of changed files",  data: d1}], $.extend(true, {}, options, {xaxis: { min: area.x1, max: area.x2 }}));
     });
  
   $("#grapholder").bind("plotclick", function (e, pos, item) {
       if (item) {
           plot.highlight(item.series, item.datapoint);
           date = dates[item.datapoint[0]];
           window.location = "viewChanges.php?project=<?php echo get_project_name($projectid);?>&date="+date;
           }      
    });
       
  plot = $.plot($("#grapholder"), [{label: "Number of changed files",  data: d1}],options);
});
</script>
