/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.impl.transport.PEPeerTransportProtocol;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class BitsAllocatedForUploadItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public BitsAllocatedForUploadItem() {
        super("BitsAllocatedForUpload", 2, -2, 65, "Peers");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        PEPeerTransportProtocol peer = (PEPeerTransportProtocol)cell.getDataSource();
        if (peer.isChokedByMe()) {
            cell.setText("");
        } else if (peer.getNetworkConnection() != null) {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(peer.getTyrantStats().getLastUploadAllocation()));
        } else {
            cell.setText("0");
        }
    }
}

