/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.GenericActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeListener;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionTransfer
implements UISWTConfigSection {
    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "transfer";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        cSection.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        final int[] manual_max_download_speed = new int[]{COConfigurationManager.getIntParameter("Max Download Speed KBs")};
        gridData = new GridData();
        Label label = new Label(cSection, 0);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "ConfigView.label.maxuploadspeed");
        gridData = new GridData();
        gridData.widthHint = 35;
        final IntParameter paramMaxUploadSpeed = new IntParameter(cSection, "Max Upload Speed KBs", 1, -1, true, true);
        paramMaxUploadSpeed.setLayoutData(gridData);
        Composite cMaxUploadSpeedOptionsArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cMaxUploadSpeedOptionsArea.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalIndent = 15;
        gridData.horizontalSpan = 2;
        cMaxUploadSpeedOptionsArea.setLayoutData((Object)gridData);
        label = new Label(cMaxUploadSpeedOptionsArea, 0);
        Image img = ImageRepository.getImage("subitem");
        img.setBackground(label.getBackground());
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        label.setImage(img);
        gridData = new GridData();
        BooleanParameter enable_seeding_rate = new BooleanParameter(cMaxUploadSpeedOptionsArea, "enable.seedingonly.upload.rate", false, "ConfigView.label.maxuploadspeedseeding");
        enable_seeding_rate.setLayoutData(gridData);
        gridData = new GridData();
        gridData.widthHint = 35;
        IntParameter paramMaxUploadSpeedSeeding = new IntParameter(cMaxUploadSpeedOptionsArea, "Max Upload Speed Seeding KBs", 1, -1, true, false);
        paramMaxUploadSpeedSeeding.setLayoutData(gridData);
        enable_seeding_rate.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(paramMaxUploadSpeedSeeding.getControl()));
        if (userMode < 2) {
            Composite cWiki = new Composite(cSection, 15);
            gridData = new GridData(272);
            gridData.horizontalSpan = 2;
            cWiki.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginHeight = 0;
            cWiki.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalIndent = 6;
            gridData.horizontalSpan = 2;
            label = new Label(cWiki, 0);
            label.setLayoutData((Object)gridData);
            label.setText(MessageText.getString("Utils.link.visit") + ":");
            gridData = new GridData();
            gridData.horizontalIndent = 10;
            gridData.horizontalSpan = 2;
            new LinkLabel(cWiki, gridData, "ConfigView.section.transfer.speeds.wiki", "http://azureus.aelitis.com/wiki/index.php/Good_settings");
        }
        if (userMode > 1) {
            gridData = new GridData();
            label = new Label(cSection, 0);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.label.maxuploadswhenbusymin");
            gridData = new GridData();
            gridData.widthHint = 35;
            new IntParameter(cSection, "max.uploads.when.busy.inc.min.secs", 0, -1, true, false).setLayoutData(gridData);
        }
        gridData = new GridData();
        label = new Label(cSection, 0);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "ConfigView.label.maxdownloadspeed");
        gridData = new GridData();
        gridData.widthHint = 35;
        final IntParameter paramMaxDownSpeed = new IntParameter(cSection, "Max Download Speed KBs", 0, -1, true, true);
        paramMaxDownSpeed.setLayoutData(gridData);
        paramMaxUploadSpeed.addChangeListener(new ParameterChangeListener(){

            public void parameterChanged(Parameter p, boolean internal) {
                int up_val = paramMaxUploadSpeed.getValue();
                int down_val = paramMaxDownSpeed.getValue();
                if (up_val != 0 && up_val < 5) {
                    if (down_val == 0 || down_val > up_val * 2) {
                        paramMaxDownSpeed.setValue(up_val * 2);
                    }
                } else if (down_val != manual_max_download_speed[0]) {
                    paramMaxDownSpeed.setValue(manual_max_download_speed[0]);
                }
            }
        });
        paramMaxDownSpeed.addChangeListener(new ParameterChangeListener(){

            public void parameterChanged(Parameter p, boolean internal) {
                int up_val = paramMaxUploadSpeed.getValue();
                int down_val = paramMaxDownSpeed.getValue();
                if (!internal) {
                    manual_max_download_speed[0] = down_val;
                }
                if (up_val < 5) {
                    if (up_val != 0 && up_val < down_val * 2) {
                        paramMaxUploadSpeed.setValue((down_val + 1) / 2);
                    } else if (down_val == 0) {
                        paramMaxUploadSpeed.setValue(0);
                    }
                }
            }
        });
        if (userMode > 0) {
            gridData = new GridData();
            label = new Label(cSection, 0);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.label.maxuploads");
            gridData = new GridData();
            gridData.widthHint = 35;
            IntParameter paramMaxUploads = new IntParameter(cSection, "Max Uploads", 2, -1, false, false);
            paramMaxUploads.setLayoutData(gridData);
            Composite cMaxUploadsOptionsArea = new Composite(cSection, 0);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cMaxUploadsOptionsArea.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalIndent = 15;
            gridData.horizontalSpan = 2;
            cMaxUploadsOptionsArea.setLayoutData((Object)gridData);
            label = new Label(cMaxUploadsOptionsArea, 0);
            img = ImageRepository.getImage("subitem");
            img.setBackground(label.getBackground());
            gridData = new GridData(2);
            label.setLayoutData((Object)gridData);
            label.setImage(img);
            gridData = new GridData();
            BooleanParameter enable_seeding_uploads = new BooleanParameter(cMaxUploadsOptionsArea, "enable.seedingonly.maxuploads", false, "ConfigView.label.maxuploadsseeding");
            enable_seeding_uploads.setLayoutData(gridData);
            gridData = new GridData();
            gridData.widthHint = 35;
            IntParameter paramMaxUploadsSeeding = new IntParameter(cMaxUploadsOptionsArea, "Max Uploads Seeding", 2, -1, false, false);
            paramMaxUploadsSeeding.setLayoutData(gridData);
            enable_seeding_uploads.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(paramMaxUploadsSeeding.getControl()));
            String enableMaxConnKey = "Enable.AutoMaxConnections";
            boolean autoMaxConnectionsEnabled = COConfigurationManager.getBooleanParameter("Enable.AutoMaxConnections", true);
            final BooleanParameter enableAutoMaxConnections = new BooleanParameter(cSection, "Enable.AutoMaxConnections", autoMaxConnectionsEnabled, "ConfigView.label.enable_auto_max_connections");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            enableAutoMaxConnections.setLayoutData(gridData);
            gridData = new GridData();
            Label maxPeersPerTorrent = new Label(cSection, 0);
            maxPeersPerTorrent.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)maxPeersPerTorrent, "ConfigView.label.max_peers_per_torrent");
            gridData = new GridData();
            gridData.widthHint = 35;
            IntParameter paramMaxClients = new IntParameter(cSection, "Max.Peer.Connections.Per.Torrent");
            paramMaxClients.setLayoutData(gridData);
            gridData = new GridData();
            Label maxPeersTotal = new Label(cSection, 0);
            maxPeersTotal.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)maxPeersTotal, "ConfigView.label.max_peers_total");
            gridData = new GridData();
            gridData.widthHint = 35;
            IntParameter paramMaxClientsTotal = new IntParameter(cSection, "Max.Peer.Connections.Total");
            paramMaxClientsTotal.setLayoutData(gridData);
            final Control[] proxy_controls = new Control[]{maxPeersTotal, maxPeersPerTorrent, paramMaxClients.getControl(), paramMaxClientsTotal.getControl()};
            GenericActionPerformer autoMax = new GenericActionPerformer(new Control[0]){

                public void performAction() {
                    for (int i = 0; i < proxy_controls.length; ++i) {
                        proxy_controls[i].setEnabled(!enableAutoMaxConnections.isSelected());
                    }
                }
            };
            enableAutoMaxConnections.setAdditionalActionPerformer(autoMax);
            enableAutoMaxConnections.setAdditionalActionPerformer(new GenericActionPerformer(new Control[0]){

                public void performAction() {
                    COConfigurationManager.setParameter("Enable.AutoMaxConnections", enableAutoMaxConnections.isSelected());
                }
            });
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter allowSameIP = new BooleanParameter(cSection, "Allow Same IP Peers", false, "ConfigView.label.allowsameip");
            allowSameIP.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter lazybf = new BooleanParameter(cSection, "Use Lazy Bitfield", false, "ConfigView.label.lazybitfield");
            lazybf.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter firstPiece = new BooleanParameter(cSection, "Prioritize First Piece", false, "ConfigView.label.prioritizefirstpiece");
            firstPiece.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter mostCompletedFiles = new BooleanParameter(cSection, "Prioritize Most Completed Files", false, "ConfigView.label.prioritizemostcompletedfiles");
            mostCompletedFiles.setLayoutData(gridData);
            Composite cMiniArea = new Composite(cSection, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cMiniArea.setLayout((Layout)layout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            cMiniArea.setLayoutData((Object)gridData);
            gridData = new GridData();
            label = new Label(cMiniArea, 0);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.label.transfer.ignorepeerports");
            gridData = new GridData();
            gridData.widthHint = 125;
            StringParameter ignore_ports = new StringParameter(cMiniArea, "Ignore.peer.ports", "0");
            ignore_ports.setLayoutData(gridData);
        }
        return cSection;
    }
}

