/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.test;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Win32TransferTypes
extends ByteArrayTransfer {
    private static Win32TransferTypes _instance = new Win32TransferTypes();
    private int[] ids = new int[50000];
    private String[] names = new String[50000];

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Canvas canvas = new Canvas((Composite)shell, 0);
        DropTarget target = new DropTarget((Control)canvas, 31);
        target.setTransfer(new Transfer[]{Win32TransferTypes.getInstance(), TextTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event2) {
                event2.detail = 4;
                String ops = "";
                if ((event2.operations & 1) != 0) {
                    ops = ops + "Copy;";
                }
                if ((event2.operations & 2) != 0) {
                    ops = ops + "Move;";
                }
                if ((event2.operations & 4) != 0) {
                    ops = ops + "Link;";
                }
                System.out.println("Allowed Operations are " + ops);
                TransferData[] data = event2.dataTypes;
                for (int i = 0; i < data.length; ++i) {
                    int id = data[i].type;
                    String name = Win32TransferTypes.getNameFromId(id);
                    System.out.println("Data type is " + id + " " + name);
                }
            }

            public void dragOver(DropTargetEvent event2) {
                event2.detail = 4;
            }

            public void drop(DropTargetEvent event2) {
                System.out.println("URL dropped: " + event2.data);
                System.out.println("Data type is " + event2.currentDataType.type + " " + Win32TransferTypes.getNameFromId(event2.currentDataType.type));
            }
        });
        shell.setSize(400, 400);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static Win32TransferTypes getInstance() {
        return _instance;
    }

    Win32TransferTypes() {
        for (int i = 0; i < this.ids.length; ++i) {
            this.ids[i] = i;
            this.names[i] = Win32TransferTypes.getNameFromId(i);
        }
    }

    public void javaToNative(Object object, TransferData transferData) {
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] buffer = (byte[])super.nativeToJava(transferData);
        if (buffer == null) {
            return null;
        }
        int size = buffer.length;
        byte[] text = new byte[size];
        int j = 0;
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == 0) continue;
            text[j++] = buffer[i];
        }
        String data = new String(text, 0, j);
        int end = data.indexOf("\n");
        return end >= 0 ? data.substring(0, end) : data;
    }

    protected String[] getTypeNames() {
        return this.names;
    }

    protected int[] getTypeIds() {
        return this.ids;
    }

    static String getNameFromId(int id) {
        String name = null;
        int maxSize = 128;
        TCHAR buffer = new TCHAR(0, maxSize);
        int size = COM.GetClipboardFormatName((int)id, (TCHAR)buffer, (int)maxSize);
        if (size != 0) {
            name = buffer.toString(0, size);
        } else {
            switch (id) {
                case 15: {
                    name = "CF_HDROP";
                    break;
                }
                case 1: {
                    name = "CF_TEXT";
                    break;
                }
                case 2: {
                    name = "CF_BITMAP";
                    break;
                }
                case 3: {
                    name = "CF_METAFILEPICT";
                    break;
                }
                case 4: {
                    name = "CF_SYLK";
                    break;
                }
                case 5: {
                    name = "CF_DIF";
                    break;
                }
                case 6: {
                    name = "CF_TIFF";
                    break;
                }
                case 7: {
                    name = "CF_OEMTEXT";
                    break;
                }
                case 8: {
                    name = "CF_DIB";
                    break;
                }
                case 9: {
                    name = "CF_PALETTE";
                    break;
                }
                case 10: {
                    name = "CF_PENDATA";
                    break;
                }
                case 11: {
                    name = "CF_RIFF";
                    break;
                }
                case 12: {
                    name = "CF_WAVE";
                    break;
                }
                case 13: {
                    name = "CF_UNICODETEXT";
                    break;
                }
                case 14: {
                    name = "CF_ENHMETAFILE";
                    break;
                }
                case 16: {
                    name = "CF_LOCALE";
                    break;
                }
                case 17: {
                    name = "CF_MAX";
                }
            }
        }
        return name;
    }
}

