/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.ui.IUIIntializer;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.common.util.UserAlerts;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.LocaleUtilSWT;
import org.gudy.azureus2.ui.swt.StartServer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.auth.AuthenticatorWindow;
import org.gudy.azureus2.ui.swt.auth.CertificateTrustWindow;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.InitializerListener;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import org.gudy.azureus2.ui.swt.mainwindow.SplashWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.networks.SWTNetworkSelection;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.progress.ProgressWindow;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;
import org.gudy.azureus2.ui.swt.updater2.SWTUpdateChecker;

public class Initializer
implements AzureusCoreListener,
IUIIntializer {
    private static final LogIDs LOGID = LogIDs.GUI;
    private AzureusCore azureus_core;
    private GlobalManager gm;
    private StartServer startServer;
    private ArrayList listeners;
    private AEMonitor listeners_mon = new AEMonitor("Initializer:l");
    private String[] args;
    private int nbTasks = 1;
    private int currentTask = 0;
    private int currentPercent = 0;

    public Initializer(AzureusCore _azureus_core, StartServer _server, String[] _args) {
        this.listeners = new ArrayList();
        this.azureus_core = _azureus_core;
        this.startServer = _server;
        this.args = _args;
        this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public boolean stopRequested(AzureusCore _core) throws AzureusCoreException {
                return Initializer.this.handleStopRestart(false);
            }

            public boolean restartRequested(AzureusCore core) {
                return Initializer.this.handleStopRestart(true);
            }
        });
        try {
            SWTThread.createInstance(this);
        }
        catch (SWTThreadAlreadyInstanciatedException e) {
            Debug.printStackTrace(e);
        }
    }

    public boolean handleStopRestart(final boolean restart) {
        if (Utils.isThisThreadSWT()) {
            return MainWindow.getWindow().dispose(restart, true);
        }
        final AESemaphore sem = new AESemaphore("SWTInit::stopRestartRequest");
        final boolean[] ok = new boolean[]{false};
        try {
            Utils.execSWTThread(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    try {
                        ok[0] = MainWindow.getWindow().dispose(restart, true);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    finally {
                        sem.release();
                    }
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            sem.release();
        }
        sem.reserve();
        return ok[0];
    }

    public void run() {
        try {
            new LocaleUtilSWT(this.azureus_core);
            Display display = SWTThread.getInstance().getDisplay();
            ImageRepository.loadImagesForSplashWindow(display);
            if (COConfigurationManager.getBooleanParameter("Show Splash", true)) {
                SplashWindow.create(display, this);
            }
            this.setNbTasks(6);
            this.nextTask();
            this.reportCurrentTaskByKey("splash.firstMessageNoI18N");
            Alerts.init();
            final ArrayList logEvents = new ArrayList();
            ILogEventListener logListener = null;
            if (COConfigurationManager.getBooleanParameter("Open Console", false)) {
                logListener = new ILogEventListener(){

                    public void log(LogEvent event2) {
                        logEvents.add(event2);
                    }
                };
                Logger.addListener(logListener);
            }
            final ILogEventListener finalLogListener = logListener;
            ProgressWindow.register(this.azureus_core);
            new SWTNetworkSelection();
            new AuthenticatorWindow();
            new CertificateTrustWindow();
            InstallPluginWizard.register(this.azureus_core, display);
            this.nextTask();
            this.reportCurrentTaskByKey("splash.loadingImages");
            ImageRepository.loadImages(display);
            this.nextTask();
            this.reportCurrentTaskByKey("splash.initializeGM");
            this.azureus_core.addListener(this);
            this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                public void componentCreated(AzureusCore core, AzureusCoreComponent comp) {
                    if (comp instanceof GlobalManager) {
                        Initializer.this.gm = (GlobalManager)comp;
                        Initializer.this.nextTask();
                        Initializer.this.reportCurrentTask(MessageText.getString("splash.initializePlugins"));
                    }
                }

                public void started(AzureusCore core) {
                    if (Initializer.this.gm == null) {
                        return;
                    }
                    new UserAlerts(Initializer.this.gm);
                    Initializer.this.nextTask();
                    Initializer.this.reportCurrentTaskByKey("splash.initializeGui");
                    new Colors();
                    Cursors.init();
                    MainWindow main_window = new MainWindow(core, Initializer.this, logEvents);
                    if (finalLogListener != null) {
                        Logger.removeListener(finalLogListener);
                    }
                    Initializer.this.nextTask();
                    Initializer.this.reportCurrentTaskByKey("splash.openViews");
                    SWTUpdateChecker.initialize();
                    UpdateMonitor.getSingleton(core);
                    Alerts.initComplete();
                    Initializer.this.nextTask();
                    for (int i = 0; i < Initializer.this.args.length; ++i) {
                        try {
                            TorrentOpener.openTorrent(Initializer.this.args[i]);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }

                public void stopping(AzureusCore core) {
                    Alerts.stopInitiated();
                }

                public void stopped(AzureusCore core) {
                    Alerts.stopCompleted();
                }

                public boolean syncInvokeRequired() {
                    return true;
                }
            });
            this.azureus_core.start();
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Initialization fails:", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InitializerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InitializerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void reportCurrentTask(AzureusCoreOperation operation, String currentTask) {
        if (operation.getOperationType() == 1) {
            this.reportCurrentTask(currentTask);
        }
    }

    public void reportPercent(AzureusCoreOperation operation, int percent) {
        if (operation.getOperationType() == 1) {
            this.reportPercent(percent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCurrentTask(String currentTaskString) {
        try {
            this.listeners_mon.enter();
            for (InitializerListener listener : this.listeners) {
                listener.reportCurrentTask(currentTaskString);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportPercent(int percent) {
        int overallPercent = this.overallPercent(percent);
        try {
            this.listeners_mon.enter();
            for (InitializerListener listener : this.listeners) {
                listener.reportPercent(overallPercent);
            }
            if (overallPercent > 100) {
                this.listeners.clear();
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt(boolean for_restart, boolean close_already_in_progress) throws AzureusCoreException {
        if (this.azureus_core != null && !close_already_in_progress && for_restart) {
            this.azureus_core.checkRestartSupported();
        }
        try {
            if (this.startServer != null) {
                this.startServer.stopIt();
            }
            Cursors.dispose();
            SWTThread.getInstance().terminate();
        }
        finally {
            if (this.azureus_core != null && !close_already_in_progress) {
                try {
                    if (for_restart) {
                        this.azureus_core.restart();
                    } else {
                        this.azureus_core.stop();
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    private void setNbTasks(int _nbTasks) {
        this.currentTask = 0;
        this.nbTasks = _nbTasks;
    }

    private void nextTask() {
        ++this.currentTask;
        this.currentPercent = 100 * this.currentTask / this.nbTasks;
        this.reportPercent(0);
    }

    private int overallPercent(int taskPercent) {
        return this.currentPercent + taskPercent / this.nbTasks;
    }

    private void reportCurrentTaskByKey(String key) {
        this.reportCurrentTask(MessageText.getString(key));
    }

    public static void main(String[] args) {
        AzureusCore core = AzureusCoreFactory.create();
        new Initializer(core, null, args);
    }
}

