/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class Timer
extends AERunnable
implements SystemTime.consumer {
    private ThreadPool thread_pool;
    private Set events = new TreeSet();
    private long unique_id_next = 0L;
    private volatile boolean destroyed;
    private boolean indestructable;
    private boolean log;
    private int max_events_logged;

    public Timer(String name) {
        this(name, 1);
    }

    public Timer(String name, int thread_pool_size) {
        this(name, thread_pool_size, 5);
    }

    public Timer(String name, int thread_pool_size, int thread_priority) {
        this.thread_pool = new ThreadPool(name, thread_pool_size);
        SystemTime.registerClockChangeListener(this);
        Thread t = new Thread((Runnable)this, "Timer:" + name);
        t.setDaemon(true);
        t.setPriority(thread_priority);
        t.start();
    }

    public void setIndestructable() {
        this.indestructable = true;
    }

    public void setLogging(boolean _log) {
        this.log = _log;
    }

    public void setWarnWhenFull() {
        this.thread_pool.setWarnWhenFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSupport() {
        block5: while (true) {
            try {
                while (true) {
                    TimerEvent event_to_run = null;
                    Timer timer = this;
                    synchronized (timer) {
                        long now;
                        if (this.destroyed) {
                            break block5;
                        }
                        if (this.events.isEmpty()) {
                            this.wait();
                        } else {
                            now = SystemTime.getCurrentTime();
                            TimerEvent next_event = (TimerEvent)this.events.iterator().next();
                            long delay = next_event.getWhen() - now;
                            if (delay > 0L) {
                                this.wait(delay);
                            }
                        }
                        if (this.destroyed) {
                            break block5;
                        }
                        now = SystemTime.getCurrentTime();
                        Iterator it = this.events.iterator();
                        while (it.hasNext()) {
                            TimerEvent event2 = (TimerEvent)it.next();
                            if (event2.getWhen() > now) continue;
                            event_to_run = event2;
                            it.remove();
                            break;
                        }
                    }
                    if (event_to_run == null) continue;
                    event_to_run.setHasRun();
                    this.thread_pool.run(event_to_run.getRunnable());
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(long offset) {
        if (Math.abs(offset) >= 60000L) {
            Timer timer = this;
            synchronized (timer) {
                for (TimerEvent event2 : this.events) {
                    long old_when = event2.getWhen();
                    long new_when = old_when + offset;
                    event2.setWhen(new_when);
                }
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustAllBy(long offset) {
        Timer timer = this;
        synchronized (timer) {
            for (TimerEvent event2 : this.events) {
                long old_when = event2.getWhen();
                long new_when = old_when + offset;
                event2.setWhen(new_when);
            }
            this.notify();
        }
    }

    public synchronized TimerEvent addEvent(long when, TimerEventPerformer performer) {
        return this.addEvent(SystemTime.getCurrentTime(), when, performer);
    }

    public synchronized TimerEvent addEvent(String name, long when, TimerEventPerformer performer) {
        return this.addEvent(name, SystemTime.getCurrentTime(), when, performer);
    }

    public synchronized TimerEvent addEvent(long creation_time, long when, TimerEventPerformer performer) {
        return this.addEvent(null, creation_time, when, performer);
    }

    public synchronized TimerEvent addEvent(String name, long creation_time, long when, TimerEventPerformer performer) {
        TimerEvent event2 = new TimerEvent(this, this.unique_id_next++, creation_time, when, performer);
        if (name != null) {
            event2.setName(name);
        }
        this.events.add(event2);
        if (this.log) {
            if (!(performer instanceof TimerEventPerformer)) {
                System.out.println("Timer '" + this.thread_pool.getName() + "' - added " + event2.getString());
            }
            if (this.events.size() > this.max_events_logged) {
                this.max_events_logged = this.events.size();
                System.out.println("Timer '" + this.thread_pool.getName() + "' - events = " + this.max_events_logged);
            }
        }
        this.notify();
        return event2;
    }

    public synchronized TimerEventPeriodic addPeriodicEvent(long frequency, TimerEventPerformer performer) {
        return this.addPeriodicEvent(null, frequency, performer);
    }

    public synchronized TimerEventPeriodic addPeriodicEvent(String name, long frequency, TimerEventPerformer performer) {
        TimerEventPeriodic periodic_performer = new TimerEventPeriodic(this, frequency, performer);
        if (name != null) {
            periodic_performer.setName(name);
        }
        if (this.log) {
            System.out.println("Timer '" + this.thread_pool.getName() + "' - added " + periodic_performer.getString());
        }
        return periodic_performer;
    }

    protected synchronized void cancelEvent(TimerEvent event2) {
        if (this.events.contains(event2)) {
            this.events.remove(event2);
            this.notify();
        }
    }

    public synchronized void destroy() {
        if (this.indestructable) {
            Debug.out("Attempt to destroy indestructable timer '" + this.getName() + "'");
        } else {
            this.destroyed = true;
            this.notify();
            SystemTime.unregisterClockChangeListener(this);
        }
    }

    public String getName() {
        return this.thread_pool.getName();
    }

    public synchronized void dump() {
        System.out.println("Timer '" + this.thread_pool.getName() + "': dump");
        for (TimerEvent ev : this.events) {
            System.out.println("\t" + ev.getString());
        }
    }
}

