/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistrationAdapter;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFactory;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoListener;
import org.gudy.azureus2.core3.disk.DiskManagerListener;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerDiskListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.download.impl.DownloadManagerStatsImpl;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerFactory;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.NonDaemonTask;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class DownloadManagerController
extends LogRelation
implements PEPeerManagerAdapter,
PeerManagerRegistrationAdapter {
    private static long STATE_FLAG_HASDND = 1L;
    private static long STATE_FLAG_COMPLETE_NO_DND = 2L;
    private static long skeleton_builds;
    private static final int LDT_DL_ADDED = 1;
    private static final int LDT_DL_REMOVED = 2;
    private static ListenerManager disk_listeners_agregator;
    private ListenerManager disk_listeners = ListenerManager.createManager("DMC:DiskListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object listener, int type, Object value) {
            disk_listeners_agregator.dispatch(listener, type, value);
        }
    });
    private AEMonitor disk_listeners_mon = new AEMonitor("DownloadManagerController:DL");
    protected AEMonitor this_mon = new AEMonitor("DownloadManagerController");
    protected AEMonitor state_mon = new AEMonitor("DownloadManagerController:State");
    protected AEMonitor facade_mon = new AEMonitor("DownloadManagerController:Facade");
    private DownloadManagerImpl download_manager;
    private DownloadManagerStatsImpl stats;
    private volatile int state_set_by_method = -1;
    private volatile int substate;
    private volatile boolean force_start;
    private volatile DiskManager disk_manager_use_accessors;
    private DiskManagerListener disk_manager_listener_use_accessors;
    private fileInfoFacade[] files_facade = new fileInfoFacade[0];
    private boolean cached_complete_excluding_dnd;
    private boolean cached_has_dnd_files;
    private boolean cached_values_set;
    private PeerManagerRegistration peer_manager_registration;
    private PEPeerManager peer_manager;
    private String errorDetail;
    private GlobalManagerStats global_stats;
    private boolean bInitialized = false;
    private static final int ACTIVATION_REBUILD_TIME = 600000;
    private static final int BLOOM_SIZE = 64;
    private volatile BloomFilter activation_bloom;
    private volatile long activation_bloom_create_time = SystemTime.getCurrentTime();
    private volatile int activation_count;
    private volatile long activation_count_time;

    protected DownloadManagerController(DownloadManagerImpl _download_manager) {
        this.download_manager = _download_manager;
        GlobalManager gm = this.download_manager.getGlobalManager();
        this.global_stats = gm.getStats();
        this.stats = (DownloadManagerStatsImpl)this.download_manager.getStats();
        this.cached_values_set = false;
    }

    protected void setInitialState(int initial_state) {
        this.bInitialized = true;
        if (this.getState() == -1) {
            this.setState(initial_state, true);
        }
        try {
            TOTorrent torrent = this.download_manager.getTorrent();
            if (torrent != null) {
                this.peer_manager_registration = PeerManager.getSingleton().registerLegacyManager(torrent.getHashWrapper(), this);
            }
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
        DownloadManagerState state = this.download_manager.getDownloadState();
        if (state.parameterExists("dndflags")) {
            long flags = state.getLongParameter("dndflags");
            this.cached_complete_excluding_dnd = (flags & STATE_FLAG_COMPLETE_NO_DND) != 0L;
            this.cached_has_dnd_files = (flags & STATE_FLAG_HASDND) != 0L;
            this.cached_values_set = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDownload(TRTrackerAnnouncer tracker_client) {
        DiskManager dm;
        try {
            this.this_mon.enter();
            if (this.getState() != 40) {
                Debug.out("DownloadManagerController::startDownload state must be ready, " + this.getState());
                this.setFailed("Inconsistent download state: startDownload, state = " + this.getState());
                return;
            }
            if (tracker_client == null) {
                Debug.out("DownloadManagerController:startDownload: tracker_client is null");
                this.stopIt(70, false, false);
                return;
            }
            if (this.peer_manager != null) {
                Debug.out("DownloadManagerController::startDownload: peer manager not null");
                this.peer_manager.stopAll();
                this.peer_manager = null;
            }
            if ((dm = this.getDiskManager()) == null) {
                Debug.out("DownloadManagerController::startDownload: disk manager is null");
                return;
            }
            this.setState(50, false);
        }
        finally {
            this.this_mon.exit();
        }
        final PEPeerManager temp = PEPeerManagerFactory.create(tracker_client.getPeerId(), this, dm);
        temp.start();
        tracker_client.setAnnounceDataProvider(new TRTrackerAnnouncerDataProvider(){

            public String getName() {
                return DownloadManagerController.this.getDisplayName();
            }

            public long getTotalSent() {
                return temp.getStats().getTotalDataBytesSent();
            }

            public long getTotalReceived() {
                long verified = temp.getStats().getTotalDataBytesReceived() - (temp.getStats().getTotalDiscarded() + temp.getStats().getTotalHashFailBytes());
                return verified < 0L ? 0L : verified;
            }

            public long getRemaining() {
                return temp.getRemaining();
            }

            public String getExtensions() {
                return DownloadManagerController.this.getTrackerClientExtensions();
            }

            public int getMaxNewConnectionsAllowed() {
                return temp.getMaxNewConnectionsAllowed();
            }
        });
        this.peer_manager = temp;
        if (this.getState() == 50) {
            this.download_manager.informStateChanged();
        }
        this.download_manager.informStarted(temp);
    }

    public void initializeDiskManager(final boolean open_for_seeding) {
        this.initializeDiskManagerSupport(10, new DiskManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged(int oldDMState, int newDMState) {
                DiskManager dm;
                try {
                    DownloadManagerController.this.this_mon.enter();
                    dm = DownloadManagerController.this.getDiskManager();
                    if (dm == null) {
                        return;
                    }
                }
                finally {
                    DownloadManagerController.this.this_mon.exit();
                }
                try {
                    if (newDMState == 10) {
                        DownloadManagerController.this.setFailed(dm.getErrorMessage());
                    }
                    if (oldDMState == 3) {
                        DownloadManagerController.this.makeSureFilesFacadeFilled(true);
                        DownloadManagerController.this.stats.setDownloadCompleted(DownloadManagerController.this.stats.getDownloadCompleted(true));
                        DownloadManagerController.this.download_manager.setAssumedComplete(DownloadManagerController.this.isDownloadComplete(false));
                    }
                    if (newDMState == 4 && DownloadManagerController.this.stats.getTotalDataBytesReceived() == 0L && DownloadManagerController.this.stats.getTotalDataBytesSent() == 0L && DownloadManagerController.this.stats.getSecondsDownloading() == 0L) {
                        int completed = DownloadManagerController.this.stats.getDownloadCompleted(false);
                        if (completed < 1000) {
                            if (open_for_seeding) {
                                DownloadManagerController.this.setFailed("File check failed");
                                DownloadManagerController.this.download_manager.getDownloadState().clearResumeData();
                            } else {
                                long amount_downloaded = (long)completed * dm.getTotalLength() / 1000L;
                                DownloadManagerController.this.stats.setSavedDownloadedUploaded(amount_downloaded, amount_downloaded);
                            }
                        } else {
                            int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                            if (dl_copies > 0) {
                                DownloadManagerController.this.stats.setSavedDownloadedUploaded(DownloadManagerController.this.download_manager.getSize() * (long)dl_copies, DownloadManagerController.this.stats.getTotalDataBytesSent());
                            }
                            DownloadManagerController.this.download_manager.getDownloadState().setFlag(1L, true);
                        }
                    }
                }
                finally {
                    DownloadManagerController.this.download_manager.informStateChanged();
                }
            }

            public void filePriorityChanged(DiskManagerFileInfo file) {
                DownloadManagerController.this.download_manager.informPriorityChange(file);
            }

            public void pieceDoneChanged(DiskManagerPiece piece) {
            }

            public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeDiskManagerSupport(int initialising_state, DiskManagerListener listener) {
        try {
            this.this_mon.enter();
            int entry_state = this.getState();
            if (entry_state != 0 && entry_state != 70 && entry_state != 75 && entry_state != 100) {
                Debug.out("DownloadManagerController::initializeDiskManager: Illegal initialize state, " + entry_state);
                this.setFailed("Inconsistent download state: initSupport, state = " + entry_state);
                return;
            }
            DiskManager old_dm = this.getDiskManager();
            if (old_dm != null) {
                Debug.out("DownloadManagerController::initializeDiskManager: disk manager is not null");
                old_dm.stop(false);
                this.setDiskManager(null, null);
            }
            this.errorDetail = "";
            this.setState(initialising_state, false);
            DiskManager dm = DiskManagerFactory.create(this.download_manager.getTorrent(), this.download_manager);
            this.setDiskManager(dm, listener);
        }
        finally {
            this.this_mon.exit();
            this.download_manager.informStateChanged();
        }
    }

    public boolean canForceRecheck() {
        int state = this.getState();
        return state == 70 || state == 75 || state == 100 && this.getDiskManager() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceRecheck() {
        try {
            this.this_mon.enter();
            if (this.getDiskManager() != null || !this.canForceRecheck()) {
                Debug.out("DownloadManagerController::forceRecheck: illegal entry state");
                return;
            }
            final int start_state = this.getState();
            this.download_manager.getDownloadState().clearResumeData();
            final boolean wasForceStarted = this.force_start;
            this.force_start = true;
            this.download_manager.setDataAlreadyAllocated(false);
            this.initializeDiskManagerSupport(30, new DiskManagerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void stateChanged(int oldDMState, int newDMState) {
                    try {
                        DownloadManagerController.this.this_mon.enter();
                        if (DownloadManagerController.this.getDiskManager() == null) {
                            DownloadManagerController.this.download_manager.setAssumedComplete(false);
                            return;
                        }
                    }
                    finally {
                        DownloadManagerController.this.this_mon.exit();
                    }
                    if (newDMState == 3) {
                        DownloadManagerController.this.makeSureFilesFacadeFilled(true);
                    }
                    if (newDMState == 4 || newDMState == 10) {
                        DownloadManagerController.this.force_start = wasForceStarted;
                        DownloadManagerController.this.stats.setDownloadCompleted(DownloadManagerController.this.stats.getDownloadCompleted(true));
                        if (newDMState == 4) {
                            try {
                                boolean only_seeding = false;
                                boolean update_only_seeding = false;
                                try {
                                    DownloadManagerController.this.this_mon.enter();
                                    DiskManager dm = DownloadManagerController.this.getDiskManager();
                                    if (dm != null) {
                                        dm.stop(false);
                                        only_seeding = dm.getRemainingExcludingDND() == 0L;
                                        update_only_seeding = true;
                                        DownloadManagerController.this.setDiskManager(null, null);
                                        if (start_state == 100) {
                                            DownloadManagerController.this.setState(70, false);
                                        } else {
                                            DownloadManagerController.this.setState(start_state, false);
                                        }
                                    }
                                }
                                finally {
                                    DownloadManagerController.this.this_mon.exit();
                                    DownloadManagerController.this.download_manager.informStateChanged();
                                }
                                if (update_only_seeding) {
                                    DownloadManagerController.this.download_manager.setAssumedComplete(only_seeding);
                                }
                            }
                            catch (Exception e) {
                                DownloadManagerController.this.setFailed("Resume data save fails: " + Debug.getNestedExceptionMessage(e));
                            }
                        } else {
                            try {
                                DownloadManagerController.this.this_mon.enter();
                                DiskManager dm = DownloadManagerController.this.getDiskManager();
                                if (dm != null) {
                                    dm.stop(false);
                                    DownloadManagerController.this.setDiskManager(null, null);
                                    DownloadManagerController.this.setFailed(dm.getErrorMessage());
                                }
                            }
                            finally {
                                DownloadManagerController.this.this_mon.exit();
                            }
                            DownloadManagerController.this.download_manager.setAssumedComplete(false);
                        }
                    }
                }

                public void filePriorityChanged(DiskManagerFileInfo file) {
                    DownloadManagerController.this.download_manager.informPriorityChange(file);
                }

                public void pieceDoneChanged(DiskManagerPiece piece) {
                }

                public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
                }
            });
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt(int _stateAfterStopping, boolean remove_torrent, boolean remove_data) {
        boolean closing;
        boolean bl = closing = _stateAfterStopping == 71;
        if (closing) {
            _stateAfterStopping = 70;
        }
        int stateAfterStopping = _stateAfterStopping;
        try {
            this.this_mon.enter();
            int state = this.getState();
            if (state == 70 || state == 100 && this.getDiskManager() == null) {
                if (remove_data) {
                    this.download_manager.deleteDataFiles();
                }
                if (remove_torrent) {
                    this.download_manager.deleteTorrentFile();
                }
                this.setState(_stateAfterStopping, false);
                return;
            }
            if (state == 65) {
                return;
            }
            this.setSubState(_stateAfterStopping);
            this.setState(65, false);
            final AESemaphore nd_sem = new AESemaphore("DM:DownloadManager.NDTR");
            NonDaemonTaskRunner.runAsync(new NonDaemonTask(){

                public Object run() {
                    nd_sem.reserve();
                    return null;
                }
            });
            try {
                try {
                    if (this.peer_manager != null) {
                        this.peer_manager.stopAll();
                        this.stats.saveSessionTotals();
                    }
                    this.download_manager.informStopped(this.peer_manager, stateAfterStopping == 75);
                    this.peer_manager = null;
                    DiskManager dm = this.getDiskManager();
                    if (dm != null) {
                        dm.stop(closing);
                        this.stats.setCompleted(this.stats.getCompleted());
                        this.stats.setDownloadCompleted(this.stats.getDownloadCompleted(true));
                        if (!this.download_manager.getAssumedComplete()) {
                            this.download_manager.getDownloadState().save();
                        }
                        this.setDiskManager(null, null);
                    }
                }
                finally {
                    this.force_start = false;
                    if (remove_data) {
                        this.download_manager.deleteDataFiles();
                    }
                    if (remove_torrent) {
                        this.download_manager.deleteTorrentFile();
                    }
                    if (this.getState() == 65) {
                        this.setState(stateAfterStopping, true);
                    }
                }
            }
            finally {
                nd_sem.release();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        finally {
            this.this_mon.exit();
            this.download_manager.informStateChanged();
        }
    }

    protected void setStateWaiting() {
        this.setState(0, true);
    }

    public void setStateFinishing() {
        this.setState(55, true);
    }

    public void setStateDownloading() {
        if (this.getState() == 60) {
            this.setState(50, true);
        } else if (this.getState() != 50) {
            Logger.log(new LogEvent((Object)this, LogIDs.CORE, 1, "Trying to set state to downloading when state is not seeding"));
        }
    }

    public void setStateSeeding(boolean never_downloaded) {
        this.setState(60, true);
        this.download_manager.downloadEnded(never_downloaded);
    }

    protected void setStateQueued() {
        this.setState(75, true);
    }

    public int getState() {
        if (this.state_set_by_method != 10) {
            return this.state_set_by_method;
        }
        DiskManager dm = this.getDiskManager();
        if (dm == null) {
            return 10;
        }
        int diskManagerState = dm.getState();
        if (diskManagerState == 1) {
            return 10;
        }
        if (diskManagerState == 2) {
            return 20;
        }
        if (diskManagerState == 3) {
            return 30;
        }
        if (diskManagerState == 4) {
            return 40;
        }
        if (diskManagerState == 10) {
            return 100;
        }
        return 100;
    }

    protected int getSubState() {
        if (this.state_set_by_method == 65) {
            return this.substate;
        }
        return this.getState();
    }

    private void setSubState(int ss) {
        this.substate = ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int _state, boolean _inform_changed) {
        boolean call_filesExist = false;
        try {
            this.state_mon.enter();
            int old_state = this.state_set_by_method;
            if (old_state != _state) {
                File save_dir_file;
                TOTorrent torrent;
                this.state_set_by_method = _state;
                if (this.state_set_by_method != 75) {
                    this.activation_bloom = null;
                    if (this.state_set_by_method == 70) {
                        this.activation_count = 0;
                    }
                }
                if (this.state_set_by_method == 75) {
                } else if (this.state_set_by_method == 100 && (torrent = this.download_manager.getTorrent()) != null && !torrent.isSimpleTorrent() && (save_dir_file = this.download_manager.getAbsoluteSaveLocation()) != null && save_dir_file.exists() && save_dir_file.isDirectory()) {
                    TorrentUtils.recursiveEmptyDirDelete(save_dir_file, false);
                }
            }
        }
        finally {
            this.state_mon.exit();
        }
        if (call_filesExist) {
            this.filesExist();
        }
        if (_inform_changed) {
            this.download_manager.informStateChanged();
        }
    }

    public void restartDownload() {
        boolean was_force_start = this.isForceStart();
        this.stopIt(70, false, false);
        this.download_manager.initialize();
        if (was_force_start) {
            this.setForceStart(true);
        }
    }

    protected void destroy() {
        if (this.peer_manager_registration != null) {
            this.peer_manager_registration.unregister();
            this.peer_manager_registration = null;
        }
    }

    public boolean activateRequest(InetSocketAddress address) {
        if (this.getState() == 75) {
            byte[] address_bytes;
            int hit_count;
            BloomFilter bloom = this.activation_bloom;
            if (bloom == null) {
                this.activation_bloom = bloom = BloomFilterFactory.createAddRemove4Bit(64);
            }
            if ((hit_count = bloom.add(address_bytes = address.getAddress().getAddress())) > 5) {
                Logger.log(new LogEvent((Object)this, LogIDs.CORE, 1, "Activate request for " + this.getDisplayName() + " from " + address + " denied as too many recently received"));
                return false;
            }
            Logger.log(new LogEvent(this, LogIDs.CORE, "Activate request for " + this.getDisplayName() + " from " + address));
            long now = SystemTime.getCurrentTime();
            if (now < this.activation_bloom_create_time || now - this.activation_bloom_create_time > 600000L) {
                this.activation_bloom = BloomFilterFactory.createAddRemove4Bit(64);
                this.activation_bloom_create_time = now;
            }
            this.activation_count = bloom.getEntryCount();
            this.activation_count_time = now;
            return this.download_manager.activateRequest(this.activation_count);
        }
        return false;
    }

    public void deactivateRequest(InetSocketAddress address) {
        BloomFilter bloom = this.activation_bloom;
        if (bloom != null) {
            byte[] address_bytes = address.getAddress().getAddress();
            int count = bloom.count(address_bytes);
            for (int i = 0; i < count; ++i) {
                bloom.remove(address_bytes);
            }
            this.activation_count = bloom.getEntryCount();
        }
    }

    public int getActivationCount() {
        long now = SystemTime.getCurrentTime();
        if (now < this.activation_count_time) {
            this.activation_count_time = now;
        } else if (now - this.activation_count_time > 600000L) {
            this.activation_count = 0;
        }
        return this.activation_count;
    }

    public PeerManagerRegistration getPeerManagerRegistration() {
        return this.peer_manager_registration;
    }

    public boolean isForceStart() {
        return this.force_start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForceStart(boolean _force_start) {
        try {
            this.state_mon.enter();
            if (this.force_start != _force_start) {
                this.force_start = _force_start;
                int state = this.getState();
                if (this.force_start && (state == 70 || state == 75)) {
                    this.setState(0, false);
                }
            }
        }
        finally {
            this.state_mon.exit();
        }
        this.download_manager.informStateChanged();
    }

    protected void setFailed(String reason) {
        if (reason != null) {
            this.errorDetail = reason;
        }
        this.stopIt(100, false, false);
    }

    public boolean filesExist() {
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            return dm.filesExist();
        }
        this.makeSureFilesFacadeFilled(false);
        for (int i = 0; i < this.files_facade.length; ++i) {
            fileInfoFacade fileInfo2 = this.files_facade[i];
            if (fileInfo2.isSkipped()) continue;
            File file = fileInfo2.getFile(true);
            try {
                if (!file.exists()) {
                    this.setFailed(MessageText.getString("DownloadManager.error.datamissing") + " " + file);
                    return false;
                }
                if (fileInfo2.getLength() >= file.length() || COConfigurationManager.getBooleanParameter("File.truncate.if.too.large")) continue;
                this.setFailed(MessageText.getString("DownloadManager.error.badsize") + " " + file + "(" + fileInfo2.getLength() + "/" + file.length() + ")");
                return false;
            }
            catch (Exception e) {
                this.setFailed(e.getMessage());
                return false;
            }
        }
        return true;
    }

    private void makeSureFilesFacadeFilled(boolean refresh) {
        if (!this.bInitialized) {
            return;
        }
        if (this.files_facade.length == 0) {
            fileInfoFacade[] new_files_facade = new fileInfoFacade[this.download_manager.getTorrent() == null ? 0 : this.download_manager.getTorrent().getFiles().length];
            for (int i = 0; i < new_files_facade.length; ++i) {
                new_files_facade[i] = new fileInfoFacade();
            }
            this.fixupFileInfo(new_files_facade);
        } else if (refresh) {
            this.fixupFileInfo(this.files_facade);
        }
    }

    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        this.makeSureFilesFacadeFilled(false);
        return this.files_facade;
    }

    protected void fileInfoChanged() {
        this.makeSureFilesFacadeFilled(true);
    }

    protected void filePriorityChanged(DiskManagerFileInfo file) {
        if (!this.cached_values_set) {
            this.makeSureFilesFacadeFilled(false);
        }
        if (!this.cached_has_dnd_files && !file.isSkipped()) {
            return;
        }
        this.makeSureFilesFacadeFilled(false);
        this.calculateCompleteness(this.files_facade);
    }

    protected void calculateCompleteness(DiskManagerFileInfo[] active) {
        boolean complete_exluding_dnd = true;
        boolean has_dnd_files = false;
        for (int i = 0; i < active.length; ++i) {
            DiskManagerFileInfo file = active[i];
            if (file.isSkipped()) {
                has_dnd_files = true;
                continue;
            }
            if (file.getDownloaded() == file.getLength()) continue;
            complete_exluding_dnd = false;
            break;
        }
        this.cached_complete_excluding_dnd = complete_exluding_dnd;
        this.cached_has_dnd_files = has_dnd_files;
        this.cached_values_set = true;
        DownloadManagerState state = this.download_manager.getDownloadState();
        long flags = (this.cached_complete_excluding_dnd ? STATE_FLAG_COMPLETE_NO_DND : 0L) | (this.cached_has_dnd_files ? STATE_FLAG_HASDND : 0L);
        state.setLongParameter("dndflags", flags);
    }

    protected boolean isDownloadComplete(boolean bIncludeDND) {
        int dm_state;
        if (!this.cached_values_set) {
            this.makeSureFilesFacadeFilled(false);
        }
        if (!this.cached_has_dnd_files) {
            return this.stats.getDownloadCompleted(false) == 1000;
        }
        DiskManager dm = this.getDiskManager();
        if (dm != null && ((dm_state = dm.getState()) == 3 || dm_state == 4)) {
            long remaining = bIncludeDND ? dm.getRemaining() : dm.getRemainingExcludingDND();
            return remaining == 0L;
        }
        if (bIncludeDND) {
            return false;
        }
        return this.cached_complete_excluding_dnd;
    }

    protected PEPeerManager getPeerManager() {
        return this.peer_manager;
    }

    protected DiskManager getDiskManager() {
        return this.disk_manager_use_accessors;
    }

    protected String getErrorDetail() {
        return this.errorDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDiskManager(DiskManager new_disk_manager, DiskManagerListener new_disk_manager_listener) {
        try {
            this.disk_listeners_mon.enter();
            DiskManager old_disk_manager = this.disk_manager_use_accessors;
            if (old_disk_manager != null && this.disk_manager_listener_use_accessors != null) {
                old_disk_manager.removeListener(this.disk_manager_listener_use_accessors);
            }
            this.disk_manager_use_accessors = new_disk_manager;
            this.disk_manager_listener_use_accessors = new_disk_manager_listener;
            if (new_disk_manager != null) {
                new_disk_manager.addListener(new_disk_manager_listener);
            }
            this.fileInfoChanged();
            if (new_disk_manager == null && old_disk_manager != null) {
                this.disk_listeners.dispatch(2, old_disk_manager);
            } else if (new_disk_manager != null && old_disk_manager == null) {
                this.disk_listeners.dispatch(1, new_disk_manager);
            } else {
                Debug.out("inconsistent DiskManager state - " + new_disk_manager + "/" + old_disk_manager);
            }
        }
        finally {
            this.disk_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiskListener(DownloadManagerDiskListener listener) {
        try {
            this.disk_listeners_mon.enter();
            this.disk_listeners.addListener(listener);
            DiskManager dm = this.getDiskManager();
            if (dm != null) {
                this.disk_listeners.dispatch(listener, 1, dm);
            }
        }
        finally {
            this.disk_listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiskListener(DownloadManagerDiskListener listener) {
        try {
            this.disk_listeners_mon.enter();
            this.disk_listeners.removeListener(listener);
        }
        finally {
            this.disk_listeners_mon.exit();
        }
    }

    public long getDiskListenerCount() {
        return this.disk_listeners.size();
    }

    public String getDisplayName() {
        return this.download_manager.getDisplayName();
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.download_manager.getEffectiveUploadRateLimitBytesPerSecond();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.stats.getDownloadRateLimitBytesPerSecond();
    }

    public int getMaxUploads() {
        return this.download_manager.getEffectiveMaxUploads();
    }

    public int getMaxConnections() {
        return this.download_manager.getMaxConnections();
    }

    public boolean isAZMessagingEnabled() {
        return this.download_manager.isAZMessagingEnabled();
    }

    public boolean isPeerExchangeEnabled() {
        return this.download_manager.getDownloadState().isPeerSourceEnabled("PeerExchange");
    }

    public boolean isPeriodicRescanEnabled() {
        return this.download_manager.getDownloadState().getFlag(2L);
    }

    public TRTrackerScraperResponse getTrackerScrapeResponse() {
        return this.download_manager.getTrackerScrapeResponse();
    }

    public String getTrackerClientExtensions() {
        return this.download_manager.getDownloadState().getTrackerClientExtensions();
    }

    public void setTrackerRefreshDelayOverrides(int percent) {
        this.download_manager.setTrackerRefreshDelayOverrides(percent);
    }

    public boolean isNATHealthy() {
        return this.download_manager.getNATStatus() == 1;
    }

    public void addPeer(PEPeer peer) {
        this.download_manager.addPeer(peer);
    }

    public void removePeer(PEPeer peer) {
        this.download_manager.removePeer(peer);
    }

    public void addPiece(PEPiece piece) {
        this.download_manager.addPiece(piece);
    }

    public void removePiece(PEPiece piece) {
        this.download_manager.removePiece(piece);
    }

    public void discarded(int bytes) {
        if (this.global_stats != null) {
            this.global_stats.discarded(bytes);
        }
    }

    public void protocolBytesReceived(int bytes) {
        if (this.global_stats != null) {
            this.global_stats.protocolBytesReceived(bytes);
        }
    }

    public void dataBytesReceived(int bytes) {
        if (this.global_stats != null) {
            this.global_stats.dataBytesReceived(bytes);
        }
    }

    public void protocolBytesSent(int bytes, boolean LAN) {
        if (this.global_stats != null) {
            this.global_stats.protocolBytesSent(bytes, LAN);
        }
    }

    public void dataBytesSent(int bytes, boolean LAN) {
        if (this.global_stats != null) {
            this.global_stats.dataBytesSent(bytes, LAN);
        }
    }

    public LogRelation getLogRelation() {
        return this;
    }

    public String getRelationText() {
        return this.download_manager.getRelationText();
    }

    public Object[] getQueryableInterfaces() {
        ArrayList<Object> interfaces = new ArrayList<Object>();
        Object[] intf = this.download_manager.getQueryableInterfaces();
        for (int i = 0; i < intf.length; ++i) {
            interfaces.add(intf[i]);
        }
        interfaces.add(this.download_manager);
        DiskManager dm = this.getDiskManager();
        if (dm != null) {
            interfaces.add(dm);
        }
        return interfaces.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixupFileInfo(fileInfoFacade[] info) {
        if (info.length == 0) {
            return;
        }
        final ArrayList delayed_prio_changes = new ArrayList();
        try {
            int dm_state;
            this.facade_mon.enter();
            DiskManager dm = this.getDiskManager();
            DiskManagerFileInfo[] active = null;
            if (dm != null && ((dm_state = dm.getState()) == 3 || dm_state == 4)) {
                active = dm.getFiles();
            }
            if (active == null) {
                final boolean[] initialising = new boolean[]{true};
                try {
                    if (++skeleton_builds % 1000L == 0L) {
                        Debug.outNoStack("Skeleton builds: " + skeleton_builds);
                    }
                    active = DiskManagerFactory.getFileInfoSkeleton(this.download_manager, new DiskManagerListener(){

                        public void stateChanged(int oldState, int newState) {
                        }

                        public void filePriorityChanged(DiskManagerFileInfo file) {
                            if (initialising[0]) {
                                delayed_prio_changes.add(file);
                            } else {
                                DownloadManagerController.this.download_manager.informPriorityChange(file);
                            }
                        }

                        public void pieceDoneChanged(DiskManagerPiece piece) {
                        }

                        public void fileAccessModeChanged(DiskManagerFileInfo file, int old_mode, int new_mode) {
                        }
                    });
                }
                finally {
                    initialising[0] = false;
                }
                this.calculateCompleteness(active);
            }
            for (int i = 0; i < info.length; ++i) {
                info[i].setDelegate(active[i]);
            }
        }
        finally {
            this.facade_mon.exit();
        }
        this.files_facade = info;
        for (int i = 0; i < delayed_prio_changes.size(); ++i) {
            this.download_manager.informPriorityChange((DiskManagerFileInfo)delayed_prio_changes.get(i));
        }
        delayed_prio_changes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateEvidence(IndentWriter writer) {
        writer.println("DownloadManager Controller:");
        writer.indent();
        try {
            writer.println("cached info: complete w/o DND=" + this.cached_complete_excluding_dnd + "; hasDND? " + this.cached_has_dnd_files);
            writer.println("Complete w/DND? " + this.isDownloadComplete(true) + "; w/o DND? " + this.isDownloadComplete(false));
            writer.println("filesFacade length: " + this.files_facade.length);
            if (this.force_start) {
                writer.println("Force Start");
            }
            writer.println("FilesExist? " + this.filesExist());
        }
        finally {
            writer.exdent();
        }
    }

    static {
        disk_listeners_agregator = ListenerManager.createAsyncManager("DMC:DiskListenAgregatorDispatcher", new ListenerManagerDispatcher(){

            public void dispatch(Object _listener, int type, Object value) {
                DownloadManagerDiskListener listener = (DownloadManagerDiskListener)_listener;
                if (type == 1) {
                    listener.diskManagerAdded((DiskManager)value);
                } else if (type == 2) {
                    listener.diskManagerRemoved((DiskManager)value);
                }
            }
        });
    }

    protected class fileInfoFacade
    implements DiskManagerFileInfo {
        private DiskManagerFileInfo delegate;
        private List listeners;

        protected fileInfoFacade() {
        }

        protected void setDelegate(DiskManagerFileInfo _delegate) {
            if (_delegate == this.delegate) {
                return;
            }
            if (this.delegate != null) {
                this.delegate.close();
            }
            this.delegate = _delegate;
            if (this.listeners != null) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.delegate.addListener((DiskManagerFileInfoListener)this.listeners.get(i));
                }
            }
        }

        public void setPriority(boolean b) {
            this.delegate.setPriority(b);
        }

        public void setSkipped(boolean b) {
            this.delegate.setSkipped(b);
        }

        public boolean setLink(File link_destination) {
            return this.delegate.setLink(link_destination);
        }

        public File getLink() {
            return this.delegate.getLink();
        }

        public boolean setStorageType(int type) {
            return this.delegate.setStorageType(type);
        }

        public int getStorageType() {
            return this.delegate.getStorageType();
        }

        public int getAccessMode() {
            return this.delegate.getAccessMode();
        }

        public long getDownloaded() {
            return this.delegate.getDownloaded();
        }

        public String getExtension() {
            return this.delegate.getExtension();
        }

        public int getFirstPieceNumber() {
            return this.delegate.getFirstPieceNumber();
        }

        public int getLastPieceNumber() {
            return this.delegate.getLastPieceNumber();
        }

        public long getLength() {
            return this.delegate.getLength();
        }

        public int getNbPieces() {
            return this.delegate.getNbPieces();
        }

        public boolean isPriority() {
            return this.delegate.isPriority();
        }

        public boolean isSkipped() {
            return this.delegate.isSkipped();
        }

        public int getIndex() {
            return this.delegate.getIndex();
        }

        public DiskManager getDiskManager() {
            return this.delegate.getDiskManager();
        }

        public DownloadManager getDownloadManager() {
            return DownloadManagerController.this.download_manager;
        }

        public File getFile(boolean follow_link) {
            return this.delegate.getFile(follow_link);
        }

        public TOTorrentFile getTorrentFile() {
            return this.delegate.getTorrentFile();
        }

        public void flushCache() throws Exception {
            this.delegate.flushCache();
        }

        public DirectByteBuffer read(long offset, int length) throws IOException {
            return this.delegate.read(offset, length);
        }

        public void close() {
            this.delegate.close();
        }

        public void addListener(DiskManagerFileInfoListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(listener);
            this.delegate.addListener(listener);
        }

        public void removeListener(DiskManagerFileInfoListener listener) {
            this.listeners.remove(listener);
            this.delegate.removeListener(listener);
        }
    }
}

