/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.access.impl;

import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequest;
import com.aelitis.azureus.core.diskmanager.access.DiskAccessRequestListener;
import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class DiskAccessRequestImpl
extends AERunnable
implements DiskAccessRequest {
    protected static final short OP_READ = 1;
    protected static final short OP_WRITE = 2;
    protected static final short OP_WRITE_AND_FREE = 3;
    private CacheFile file;
    private long offset;
    private DirectByteBuffer buffer;
    private DiskAccessRequestListener listener;
    private short op;
    private short cache_policy;
    private int size;
    private volatile boolean cancelled;

    protected DiskAccessRequestImpl(CacheFile _file, long _offset, DirectByteBuffer _buffer, DiskAccessRequestListener _listener, short _op, short _cache_policy) {
        this.file = _file;
        this.offset = _offset;
        this.buffer = _buffer;
        this.listener = _listener;
        this.op = _op;
        this.cache_policy = _cache_policy;
        this.size = this.buffer.remaining((byte)4);
    }

    public int getSize() {
        return this.size;
    }

    public void runSupport() {
        if (this.cancelled) {
            this.listener.requestCancelled(this);
            return;
        }
        try {
            if (this.op == 1) {
                this.file.read(this.buffer, this.offset, this.cache_policy);
            } else if (this.op == 2) {
                this.file.write(this.buffer, this.offset);
            } else {
                this.file.writeAndHandoverBuffer(this.buffer, this.offset);
            }
            this.listener.requestComplete(this);
        }
        catch (Throwable e) {
            this.listener.requestFailed(this, e);
        }
    }

    public CacheFile getFile() {
        return this.file;
    }

    public long getOffset() {
        return this.offset;
    }

    public DirectByteBuffer getBuffer() {
        return this.buffer;
    }

    public void cancel() {
        this.cancelled = true;
    }
}

