/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketReplyStats
extends DHTUDPPacketReply {
    private int stats_type = 1;
    private DHTTransportFullStats original_stats;
    private byte[] new_stats;

    public DHTUDPPacketReplyStats(DHTTransportUDPImpl transport, int trans_id, long conn_id, DHTTransportContact local_contact, DHTTransportContact remote_contact) {
        super(transport, 1033, trans_id, conn_id, local_contact, remote_contact);
    }

    protected DHTUDPPacketReplyStats(DHTUDPPacketNetworkHandler network_handler, DataInputStream is, int trans_id) throws IOException {
        super(network_handler, is, 1033, trans_id);
        if (this.getProtocolVersion() >= 15) {
            this.stats_type = is.readInt();
            if (this.stats_type == 1) {
                this.original_stats = DHTUDPUtils.deserialiseStats(this.getProtocolVersion(), is);
            } else {
                this.new_stats = DHTUDPUtils.deserialiseByteArray(is, 65535);
            }
        } else {
            this.original_stats = DHTUDPUtils.deserialiseStats(this.getProtocolVersion(), is);
        }
    }

    public int getStatsType() {
        return this.stats_type;
    }

    public DHTTransportFullStats getOriginalStats() {
        return this.original_stats;
    }

    public void setOriginalStats(DHTTransportFullStats _stats) {
        this.stats_type = 1;
        this.original_stats = _stats;
    }

    public byte[] getNewStats() {
        return this.new_stats;
    }

    public void setNewStats(byte[] _stats, int _stats_type) {
        this.stats_type = _stats_type;
        this.new_stats = _stats;
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        if (this.getProtocolVersion() >= 15) {
            os.writeInt(this.stats_type);
            if (this.stats_type == 1) {
                DHTUDPUtils.serialiseStats(this.getProtocolVersion(), os, this.original_stats);
            } else {
                DHTUDPUtils.serialiseByteArray(os, this.new_stats, 65535);
            }
        } else {
            DHTUDPUtils.serialiseStats(this.getProtocolVersion(), os, this.original_stats);
        }
    }
}

