/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.GenericActionPerformer;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionConnectionProxy
implements UISWTConfigSection {
    private static final String CFG_PREFIX = "ConfigView.section.proxy.";
    private final int REQUIRED_MODE = 2;

    public String configSectionGetParentSection() {
        return "server";
    }

    public String configSectionGetName() {
        return "proxy";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        cSection.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 2) {
            Label label = new Label(cSection, 64);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
            String param1 = 2 < modeKeys.length ? MessageText.getString(modeKeys[2]) : String.valueOf(2);
            String param2 = userMode < modeKeys.length ? MessageText.getString(modeKeys[userMode]) : String.valueOf(userMode);
            label.setText(MessageText.getString("ConfigView.notAvailableForMode", new String[]{param1, param2}));
            return cSection;
        }
        Group gProxyTracker = new Group(cSection, 0);
        Messages.setLanguageText((Widget)gProxyTracker, "ConfigView.section.proxy.group.tracker");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gProxyTracker.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gProxyTracker.setLayout((Layout)layout);
        final BooleanParameter enableProxy = new BooleanParameter((Composite)gProxyTracker, "Enable.Proxy", false, "ConfigView.section.proxy.enable_proxy");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enableProxy.setLayoutData(gridData);
        BooleanParameter enableSocks = new BooleanParameter((Composite)gProxyTracker, "Enable.SOCKS", false, "ConfigView.section.proxy.enable_socks");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enableSocks.setLayoutData(gridData);
        Label lHost = new Label((Composite)gProxyTracker, 0);
        Messages.setLanguageText((Widget)lHost, "ConfigView.section.proxy.host");
        StringParameter pHost = new StringParameter((Composite)gProxyTracker, "Proxy.Host", "");
        gridData = new GridData();
        gridData.widthHint = 105;
        pHost.setLayoutData(gridData);
        Label lPort = new Label((Composite)gProxyTracker, 0);
        Messages.setLanguageText((Widget)lPort, "ConfigView.section.proxy.port");
        StringParameter pPort = new StringParameter((Composite)gProxyTracker, "Proxy.Port", "");
        gridData = new GridData();
        gridData.widthHint = 40;
        pPort.setLayoutData(gridData);
        Label lUser = new Label((Composite)gProxyTracker, 0);
        Messages.setLanguageText((Widget)lUser, "ConfigView.section.proxy.username");
        StringParameter pUser = new StringParameter((Composite)gProxyTracker, "Proxy.Username", "");
        gridData = new GridData();
        gridData.widthHint = 105;
        pUser.setLayoutData(gridData);
        Label lPass = new Label((Composite)gProxyTracker, 0);
        Messages.setLanguageText((Widget)lPass, "ConfigView.section.proxy.password");
        StringParameter pPass = new StringParameter((Composite)gProxyTracker, "Proxy.Password", "");
        gridData = new GridData();
        gridData.widthHint = 105;
        pPass.setLayoutData(gridData);
        Group gProxyPeer = new Group(cSection, 0);
        Messages.setLanguageText((Widget)gProxyPeer, "ConfigView.section.proxy.group.peer");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gProxyPeer.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gProxyPeer.setLayout((Layout)layout);
        final BooleanParameter enableSocksPeer = new BooleanParameter((Composite)gProxyPeer, "Proxy.Data.Enable", false, "ConfigView.section.proxy.enable_socks.peer");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enableSocksPeer.setLayoutData(gridData);
        BooleanParameter socksPeerInform = new BooleanParameter((Composite)gProxyPeer, "Proxy.Data.SOCKS.inform", true, "ConfigView.section.proxy.peer.informtracker");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        socksPeerInform.setLayoutData(gridData);
        Label lSocksVersion = new Label((Composite)gProxyPeer, 0);
        Messages.setLanguageText((Widget)lSocksVersion, "ConfigView.section.proxy.socks.version");
        String[] socks_types = new String[]{"V4", "V4a", "V5"};
        String[] dropLabels = new String[socks_types.length];
        String[] dropValues = new String[socks_types.length];
        for (int i = 0; i < socks_types.length; ++i) {
            dropLabels[i] = socks_types[i];
            dropValues[i] = socks_types[i];
        }
        StringListParameter socksType = new StringListParameter((Composite)gProxyPeer, "Proxy.Data.SOCKS.version", "V4", dropLabels, dropValues);
        final BooleanParameter sameConfig = new BooleanParameter((Composite)gProxyPeer, "Proxy.Data.Same", true, "ConfigView.section.proxy.peer.same");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        sameConfig.setLayoutData(gridData);
        Label lDataHost = new Label((Composite)gProxyPeer, 0);
        Messages.setLanguageText((Widget)lDataHost, "ConfigView.section.proxy.host");
        StringParameter pDataHost = new StringParameter((Composite)gProxyPeer, "Proxy.Data.Host", "");
        gridData = new GridData();
        gridData.widthHint = 105;
        pDataHost.setLayoutData(gridData);
        Label lDataPort = new Label((Composite)gProxyPeer, 0);
        Messages.setLanguageText((Widget)lDataPort, "ConfigView.section.proxy.port");
        StringParameter pDataPort = new StringParameter((Composite)gProxyPeer, "Proxy.Data.Port", "");
        gridData = new GridData();
        gridData.widthHint = 40;
        pDataPort.setLayoutData(gridData);
        Label lDataUser = new Label((Composite)gProxyPeer, 0);
        Messages.setLanguageText((Widget)lDataUser, "ConfigView.section.proxy.username");
        StringParameter pDataUser = new StringParameter((Composite)gProxyPeer, "Proxy.Data.Username", "");
        gridData = new GridData();
        gridData.widthHint = 105;
        pDataUser.setLayoutData(gridData);
        Label lDataPass = new Label((Composite)gProxyPeer, 0);
        Messages.setLanguageText((Widget)lDataPass, "ConfigView.section.proxy.password");
        StringParameter pDataPass = new StringParameter((Composite)gProxyPeer, "Proxy.Data.Password", "");
        gridData = new GridData();
        gridData.widthHint = 105;
        pDataPass.setLayoutData(gridData);
        final Control[] proxy_controls = new Control[]{enableSocks.getControl(), lHost, pHost.getControl(), lPort, pPort.getControl(), lUser, pUser.getControl(), lPass, pPass.getControl()};
        GenericActionPerformer proxy_enabler = new GenericActionPerformer(new Control[0]){

            public void performAction() {
                for (int i = 0; i < proxy_controls.length; ++i) {
                    proxy_controls[i].setEnabled(enableProxy.isSelected());
                }
            }
        };
        final Control[] proxy_peer_controls = new Control[]{lDataHost, pDataHost.getControl(), lDataPort, pDataPort.getControl(), lDataUser, pDataUser.getControl(), lDataPass, pDataPass.getControl()};
        final Control[] proxy_peer_details = new Control[]{sameConfig.getControl(), socksPeerInform.getControl(), socksType.getControl(), lSocksVersion};
        GenericActionPerformer proxy_peer_enabler = new GenericActionPerformer(new Control[0]){

            public void performAction() {
                int i;
                for (i = 0; i < proxy_peer_controls.length; ++i) {
                    proxy_peer_controls[i].setEnabled(enableSocksPeer.isSelected() && !sameConfig.isSelected());
                }
                for (i = 0; i < proxy_peer_details.length; ++i) {
                    proxy_peer_details[i].setEnabled(enableSocksPeer.isSelected());
                }
            }
        };
        enableSocks.setAdditionalActionPerformer(proxy_enabler);
        enableProxy.setAdditionalActionPerformer(proxy_enabler);
        enableSocksPeer.setAdditionalActionPerformer(proxy_peer_enabler);
        sameConfig.setAdditionalActionPerformer(proxy_peer_enabler);
        return cSection;
    }
}

