/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.common.util.UserAlerts;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.LocaleUtilSWT;
import org.gudy.azureus2.ui.swt.StartServer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.associations.AssociationChecker;
import org.gudy.azureus2.ui.swt.auth.AuthenticatorWindow;
import org.gudy.azureus2.ui.swt.auth.CertificateTrustWindow;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.Cursors;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import org.gudy.azureus2.ui.swt.mainwindow.SplashWindow;
import org.gudy.azureus2.ui.swt.mainwindow.StartupUtils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.networks.SWTNetworkSelection;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;
import org.gudy.azureus2.ui.swt.updater2.SWTUpdateChecker;

public class Initializer
implements AzureusCoreListener {
    private static final LogIDs LOGID = LogIDs.GUI;
    private AzureusCore azureus_core;
    private GlobalManager gm;
    private StartServer startServer;
    private ArrayList listeners;
    private AEMonitor listeners_mon = new AEMonitor("Initializer:l");
    private String[] args;
    private int nbTasks = 1;
    private int currentTask = 0;
    private int currentPercent = 0;

    public Initializer(AzureusCore _azureus_core, StartServer _server, String[] _args) {
        this.listeners = new ArrayList();
        this.azureus_core = _azureus_core;
        this.startServer = _server;
        this.args = _args;
        this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public boolean stopRequested(AzureusCore _core) throws AzureusCoreException {
                return Initializer.this.handleStopRestart(false);
            }

            public boolean restartRequested(AzureusCore core) {
                return Initializer.this.handleStopRestart(true);
            }
        });
        try {
            SWTThread.createInstance(this);
        }
        catch (SWTThreadAlreadyInstanciatedException e) {
            Debug.printStackTrace(e);
        }
    }

    public boolean handleStopRestart(final boolean restart) {
        if (MainWindow.getWindow().getDisplay().getThread() == Thread.currentThread()) {
            return MainWindow.getWindow().dispose(restart, true);
        }
        final AESemaphore sem = new AESemaphore("SWTInit::stopRestartRequest");
        final boolean[] ok = new boolean[]{false};
        try {
            Utils.execSWTThread(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    try {
                        ok[0] = MainWindow.getWindow().dispose(restart, true);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    finally {
                        sem.release();
                    }
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            sem.release();
        }
        sem.reserve();
        return ok[0];
    }

    public void run() {
        try {
            new LocaleUtilSWT(this.azureus_core);
            SWTThread swt = SWTThread.getInstance();
            Display display = swt.getDisplay();
            ImageRepository.loadImagesForSplashWindow(display);
            if (COConfigurationManager.getBooleanParameter("Show Splash", true)) {
                SplashWindow.create(display, this);
            }
            this.setNbTasks(6);
            this.nextTask();
            this.reportCurrentTaskByKey("splash.firstMessageNoI18N");
            Alerts.init();
            final ArrayList logEvents = new ArrayList();
            ILogEventListener logListener = null;
            if (COConfigurationManager.getBooleanParameter("Open Console", false)) {
                logListener = new ILogEventListener(){

                    public void log(LogEvent event) {
                        logEvents.add(event);
                    }
                };
                Logger.addListener(logListener);
            }
            final ILogEventListener finalLogListener = logListener;
            StartupUtils.setLocale();
            new SWTNetworkSelection();
            new AuthenticatorWindow();
            new CertificateTrustWindow();
            InstallPluginWizard.register(this.azureus_core, display);
            this.nextTask();
            this.reportCurrentTaskByKey("splash.loadingImages");
            ImageRepository.loadImages(display);
            this.nextTask();
            this.reportCurrentTaskByKey("splash.initializeGM");
            this.azureus_core.addListener(this);
            this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                public void componentCreated(AzureusCore core, AzureusCoreComponent comp) {
                    if (comp instanceof GlobalManager) {
                        Initializer.this.gm = (GlobalManager)comp;
                        new UserAlerts(Initializer.this.gm);
                        Initializer.this.nextTask();
                        Initializer.this.reportCurrentTaskByKey("splash.initializeGui");
                        new Colors();
                        Cursors.init();
                        new MainWindow(core, Initializer.this, logEvents);
                        if (finalLogListener != null) {
                            Logger.removeListener(finalLogListener);
                        }
                        AssociationChecker.checkAssociations();
                        Initializer.this.nextTask();
                        Initializer.this.reportCurrentTask(MessageText.getString("splash.initializePlugins"));
                    }
                }

                public void started(AzureusCore core) {
                    Initializer.this.nextTask();
                    Initializer.this.reportCurrentTaskByKey("splash.openViews");
                    SWTUpdateChecker.initialize();
                    UpdateMonitor.getSingleton(core);
                    Alerts.initComplete();
                    Initializer.this.nextTask();
                    for (int i = 0; i < Initializer.this.args.length; ++i) {
                        try {
                            TorrentOpener.openTorrent(Initializer.this.args[i]);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            });
            this.azureus_core.start();
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Initialization fails:", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AzureusCoreListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AzureusCoreListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCurrentTask(String currentTaskString) {
        try {
            this.listeners_mon.enter();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                AzureusCoreListener listener = (AzureusCoreListener)iter.next();
                listener.reportCurrentTask(currentTaskString);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportPercent(int percent) {
        try {
            this.listeners_mon.enter();
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                AzureusCoreListener listener = (AzureusCoreListener)iter.next();
                listener.reportPercent(this.overallPercent(percent));
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt(boolean for_restart, boolean close_already_in_progress) throws AzureusCoreException {
        block11: {
            if (this.azureus_core != null && !close_already_in_progress && for_restart) {
                this.azureus_core.checkRestartSupported();
            }
            try {
                if (this.startServer != null) {
                    this.startServer.stopIt();
                }
                Cursors.dispose();
                SWTThread.getInstance().terminate();
                Object var4_3 = null;
                if (this.azureus_core == null || close_already_in_progress) break block11;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (this.azureus_core != null && !close_already_in_progress) {
                    try {
                        if (for_restart) {
                            this.azureus_core.restart();
                        } else {
                            this.azureus_core.stop();
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                throw throwable;
            }
            try {
                if (for_restart) {
                    this.azureus_core.restart();
                    break block11;
                }
                this.azureus_core.stop();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    private void setNbTasks(int _nbTasks) {
        this.currentTask = 0;
        this.nbTasks = _nbTasks;
    }

    private void nextTask() {
        ++this.currentTask;
        this.currentPercent = 100 * this.currentTask / this.nbTasks;
        this.reportPercent(0);
    }

    private int overallPercent(int taskPercent) {
        return this.currentPercent + taskPercent / this.nbTasks;
    }

    private void reportCurrentTaskByKey(String key) {
        this.reportCurrentTask(MessageText.getString(key));
    }

    public static void main(String[] args) {
        AzureusCore core = AzureusCoreFactory.create();
        new Initializer(core, null, args);
    }
}

