/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.auth;

import java.security.cert.X509Certificate;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SECertificateListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;

public class CertificateTrustWindow
implements SECertificateListener {
    public CertificateTrustWindow() {
        SESecurityManager.addCertificateListener(this);
    }

    public boolean trustCertificate(final String resource, final X509Certificate cert) {
        final Display display = MainWindow.getWindow().getDisplay();
        if (display.isDisposed()) {
            return false;
        }
        final AESemaphore sem = new AESemaphore("SWTCert");
        final trustDialog[] dialog = new trustDialog[1];
        try {
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    dialog[0] = new trustDialog(sem, display, resource, cert);
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
        sem.reserve();
        return dialog[0].getTrusted();
    }

    protected class trustDialog {
        protected Shell shell;
        protected AESemaphore sem;
        protected boolean trusted;

        protected trustDialog(AESemaphore _sem, Display display, String resource, X509Certificate cert) {
            this.sem = _sem;
            if (display.isDisposed()) {
                this.sem.release();
                return;
            }
            this.shell = new Shell(display, 67680);
            if (!Constants.isOSX) {
                this.shell.setImage(ImageRepository.getImage("azureus"));
            }
            this.shell.setText(MessageText.getString("security.certtruster.title"));
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout((Layout)layout);
            Label info_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)info_label, "security.certtruster.intro");
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            info_label.setLayoutData((Object)gridData);
            Label resource_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)resource_label, "security.certtruster.resource");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            resource_label.setLayoutData((Object)gridData);
            Label resource_value = new Label((Composite)this.shell, 0);
            resource_value.setText(resource.replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            resource_value.setLayoutData((Object)gridData);
            Label issued_by_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)issued_by_label, "security.certtruster.issuedby");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            issued_by_label.setLayoutData((Object)gridData);
            Label issued_by_value = new Label((Composite)this.shell, 0);
            issued_by_value.setText(this.extractCN(cert.getIssuerDN().getName()).replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            issued_by_value.setLayoutData((Object)gridData);
            Label issued_to_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)issued_to_label, "security.certtruster.issuedto");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            issued_to_label.setLayoutData((Object)gridData);
            Label issued_to_value = new Label((Composite)this.shell, 0);
            issued_to_value.setText(this.extractCN(cert.getSubjectDN().getName()).replaceAll("&", "&&"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            issued_to_value.setLayoutData((Object)gridData);
            Label prompt_label = new Label((Composite)this.shell, 0);
            Messages.setLanguageText((Widget)prompt_label, "security.certtruster.prompt");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            prompt_label.setLayoutData((Object)gridData);
            Label labelSeparator = new Label((Composite)this.shell, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            labelSeparator.setLayoutData((Object)gridData);
            new Label((Composite)this.shell, 0);
            Composite comp = new Composite((Composite)this.shell, 0);
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            comp.setLayoutData((Object)gridData);
            GridLayout layoutButtons = new GridLayout();
            layoutButtons.numColumns = 2;
            comp.setLayout((Layout)layoutButtons);
            Button bYes = new Button(comp, 8);
            bYes.setText(MessageText.getString("security.certtruster.yes"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            bYes.setLayoutData((Object)gridData);
            bYes.addListener(13, new Listener(this){
                private final /* synthetic */ trustDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleEvent(Event e) {
                    this.this$1.close(true);
                }
            });
            Button bNo = new Button(comp, 8);
            bNo.setText(MessageText.getString("security.certtruster.no"));
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            bNo.setLayoutData((Object)gridData);
            bNo.addListener(13, new Listener(this){
                private final /* synthetic */ trustDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleEvent(Event e) {
                    this.this$1.close(false);
                }
            });
            this.shell.setDefaultButton(bYes);
            this.shell.addListener(31, new Listener(this){
                private final /* synthetic */ trustDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        this.this$1.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
        }

        protected void close(boolean ok) {
            this.trusted = ok;
            this.shell.dispose();
            this.sem.release();
        }

        protected String extractCN(String dn) {
            int p1 = dn.indexOf("CN=");
            if (p1 == -1) {
                return dn;
            }
            int p2 = dn.indexOf(",", p1);
            if (p2 == -1) {
                return dn.substring(p1 + 3).trim();
            }
            return dn.substring(p1 + 3, p2).trim();
        }

        public boolean getTrusted() {
            return this.trusted;
        }
    }
}

