/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Messages;

public final class KeyBindings {
    private static final Pattern FUNC_EXP = Pattern.compile("([fF]{1})([1-9]{1}[0-5]{0,1})");
    private static final Pattern SANCTIONED_EXP = Pattern.compile("([ a-zA-Z\\d/\\\\=\\-,\\.`]{1})");
    private static final String[] SPECIAL_KEYS = new String[]{"Meta", "Ctrl", "Cmd", "Alt", "Opt", "Shift", "Ins", "Backspace", "Del", "Esc", "PgUp", "PgDn", "Left", "Up", "Right", "Down", "Home", "End", "Tab"};
    private static final int[] SPECIAL_VALUES = new int[]{SWT.MOD1, 262144, SWT.MOD1, 65536, 65536, 131072, 0x1000009, 8, 127, 27, 0x1000005, 0x1000006, 16384, 128, 131072, 1024, 0x1000007, 0x1000008, 9};
    private static final String DELIM = "+";
    private static final String DELIM_EXP = "\\+";

    private static String getPlatformKeySuffix() {
        if (Constants.isLinux) {
            return ".linux";
        }
        if (Constants.isSolaris) {
            return ".solaris";
        }
        if (Constants.isOSX) {
            return ".mac";
        }
        if (Constants.isWindows) {
            return ".windows";
        }
        return "";
    }

    private static KeyBindingInfo parseKeyBinding(String keyBindingValue) {
        if (keyBindingValue.length() < 1) {
            return new KeyBindingInfo(null, 0);
        }
        int swtAccelerator = 0;
        String[] tmpValues = keyBindingValue.split(DELIM_EXP);
        boolean[] specVisited = new boolean[SPECIAL_KEYS.length];
        boolean funcVisited = false;
        StringBuffer displayValue = new StringBuffer(keyBindingValue.length() + 2);
        displayValue.append('\t');
        for (int i = 0; i < tmpValues.length; ++i) {
            char c;
            int subStrIndex;
            Matcher valMatcher;
            Matcher funcMatcher;
            String value = tmpValues[i];
            boolean matched = false;
            for (int j = 0; j < SPECIAL_KEYS.length; ++j) {
                if (specVisited[j] || !SPECIAL_KEYS[j].equalsIgnoreCase(value)) continue;
                swtAccelerator |= SPECIAL_VALUES[j];
                if (SPECIAL_KEYS[j].equalsIgnoreCase("Meta")) {
                    displayValue.append(Constants.isOSX ? "Cmd" : "Ctrl").append(DELIM);
                } else {
                    displayValue.append(SPECIAL_KEYS[j]).append(DELIM);
                }
                specVisited[j] = true;
                matched = true;
                break;
            }
            if (matched) continue;
            if (!funcVisited && (funcMatcher = FUNC_EXP.matcher(value)).find() && funcMatcher.start() == 0 && funcMatcher.end() == value.length()) {
                int funcVal = Integer.parseInt(funcMatcher.group(2));
                swtAccelerator |= 0x1000000 + (9 + funcVal);
                displayValue.append(funcMatcher.group(0)).append(DELIM);
                funcVisited = true;
                matched = true;
            }
            if (matched || !(valMatcher = SANCTIONED_EXP.matcher(value)).find() || valMatcher.start() != 0 || (subStrIndex = displayValue.indexOf((c = valMatcher.group().charAt(0)) + DELIM)) == 1 || subStrIndex > 1 && displayValue.substring(subStrIndex - 1, subStrIndex).equals(DELIM)) continue;
            swtAccelerator |= c;
            displayValue.append(c).append(DELIM);
        }
        if (funcVisited || specVisited[0] || specVisited[1] || specVisited[2] || specVisited[3] || specVisited[4]) {
            return new KeyBindingInfo(displayValue.substring(0, displayValue.length() - 1), swtAccelerator);
        }
        return new KeyBindingInfo(null, 0);
    }

    public static void removeAccelerator(MenuItem menu, String localizationKey) {
        KeyBindings.setAccelerator(menu, new KeyBindingInfo("", 0));
        Messages.setLanguageText((Widget)menu, localizationKey);
    }

    public static void setAccelerator(MenuItem menu, String localizationKey) {
        String platformSpecificKey = (localizationKey = localizationKey + ".keybinding") + KeyBindings.getPlatformKeySuffix();
        if (MessageText.keyExists(platformSpecificKey)) {
            KeyBindings.setAccelerator(menu, KeyBindings.parseKeyBinding(MessageText.getString(platformSpecificKey)));
        } else if (MessageText.keyExists(localizationKey)) {
            KeyBindings.setAccelerator(menu, KeyBindings.parseKeyBinding(MessageText.getString(localizationKey)));
        } else if (!MessageText.isCurrentLocale(MessageText.LOCALE_DEFAULT)) {
            if (MessageText.keyExistsForDefaultLocale(platformSpecificKey)) {
                KeyBindings.setAccelerator(menu, KeyBindings.parseKeyBinding(MessageText.getDefaultLocaleString(platformSpecificKey)));
            } else if (MessageText.keyExistsForDefaultLocale(localizationKey)) {
                KeyBindings.setAccelerator(menu, KeyBindings.parseKeyBinding(MessageText.getDefaultLocaleString(localizationKey)));
            }
        }
    }

    private static void setAccelerator(MenuItem menu, KeyBindingInfo kbInfo) {
        if (kbInfo.accelerator != 0) {
            menu.setAccelerator(kbInfo.accelerator);
            if (!Constants.isOSX && !menu.getText().endsWith(kbInfo.name)) {
                menu.setText(menu.getText() + kbInfo.name);
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(KeyBindings.parseKeyBinding("Ctrl+1").name);
        System.out.println(KeyBindings.parseKeyBinding("Ctrl+F12").name);
        System.out.println(KeyBindings.parseKeyBinding("Ctrl+F4").name);
        System.out.println("Meta+Shift+O");
        System.out.println(KeyBindings.parseKeyBinding("Ctrl+Shift+O").accelerator);
        System.out.println(KeyBindings.parseKeyBinding("Shift+Ctrl+O").accelerator);
        System.out.println(SWT.MOD1 | 0x20000 | 0x4F);
        System.out.println("Meta+Shift+o");
        System.out.println(SWT.MOD1 | 0x20000 | 0x6F);
    }

    private static class KeyBindingInfo {
        private final String name;
        private final int accelerator;

        private KeyBindingInfo(String name, int accelerator) {
            this.name = name;
            this.accelerator = accelerator;
        }
    }
}

