/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.shells.MessagePopupShell;

public class Alerts {
    private static Alerts instance;
    private static AEMonitor class_mon;
    private List alert_queue = new ArrayList();
    private AEMonitor alert_queue_mon = new AEMonitor("Alerts:Q");
    private List alert_history = new ArrayList();
    private AEMonitor alert_history_mon = new AEMonitor("Alerts:H");
    private boolean initialisation_complete = false;

    private Alerts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Alerts getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new Alerts();
            }
            Alerts alerts = instance;
            return alerts;
        }
        finally {
            class_mon.exit();
        }
    }

    public static void showWarningMessageBox(String message) {
        Alerts.showMessageBoxUsingResourceString(8, "AlertMessageBox.warning", message);
    }

    public static void showMessageBoxUsingResourceString(int type, String key, String message) {
        Alerts.showMessageBox(type, MessageText.getString(key), message, null);
    }

    public static void showMessageBox(final int type, final String title, final String message, final String details) {
        final Display display = SWTThread.getInstance().getDisplay();
        display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                String icon_str = type == 2 ? "info" : (type == 8 ? "warning" : "error");
                new MessagePopupShell(display, icon_str, title, message == null ? "" : message, details);
            }
        });
    }

    public static void showErrorMessageBoxUsingResourceString(String title_key, Throwable error) {
        Alerts.showErrorMessageBox(MessageText.getString(title_key), error);
    }

    public static void showErrorMessageBox(String title, Throwable error) {
        String error_message = Debug.getStackTrace(error);
        Alerts.showMessageBox(1, title, error.getMessage(), error_message);
    }

    public static void showErrorMessageBox(String message) {
        Alerts.showMessageBoxUsingResourceString(1, "AlertMessageBox.error", message);
    }

    public static void showCommentMessageBox(String message) {
        Alerts.showMessageBoxUsingResourceString(2, "AlertMessageBox.information", message);
    }

    public static void showAlert(int type, String message, boolean repeatable) {
        Alerts.getInstance().showAlertI(type, message, repeatable);
    }

    public static void showAlert(String message, Throwable exception, boolean repeatable) {
        Alerts.getInstance().showAlertI(message, exception, repeatable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAlertI(String message, Throwable exception, boolean repeatable) {
        try {
            this.alert_history_mon.enter();
            if (!repeatable) {
                String key = message + ":" + exception.toString();
                if (this.alert_history.contains(key)) {
                    return;
                }
                this.alert_history.add(key);
                if (this.alert_history.size() > 512) {
                    this.alert_history.remove(0);
                }
            }
        }
        finally {
            this.alert_history_mon.exit();
        }
        Alerts.showErrorMessageBox(message, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAlertI(int type, String message, boolean repeatable) {
        try {
            this.alert_history_mon.enter();
            if (!repeatable) {
                if (this.alert_history.contains(message)) {
                    return;
                }
                this.alert_history.add(message);
                if (this.alert_history.size() > 512) {
                    this.alert_history.remove(0);
                }
            }
        }
        finally {
            this.alert_history_mon.exit();
        }
        if (type == 0) {
            Alerts.showCommentMessageBox(message);
        } else if (type == 1) {
            Alerts.showWarningMessageBox(message);
        } else {
            Alerts.showErrorMessageBox(message);
        }
    }

    public static void initComplete() {
        Alerts.getInstance().initCompleteI();
    }

    private void initCompleteI() {
        new AEThread("Init Complete"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    Alerts.this.alert_queue_mon.enter();
                    Alerts.this.initialisation_complete = true;
                    for (int i = 0; i < Alerts.this.alert_queue.size(); ++i) {
                        Object[] x = (Object[])Alerts.this.alert_queue.get(i);
                        boolean repeatable = (Boolean)x[2];
                        if (x[0] instanceof String) {
                            String message = (String)x[0];
                            Throwable exception = (Throwable)x[1];
                            Alerts.showAlert(message, exception, repeatable);
                            continue;
                        }
                        int type = (Integer)x[0];
                        String message = (String)x[1];
                        Alerts.showAlert(type, message, repeatable);
                    }
                    Alerts.this.alert_queue.clear();
                }
                finally {
                    Alerts.this.alert_queue_mon.exit();
                }
            }
        }.start();
    }

    public static void init() {
        Alerts.getInstance().initI();
    }

    private void initI() {
        Logger.addListener(new ILogAlertListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alertRaised(LogAlert alert) {
                try {
                    Alerts.this.alert_queue_mon.enter();
                    if (!Alerts.this.initialisation_complete) {
                        if (alert.err == null) {
                            Alerts.this.alert_queue.add(new Object[]{new Integer(alert.entryType), alert.text, new Boolean(alert.repeatable)});
                        } else {
                            Alerts.this.alert_queue.add(new Object[]{alert.text, alert.err, new Boolean(alert.repeatable)});
                        }
                        return;
                    }
                }
                finally {
                    Alerts.this.alert_queue_mon.exit();
                }
                if (alert.err == null) {
                    Alerts.showAlert(alert.entryType, alert.text, alert.repeatable);
                } else {
                    Alerts.showAlert(alert.text, alert.err, alert.repeatable);
                }
            }
        });
    }

    static {
        class_mon = new AEMonitor("Alerts:class");
    }
}

