/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.TorrentCommand;

public class TorrentHost
extends TorrentCommand {
    public TorrentHost() {
        super(new String[]{"host"}, "Hosting");
    }

    protected boolean performCommand(ConsoleInput ci, DownloadManager dm, List args) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                ci.azureus_core.getTrackerHost().hostTorrent(torrent, true, false);
            }
            catch (TRHostException e) {
                e.printStackTrace(ci.out);
                return false;
            }
            return true;
        }
        return false;
    }

    public String getCommandDescriptions() {
        return "host (<torrentoptions>)\t\th\tHost torrent(s).";
    }
}

