/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.logging.LoggerAlertListener;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.pluginsimpl.local.logging.LoggerChannelImpl;

public class LoggerImpl
implements Logger {
    private PluginInterface pi;
    private List channels = new ArrayList();
    private Map alert_listeners_map = new HashMap();

    public LoggerImpl(PluginInterface _pi) {
        this.pi = _pi;
    }

    public PluginInterface getPluginInterface() {
        return this.pi;
    }

    public LoggerChannel getChannel(String name) {
        LoggerChannelImpl channel = new LoggerChannelImpl(this, name, false, false);
        this.channels.add(channel);
        return channel;
    }

    public LoggerChannel getTimeStampedChannel(String name) {
        LoggerChannelImpl channel = new LoggerChannelImpl(this, name, true, false);
        this.channels.add(channel);
        return channel;
    }

    public LoggerChannel getNullChannel(String name) {
        LoggerChannelImpl channel = new LoggerChannelImpl(this, name, true, true);
        this.channels.add(channel);
        return channel;
    }

    public LoggerChannel[] getChannels() {
        LoggerChannel[] res = new LoggerChannel[this.channels.size()];
        this.channels.toArray(res);
        return res;
    }

    public void addAlertListener(final LoggerAlertListener listener) {
        ILogAlertListener lg_listener = new ILogAlertListener(){

            public void alertRaised(LogAlert alert) {
                if (alert.err == null) {
                    int type = alert.entryType == 0 ? 1 : (alert.entryType == 1 ? 2 : 3);
                    listener.alertLogged(type, alert.text, alert.repeatable);
                } else {
                    listener.alertLogged(alert.text, alert.err, alert.repeatable);
                }
            }
        };
        this.alert_listeners_map.put(listener, lg_listener);
        org.gudy.azureus2.core3.logging.Logger.addListener(lg_listener);
    }

    public void removeAlertListener(LoggerAlertListener listener) {
        ILogAlertListener lg_listener = (ILogAlertListener)this.alert_listeners_map.remove(listener);
        if (lg_listener != null) {
            org.gudy.azureus2.core3.logging.Logger.removeListener(lg_listener);
        }
    }
}

