/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactoryListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.dht.TRTrackerServerDHT;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking.TRBlockingServer;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.nonblocking.TRNonBlockingServer;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerUDP;
import org.gudy.azureus2.core3.util.AEMonitor;

public class TRTrackerServerFactoryImpl {
    protected static List servers = new ArrayList();
    protected static List listeners = new ArrayList();
    protected static AEMonitor class_mon = new AEMonitor("TRTrackerServerFactory");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerServer create(String name, int protocol, int port, boolean ssl, boolean apply_ip_filter, boolean main_tracker) throws TRTrackerServerException {
        try {
            TRTrackerServerImpl server;
            class_mon.enter();
            if (protocol == 1) {
                server = COConfigurationManager.getBooleanParameter("Tracker TCP NonBlocking") && main_tracker && !ssl ? new TRNonBlockingServer(name, port, apply_ip_filter) : new TRBlockingServer(name, port, ssl, apply_ip_filter);
            } else if (protocol == 2) {
                if (ssl) {
                    throw new TRTrackerServerException("TRTrackerServerFactory: UDP doesn't support SSL");
                }
                server = new TRTrackerServerUDP(name, port);
            } else {
                server = new TRTrackerServerDHT(name);
            }
            servers.add(server);
            for (int i = 0; i < listeners.size(); ++i) {
                ((TRTrackerServerFactoryListener)listeners.get(i)).serverCreated(server);
            }
            TRTrackerServerImpl tRTrackerServerImpl = server;
            return tRTrackerServerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(TRTrackerServerFactoryListener l) {
        try {
            class_mon.enter();
            listeners.add(l);
            for (int i = 0; i < servers.size(); ++i) {
                l.serverCreated((TRTrackerServer)servers.get(i));
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(TRTrackerServerFactoryListener l) {
        try {
            class_mon.enter();
            TRTrackerServerFactoryImpl.removeListener(l);
        }
        finally {
            class_mon.exit();
        }
    }
}

