/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.util;

import java.util.HashSet;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;

public class PeerUtils {
    private static final String CONFIG_MAX_CONN_PER_TORRENT = "Max.Peer.Connections.Per.Torrent";
    private static final String CONFIG_MAX_CONN_TOTAL = "Max.Peer.Connections.Total";
    public static int MAX_CONNECTIONS_PER_TORRENT;
    public static int MAX_CONNECTIONS_TOTAL;
    private static Set ignore_peer_ports;

    public static int numNewConnectionsAllowed(PeerIdentityDataID data_id, int specific_max) {
        int allowed;
        int curConnPerTorrent = PeerIdentityManager.getIdentityCount(data_id);
        int curConnTotal = PeerIdentityManager.getTotalIdentityCount();
        int PER_TORRENT_LIMIT = specific_max > 0 ? specific_max : MAX_CONNECTIONS_PER_TORRENT;
        int perTorrentAllowed = -1;
        if (PER_TORRENT_LIMIT != 0) {
            int allowed2 = PER_TORRENT_LIMIT - curConnPerTorrent;
            if (allowed2 < 0) {
                allowed2 = 0;
            }
            perTorrentAllowed = allowed2;
        }
        int totalAllowed = -1;
        if (MAX_CONNECTIONS_TOTAL != 0) {
            allowed = MAX_CONNECTIONS_TOTAL - curConnTotal;
            if (allowed < 0) {
                allowed = 0;
            }
            totalAllowed = allowed;
        }
        allowed = -1;
        if (perTorrentAllowed > -1 && totalAllowed > -1) {
            allowed = Math.min(perTorrentAllowed, totalAllowed);
        } else if (perTorrentAllowed == -1 || totalAllowed == -1) {
            allowed = Math.max(perTorrentAllowed, totalAllowed);
        }
        return allowed;
    }

    private static void readIgnorePeerPorts() {
        block3: {
            int p1;
            String str = COConfigurationManager.getStringParameter("Ignore.peer.ports").trim();
            ignore_peer_ports.clear();
            if (str.length() <= 0) break block3;
            int pos = 0;
            do {
                String bit;
                if ((p1 = str.indexOf(59, pos)) == -1) {
                    bit = str.substring(pos);
                } else {
                    bit = str.substring(pos, p1);
                    pos = p1 + 1;
                }
                bit = bit.trim();
                ignore_peer_ports.add(bit);
            } while (p1 != -1);
        }
    }

    public static boolean ignorePeerPort(int port) {
        return ignore_peer_ports.contains("" + port);
    }

    static {
        COConfigurationManager.addParameterListener(CONFIG_MAX_CONN_PER_TORRENT, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MAX_CONNECTIONS_PER_TORRENT = COConfigurationManager.getIntParameter(PeerUtils.CONFIG_MAX_CONN_PER_TORRENT);
            }
        });
        MAX_CONNECTIONS_PER_TORRENT = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_PER_TORRENT);
        COConfigurationManager.addParameterListener(CONFIG_MAX_CONN_TOTAL, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MAX_CONNECTIONS_TOTAL = COConfigurationManager.getIntParameter(PeerUtils.CONFIG_MAX_CONN_TOTAL);
            }
        });
        MAX_CONNECTIONS_TOTAL = COConfigurationManager.getIntParameter(CONFIG_MAX_CONN_TOTAL);
        ignore_peer_ports = new HashSet();
        COConfigurationManager.addParameterListener("Ignore.peer.ports", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                PeerUtils.readIgnorePeerPorts();
            }
        });
        PeerUtils.readIgnorePeerPorts();
    }
}

