/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.global.impl;

import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.helpers.TorrentFolderWatcher;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadWillBeRemovedListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.global.impl.GlobalManagerHostSupport;
import org.gudy.azureus2.core3.global.impl.GlobalManagerStatsImpl;
import org.gudy.azureus2.core3.global.impl.GlobalManagerStatsWriter;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcherWithException;
import org.gudy.azureus2.core3.util.NonDaemonTask;
import org.gudy.azureus2.core3.util.NonDaemonTaskRunner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class GlobalManagerImpl
implements GlobalManager,
DownloadManagerListener,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final int LDT_MANAGER_ADDED = 1;
    private static final int LDT_MANAGER_REMOVED = 2;
    private static final int LDT_DESTROY_INITIATED = 3;
    private static final int LDT_DESTROYED = 4;
    private static final int LDT_SEEDING_ONLY = 5;
    private ListenerManager listeners = ListenerManager.createAsyncManager("GM:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            GlobalManagerListener target = (GlobalManagerListener)_listener;
            if (type == 1) {
                target.downloadManagerAdded((DownloadManager)value);
            } else if (type == 2) {
                target.downloadManagerRemoved((DownloadManager)value);
            } else if (type == 3) {
                target.destroyInitiated();
            } else if (type == 4) {
                target.destroyed();
            } else if (type == 5) {
                target.seedingStatusChanged((Boolean)value);
            }
        }
    });
    private static final int LDT_MANAGER_WBR = 1;
    private ListenerManager removal_listeners = ListenerManager.createManager("GM:DLWBRMListenDispatcher", new ListenerManagerDispatcherWithException(){

        public void dispatchWithException(Object _listener, int type, Object value) throws GlobalManagerDownloadRemovalVetoException {
            GlobalManagerDownloadWillBeRemovedListener target = (GlobalManagerDownloadWillBeRemovedListener)_listener;
            target.downloadWillBeRemoved((DownloadManager)value);
        }
    });
    private List managers_cow = new ArrayList();
    private AEMonitor managers_mon = new AEMonitor("GM:Managers");
    private Map manager_map = new HashMap();
    private Checker checker;
    private GlobalManagerStatsImpl stats;
    private long last_swarm_stats_calc_time = 0L;
    private long last_swarm_stats = 0L;
    private TRTrackerScraper trackerScraper;
    private GlobalManagerStatsWriter stats_writer;
    private GlobalManagerHostSupport host_support;
    private Map saved_download_manager_state = new HashMap();
    private TorrentFolderWatcher torrent_folder_watcher;
    private ArrayList paused_list = new ArrayList();
    private final AEMonitor paused_list_mon = new AEMonitor("GlobalManager:PL");
    private volatile boolean isStopping;
    private volatile boolean destroyed;
    private volatile boolean needsSaving = false;
    private boolean seeding_only_mode = false;
    private int nat_status = 0;
    private boolean nat_status_probably_ok;
    private Set old_network_interfaces;
    private long last_network_change;

    public GlobalManagerImpl(AzureusCoreListener listener) {
        AEDiagnostics.addEvidenceGenerator(this);
        this.stats = new GlobalManagerStatsImpl(this);
        try {
            this.stats_writer = new GlobalManagerStatsWriter(this);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Stats unavailable", e));
        }
        if (listener != null) {
            listener.reportCurrentTask(MessageText.getString("splash.initializeGM") + ": " + MessageText.getString("splash.loadingTorrents"));
        }
        this.loadDownloads(listener);
        if (listener != null) {
            listener.reportCurrentTask(MessageText.getString("splash.initializeGM"));
        }
        this.trackerScraper = TRTrackerScraperFactory.getSingleton();
        this.trackerScraper.setClientResolver(new TRTrackerScraperClientResolver(){

            public int getStatus(byte[] torrent_hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(torrent_hash);
                if (dm == null) {
                    return 1;
                }
                int dm_state = dm.getState();
                if (dm_state == 75) {
                    return 3;
                }
                if (dm_state == 50 || dm_state == 60) {
                    return 2;
                }
                return 4;
            }

            public boolean isNetworkEnabled(byte[] hash, URL url) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    return false;
                }
                String nw = AENetworkClassifier.categoriseAddress(url.getHost());
                String[] networks = dm.getDownloadState().getNetworks();
                for (int i = 0; i < networks.length; ++i) {
                    if (networks[i] != nw) continue;
                    return true;
                }
                return false;
            }

            public String getExtensions(byte[] hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    return "";
                }
                return dm.getDownloadState().getTrackerClientExtensions();
            }
        });
        this.trackerScraper.addListener(new TRTrackerScraperListener(){

            public void scrapeReceived(TRTrackerScraperResponse response) {
                DownloadManager manager;
                byte[] hash = response.getHash();
                if (response.isValid() && (manager = (DownloadManager)GlobalManagerImpl.this.manager_map.get(new HashWrapper(hash))) != null) {
                    manager.setTrackerScrapeResponse(response);
                }
            }
        });
        try {
            this.host_support = new GlobalManagerHostSupport(this);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Hosting unavailable", e));
        }
        this.checker = new Checker();
        this.checker.start();
        if (this.stats_writer != null) {
            this.stats_writer.initialisationComplete();
        }
        this.torrent_folder_watcher = new TorrentFolderWatcher(this);
    }

    public DownloadManager addDownloadManager(String fileName, String savePath) {
        return this.addDownloadManager(fileName, savePath, 0, true);
    }

    public DownloadManager addDownloadManager(String fileName, String savePath, int initialState, boolean persistent) {
        return this.addDownloadManager(fileName, savePath, initialState, persistent, false);
    }

    public DownloadManager addDownloadManager(String torrent_file_name, String savePath, int initialState, boolean persistent, boolean for_seeding) {
        Map save_download_state;
        byte[] torrent_hash = null;
        if (!persistent && (save_download_state = (Map)this.saved_download_manager_state.get(torrent_file_name)) != null) {
            int saved_state;
            torrent_hash = (byte[])save_download_state.get("torrent_hash");
            if (save_download_state.containsKey("state") && (saved_state = ((Long)save_download_state.get("state")).intValue()) == 70) {
                initialState = saved_state;
            }
        }
        Object torrentDir = null;
        File fDest = null;
        try {
            File f = new File(torrent_file_name);
            if (!f.exists()) {
                throw new IOException("Torrent file '" + torrent_file_name + "' doesn't exist");
            }
            if (!f.isFile()) {
                throw new IOException("Torrent '" + torrent_file_name + "' is not a file");
            }
            fDest = TorrentUtils.copyTorrentFileToSaveDir(f, persistent);
            String fName = fDest.getCanonicalPath();
            DownloadManager new_manager = DownloadManagerFactory.create(this, torrent_hash, fName, savePath, initialState, persistent, for_seeding);
            DownloadManager manager = this.addDownloadManager(new_manager, true);
            if (manager == null || manager != new_manager) {
                fDest.delete();
                File backupFile = new File(fName + ".bak");
                if (backupFile.exists()) {
                    backupFile.delete();
                }
            }
            return manager;
        }
        catch (IOException e) {
            System.out.println("DownloadManager::addDownloadManager: fails - td = " + torrentDir + ", fd = " + fDest);
            Debug.printStackTrace(e);
            DownloadManager manager = DownloadManagerFactory.create(this, torrent_hash, torrent_file_name, savePath, initialState, persistent, for_seeding);
            return this.addDownloadManager(manager, true);
        }
        catch (Exception e) {
            DownloadManager manager = DownloadManagerFactory.create(this, torrent_hash, torrent_file_name, savePath, initialState, persistent, for_seeding);
            return this.addDownloadManager(manager, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadManager addDownloadManager(DownloadManager download_manager, boolean save) {
        if (!this.isStopping) {
            try {
                boolean isCompleted;
                this.managers_mon.enter();
                int existing_index = this.managers_cow.indexOf(download_manager);
                if (existing_index != -1) {
                    DownloadManager existing;
                    DownloadManager downloadManager = existing = (DownloadManager)this.managers_cow.get(existing_index);
                    return downloadManager;
                }
                DownloadManagerStats dm_stats = download_manager.getStats();
                String torrent_file_name = download_manager.getTorrentFileName();
                Map save_download_state = (Map)this.saved_download_manager_state.get(torrent_file_name);
                long saved_data_bytes_downloaded = 0L;
                long saved_data_bytes_uploaded = 0L;
                long saved_discarded = 0L;
                long saved_hashfails = 0L;
                long saved_SecondsDownloading = 0L;
                long saved_SecondsOnlySeeding = 0L;
                if (save_download_state != null) {
                    long ct;
                    Long creation_time;
                    Long already_allocated;
                    Long lSecondsOnlySeeding;
                    Long lSecondsDLing;
                    Category cat;
                    TOTorrent torrent;
                    this.saved_download_manager_state.remove(torrent_file_name);
                    int nbUploads = ((Long)save_download_state.get("uploads")).intValue();
                    int maxDL = save_download_state.get("maxdl") == null ? 0 : ((Long)save_download_state.get("maxdl")).intValue();
                    int maxUL = save_download_state.get("maxul") == null ? 0 : ((Long)save_download_state.get("maxul")).intValue();
                    Long lDownloaded = (Long)save_download_state.get("downloaded");
                    Long lUploaded = (Long)save_download_state.get("uploaded");
                    Long lCompleted = (Long)save_download_state.get("completed");
                    Long lDiscarded = (Long)save_download_state.get("discarded");
                    Long lHashFailsCount = (Long)save_download_state.get("hashfails");
                    Long lHashFailsBytes = (Long)save_download_state.get("hashfailbytes");
                    dm_stats.setMaxUploads(nbUploads);
                    dm_stats.setDownloadRateLimitBytesPerSecond(maxDL);
                    dm_stats.setUploadRateLimitBytesPerSecond(maxUL);
                    if (lCompleted != null) {
                        dm_stats.setDownloadCompleted(lCompleted.intValue());
                    }
                    if (lDiscarded != null) {
                        saved_discarded = lDiscarded;
                    }
                    if (lHashFailsBytes != null) {
                        saved_hashfails = lHashFailsBytes;
                    } else if (lHashFailsCount != null && (torrent = download_manager.getTorrent()) != null) {
                        saved_hashfails = lHashFailsCount * torrent.getPieceLength();
                    }
                    Long lPosition = (Long)save_download_state.get("position");
                    String sCategory = null;
                    if (save_download_state.containsKey("category")) {
                        try {
                            sCategory = new String((byte[])save_download_state.get("category"), "UTF8");
                        }
                        catch (UnsupportedEncodingException e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (sCategory != null && (cat = CategoryManager.getCategory(sCategory)) != null) {
                        download_manager.getDownloadState().setCategory(cat);
                    }
                    boolean bCompleted = dm_stats.getDownloadCompleted(false) == 1000;
                    download_manager.setOnlySeeding(bCompleted);
                    if (lDownloaded != null && lUploaded != null) {
                        long lUploadedValue = lUploaded;
                        long lDownloadedValue = lDownloaded;
                        if (bCompleted && lDownloadedValue == 0L) {
                            int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                            lDownloadedValue = download_manager.getSize() * (long)dl_copies;
                            download_manager.getDownloadState().setFlag(1L, true);
                        }
                        saved_data_bytes_downloaded = lDownloadedValue;
                        saved_data_bytes_uploaded = lUploadedValue;
                    }
                    if (lPosition != null) {
                        download_manager.setPosition(lPosition.intValue());
                    }
                    if ((lSecondsDLing = (Long)save_download_state.get("secondsDownloading")) != null) {
                        saved_SecondsDownloading = lSecondsDLing;
                    }
                    if ((lSecondsOnlySeeding = (Long)save_download_state.get("secondsOnlySeeding")) != null) {
                        saved_SecondsOnlySeeding = lSecondsOnlySeeding;
                    }
                    if ((already_allocated = (Long)save_download_state.get("allocated")) != null && already_allocated.intValue() == 1) {
                        download_manager.setDataAlreadyAllocated(true);
                    }
                    if ((creation_time = (Long)save_download_state.get("creationTime")) != null && (ct = creation_time.longValue()) < SystemTime.getCurrentTime()) {
                        download_manager.setCreationTime(ct);
                    }
                    try {
                        List file_priorities = (List)save_download_state.get("file_priorities");
                        if (file_priorities != null) {
                            download_manager.setData("file_priorities", file_priorities);
                        }
                    }
                    catch (Throwable t) {
                        Debug.printStackTrace(t);
                    }
                } else if (dm_stats.getDownloadCompleted(false) == 1000) {
                    int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                    saved_data_bytes_downloaded = download_manager.getSize() * (long)dl_copies;
                }
                dm_stats.restoreSessionTotals(saved_data_bytes_downloaded, saved_data_bytes_uploaded, saved_discarded, saved_hashfails, saved_SecondsDownloading, saved_SecondsOnlySeeding);
                boolean bl = isCompleted = download_manager.getStats().getDownloadCompleted(false) == 1000;
                if (download_manager.getPosition() == -1) {
                    int endPosition = 0;
                    for (int i = 0; i < this.managers_cow.size(); ++i) {
                        boolean dmIsCompleted;
                        DownloadManager dm = (DownloadManager)this.managers_cow.get(i);
                        boolean bl2 = dmIsCompleted = dm.getStats().getDownloadCompleted(false) == 1000;
                        if (dmIsCompleted != isCompleted) continue;
                        ++endPosition;
                    }
                    download_manager.setPosition(endPosition + 1);
                }
                download_manager.setOnlySeeding(isCompleted);
                ArrayList<DownloadManager> new_download_managers = new ArrayList<DownloadManager>(this.managers_cow);
                new_download_managers.add(download_manager);
                this.managers_cow = new_download_managers;
                TOTorrent torrent = download_manager.getTorrent();
                if (torrent != null) {
                    try {
                        this.manager_map.put(new HashWrapper(torrent.getHash()), download_manager);
                    }
                    catch (TOTorrentException e) {
                        Debug.printStackTrace(e);
                    }
                }
                this.listeners.dispatch(1, download_manager);
                download_manager.addListener(this);
                if (save_download_state != null) {
                    Long lStartStopLocked;
                    Long lForceStart = (Long)save_download_state.get("forceStart");
                    if (lForceStart == null && (lStartStopLocked = (Long)save_download_state.get("startStopLocked")) != null) {
                        lForceStart = lStartStopLocked;
                    }
                    if (lForceStart != null && lForceStart.intValue() == 1) {
                        download_manager.setForceStart(true);
                    }
                }
            }
            finally {
                this.managers_mon.exit();
            }
            if (save) {
                this.saveDownloads(false);
            }
            return download_manager;
        }
        Logger.log(new LogEvent(LOGID, 3, "Tried to add a DownloadManager after shutdown of GlobalManager."));
        return null;
    }

    public List getDownloadManagers() {
        return this.managers_cow;
    }

    public DownloadManager getDownloadManager(TOTorrent torrent) {
        try {
            return this.getDownloadManager(torrent.getHash());
        }
        catch (TOTorrentException e) {
            return null;
        }
    }

    public DownloadManager getDownloadManager(byte[] hash) {
        return (DownloadManager)this.manager_map.get(new HashWrapper(hash));
    }

    public void canDownloadManagerBeRemoved(DownloadManager manager) throws GlobalManagerDownloadRemovalVetoException {
        try {
            this.removal_listeners.dispatchWithException(1, manager);
        }
        catch (Throwable e) {
            throw (GlobalManagerDownloadRemovalVetoException)e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadManager(DownloadManager manager) throws GlobalManagerDownloadRemovalVetoException {
        if (!this.managers_cow.contains(manager)) {
            return;
        }
        this.canDownloadManagerBeRemoved(manager);
        try {
            this.managers_mon.enter();
            ArrayList new_download_managers = new ArrayList(this.managers_cow);
            new_download_managers.remove(manager);
            this.managers_cow = new_download_managers;
            TOTorrent torrent = manager.getTorrent();
            if (torrent != null) {
                try {
                    this.manager_map.remove(new HashWrapper(torrent.getHash()));
                }
                catch (TOTorrentException e) {
                    Debug.printStackTrace(e);
                }
            }
            manager.destroy();
        }
        finally {
            this.managers_mon.exit();
        }
        this.fixUpDownloadManagerPositions();
        this.listeners.dispatch(2, manager);
        manager.removeListener(this);
        this.saveDownloads(false);
        DownloadManagerState dms = manager.getDownloadState();
        if (dms.getCategory() != null) {
            dms.setCategory(null);
        }
        if (manager.getTorrent() != null) {
            this.trackerScraper.remove(manager.getTorrent());
        }
        if (this.host_support != null) {
            this.host_support.torrentRemoved(manager.getTorrentFileName(), manager.getTorrent());
        }
        dms.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopGlobalManager() {
        try {
            this.managers_mon.enter();
            if (this.isStopping) {
                return;
            }
            this.isStopping = true;
        }
        finally {
            this.managers_mon.exit();
        }
        this.informDestroyInitiated();
        if (this.host_support != null) {
            this.host_support.destroy();
        }
        this.torrent_folder_watcher.destroy();
        try {
            NonDaemonTaskRunner.run(new NonDaemonTask(){

                public Object run() {
                    return null;
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.checker.stopIt();
        this.saveDownloads(true);
        this.stopAllDownloads();
        if (this.stats_writer != null) {
            this.stats_writer.destroy();
        }
        this.managers_cow = new ArrayList();
        this.manager_map.clear();
        this.informDestroyed();
    }

    public void stopAllDownloads() {
        this.stopAllDownloads(70);
    }

    public void stopAllDownloads(int stateAfterStopping) {
        Iterator iter = this.managers_cow.iterator();
        while (iter.hasNext()) {
            DownloadManager manager = (DownloadManager)iter.next();
            int state = manager.getState();
            if (state == 70 || state == 65) continue;
            manager.stopIt(stateAfterStopping, false, false);
        }
    }

    public void startAllDownloads() {
        Iterator iter = this.managers_cow.iterator();
        while (iter.hasNext()) {
            DownloadManager manager = (DownloadManager)iter.next();
            if (manager.getState() != 70) continue;
            manager.startDownloadInitialized(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseDownload(DownloadManager manager) {
        if (manager.getTorrent() == null) {
            return false;
        }
        int state = manager.getState();
        if (state != 70 && state != 100 && state != 65) {
            try {
                HashWrapper wrapper = manager.getTorrent().getHashWrapper();
                boolean forced = manager.isForceStart();
                manager.stopIt(70, false, false);
                try {
                    this.paused_list_mon.enter();
                    this.paused_list.add(new Object[]{wrapper, new Boolean(forced)});
                }
                finally {
                    this.paused_list_mon.exit();
                }
                return true;
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseDownloads() {
        Iterator i = this.managers_cow.iterator();
        while (i.hasNext()) {
            int state;
            DownloadManager manager = (DownloadManager)i.next();
            if (manager.getTorrent() == null || (state = manager.getState()) == 70 || state == 100 || state == 65) continue;
            try {
                boolean forced = manager.isForceStart();
                manager.stopIt(70, false, false);
                try {
                    this.paused_list_mon.enter();
                    this.paused_list.add(new Object[]{manager.getTorrent().getHashWrapper(), new Boolean(forced)});
                }
                finally {
                    this.paused_list_mon.exit();
                }
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public boolean canPauseDownload(DownloadManager manager) {
        if (manager.getTorrent() == null) {
            return false;
        }
        int state = manager.getState();
        return state != 70 && state != 100 && state != 65;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused(DownloadManager manager) {
        if (this.paused_list.size() == 0) {
            return false;
        }
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] data = (Object[])this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                DownloadManager this_manager = this.getDownloadManager(hash.getHash());
                if (this_manager != manager) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.paused_list_mon.exit();
        }
    }

    public boolean canPauseDownloads() {
        Iterator i = this.managers_cow.iterator();
        while (i.hasNext()) {
            DownloadManager manager = (DownloadManager)i.next();
            if (!this.canPauseDownload(manager)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeDownload(DownloadManager manager) {
        boolean resume_ok = false;
        boolean force = false;
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] data = (Object[])this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                force = (Boolean)data[1];
                DownloadManager this_manager = this.getDownloadManager(hash.getHash());
                if (this_manager != manager) continue;
                resume_ok = true;
                this.paused_list.remove(i);
                break;
            }
        }
        finally {
            this.paused_list_mon.exit();
        }
        if (resume_ok && manager.getState() == 70) {
            if (force) {
                manager.setForceStart(true);
            } else {
                manager.startDownloadInitialized(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeDownloads() {
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] data = (Object[])this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                boolean force = (Boolean)data[1];
                DownloadManager manager = this.getDownloadManager(hash.getHash());
                if (manager == null || manager.getState() != 70) continue;
                if (force) {
                    manager.setForceStart(true);
                    continue;
                }
                manager.startDownloadInitialized(true);
            }
            this.paused_list.clear();
        }
        finally {
            this.paused_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canResumeDownloads() {
        try {
            this.paused_list_mon.enter();
            for (int i = 0; i < this.paused_list.size(); ++i) {
                Object[] data = (Object[])this.paused_list.get(i);
                HashWrapper hash = (HashWrapper)data[0];
                DownloadManager manager = this.getDownloadManager(hash.getHash());
                if (manager == null || manager.getState() != 70) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.paused_list_mon.exit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDownloads(AzureusCoreListener listener) {
        try {
            int nbDownloads;
            Map map = FileUtil.readResilientConfigFile("downloads.config");
            boolean debug = Boolean.getBoolean("debug");
            Iterator<Object> iter = null;
            List downloads = (List)map.get("downloads");
            if (downloads == null) {
                iter = map.values().iterator();
                nbDownloads = map.size();
            } else {
                iter = downloads.iterator();
                nbDownloads = downloads.size();
            }
            int currentDownload = 0;
            while (iter.hasNext()) {
                ++currentDownload;
                Map mDownload = (Map)iter.next();
                try {
                    String torrent_save_file;
                    String torrent_save_dir;
                    byte[] torrent_save_dir_bytes;
                    byte[] torrent_hash = (byte[])mDownload.get("torrent_hash");
                    Long lPersistent = (Long)mDownload.get("persistent");
                    boolean persistent = lPersistent == null || lPersistent == 1L;
                    String fileName = new String((byte[])mDownload.get("torrent"), "UTF8");
                    if (listener != null && nbDownloads > 0) {
                        listener.reportPercent(100 * currentDownload / nbDownloads);
                    }
                    if (listener != null) {
                        listener.reportCurrentTask(MessageText.getString("splash.loadingTorrent") + " " + currentDownload + " " + MessageText.getString("splash.of") + " " + nbDownloads + " : " + fileName);
                    }
                    if ((torrent_save_dir_bytes = (byte[])mDownload.get("save_dir")) != null) {
                        byte[] torrent_save_file_bytes = (byte[])mDownload.get("save_file");
                        torrent_save_dir = new String(torrent_save_dir_bytes, "UTF8");
                        torrent_save_file = torrent_save_file_bytes != null ? new String(torrent_save_file_bytes, "UTF8") : null;
                    } else {
                        byte[] savePathBytes = (byte[])mDownload.get("path");
                        torrent_save_dir = new String(savePathBytes, "UTF8");
                        torrent_save_file = null;
                    }
                    int state = 0;
                    if (debug) {
                        state = 70;
                    } else if (mDownload.containsKey("state")) {
                        state = ((Long)mDownload.get("state")).intValue();
                        if (state != 70 && state != 75 && state != 0) {
                            state = 75;
                        }
                    } else {
                        int stopped = ((Long)mDownload.get("stopped")).intValue();
                        if (stopped == 1) {
                            state = 70;
                        }
                    }
                    Long seconds_downloading = (Long)mDownload.get("secondsDownloading");
                    boolean has_ever_been_started = seconds_downloading != null && seconds_downloading > 0L;
                    this.saved_download_manager_state.put(fileName, mDownload);
                    if (!persistent) continue;
                    DownloadManager dm = DownloadManagerFactory.create(this, torrent_hash, fileName, torrent_save_dir, torrent_save_file, state, true, true, has_ever_been_started);
                    this.addDownloadManager(dm, false);
                }
                catch (UnsupportedEncodingException e1) {
                }
                catch (Throwable e) {
                    Logger.log(new LogEvent(LOGID, "Error while loading downloads.  One download may not have been added to the list.", e));
                }
            }
            ArrayList pause_data = (ArrayList)map.get("pause_data");
            if (pause_data != null) {
                try {
                    this.paused_list_mon.enter();
                    for (int i = 0; i < pause_data.size(); ++i) {
                        boolean force;
                        byte[] key;
                        Object pd = pause_data.get(i);
                        if (pd instanceof byte[]) {
                            key = (byte[])pause_data.get(i);
                            force = false;
                        } else {
                            Map m = (Map)pd;
                            key = (byte[])m.get("hash");
                            force = ((Long)m.get("force")).intValue() == 1;
                        }
                        this.paused_list.add(new Object[]{new HashWrapper(key), new Boolean(force)});
                    }
                }
                finally {
                    this.paused_list_mon.exit();
                }
            }
            this.fixUpDownloadManagerPositions();
            Logger.log(new LogEvent(LOGID, "Loaded " + this.managers_cow.size() + " torrents"));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDownloads(boolean immediate) {
        if (!immediate) {
            this.needsSaving = true;
            return;
        }
        this.needsSaving = false;
        try {
            this.managers_mon.enter();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Saving Download List (" + this.managers_cow.size() + " items)"));
            }
            HashMap map = new HashMap();
            ArrayList list = new ArrayList(this.managers_cow.size());
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                DownloadManager dm = (DownloadManager)this.managers_cow.get(i);
                DownloadManagerStats dm_stats = dm.getStats();
                HashMap<String, Object> dmMap = new HashMap<String, Object>();
                TOTorrent torrent = dm.getTorrent();
                if (torrent != null) {
                    try {
                        dmMap.put("torrent_hash", torrent.getHash());
                    }
                    catch (TOTorrentException e) {
                        Debug.printStackTrace(e);
                    }
                }
                File save_loc = dm.getAbsoluteSaveLocation();
                dmMap.put("persistent", new Long(dm.isPersistent() ? 1L : 0L));
                dmMap.put("torrent", dm.getTorrentFileName());
                dmMap.put("save_dir", save_loc.getParent());
                dmMap.put("save_file", save_loc.getName());
                dmMap.put("uploads", new Long(dm_stats.getMaxUploads()));
                dmMap.put("maxdl", new Long(dm_stats.getDownloadRateLimitBytesPerSecond()));
                dmMap.put("maxul", new Long(dm_stats.getUploadRateLimitBytesPerSecond()));
                int state = dm.getState();
                if (state == 100) {
                    state = 70;
                } else if (dm.getOnlySeeding() && !dm.isForceStart() && state != 70) {
                    state = 75;
                } else if (state != 70 && state != 75 && state != 0) {
                    state = 0;
                }
                dmMap.put("state", new Long(state));
                dmMap.put("position", new Long(dm.getPosition()));
                dmMap.put("downloaded", new Long(dm_stats.getTotalDataBytesReceived()));
                dmMap.put("uploaded", new Long(dm_stats.getTotalDataBytesSent()));
                dmMap.put("completed", new Long(dm_stats.getDownloadCompleted(true)));
                dmMap.put("discarded", new Long(dm_stats.getDiscarded()));
                dmMap.put("hashfailbytes", new Long(dm_stats.getHashFailBytes()));
                dmMap.put("forceStart", new Long(dm.isForceStart() && dm.getState() != 30 ? 1L : 0L));
                dmMap.put("secondsDownloading", new Long(dm_stats.getSecondsDownloading()));
                dmMap.put("secondsOnlySeeding", new Long(dm_stats.getSecondsOnlySeeding()));
                dmMap.put("creationTime", new Long(dm.getCreationTime()));
                dm.saveDownload();
                List file_priorities = (List)dm.getData("file_priorities");
                if (file_priorities != null) {
                    dmMap.put("file_priorities", file_priorities);
                }
                dmMap.put("allocated", new Long(dm.isDataAlreadyAllocated() ? 1L : 0L));
                list.add(dmMap);
            }
            map.put("downloads", list);
            try {
                this.paused_list_mon.enter();
                if (!this.paused_list.isEmpty()) {
                    ArrayList pause_data = new ArrayList();
                    for (int i = 0; i < this.paused_list.size(); ++i) {
                        Object[] data = (Object[])this.paused_list.get(i);
                        HashWrapper hash = (HashWrapper)data[0];
                        Boolean force = (Boolean)data[1];
                        HashMap<String, Object> m = new HashMap<String, Object>();
                        m.put("hash", hash.getHash());
                        m.put("force", new Long(force != false ? 1L : 0L));
                        pause_data.add(m);
                    }
                    map.put("pause_data", pause_data);
                }
            }
            finally {
                this.paused_list_mon.exit();
            }
            FileUtil.writeResilientConfigFile("downloads.config", map);
        }
        finally {
            this.managers_mon.exit();
        }
    }

    public TRTrackerScraper getTrackerScraper() {
        return this.trackerScraper;
    }

    public GlobalManagerStats getStats() {
        return this.stats;
    }

    public int getIndexOf(DownloadManager manager) {
        if (this.managers_cow != null && manager != null) {
            return this.managers_cow.indexOf(manager);
        }
        return -1;
    }

    public boolean isMoveableUp(DownloadManager manager) {
        if (manager.getStats().getDownloadCompleted(false) == 1000 && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        return manager.getPosition() > 1;
    }

    public int downloadManagerCount(boolean bCompleted) {
        int numInGroup = 0;
        Iterator it = this.managers_cow.iterator();
        while (it.hasNext()) {
            DownloadManager dm = (DownloadManager)it.next();
            if (dm.getStats().getDownloadCompleted(false) == 1000 != bCompleted) continue;
            ++numInGroup;
        }
        return numInGroup;
    }

    public boolean isMoveableDown(DownloadManager manager) {
        boolean isCompleted;
        boolean bl = isCompleted = manager.getStats().getDownloadCompleted(false) == 1000;
        if (isCompleted && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        return manager.getPosition() < this.downloadManagerCount(isCompleted);
    }

    public void moveUp(DownloadManager manager) {
        this.moveTo(manager, manager.getPosition() - 1);
    }

    public void moveDown(DownloadManager manager) {
        this.moveTo(manager, manager.getPosition() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTop(DownloadManager[] manager) {
        try {
            this.managers_mon.enter();
            int newPosition = 1;
            for (int i = 0; i < manager.length; ++i) {
                this.moveTo(manager[i], newPosition++);
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveEnd(DownloadManager[] manager) {
        try {
            this.managers_mon.enter();
            int endPosComplete = 0;
            int endPosIncomplete = 0;
            for (int j = 0; j < this.managers_cow.size(); ++j) {
                DownloadManager dm = (DownloadManager)this.managers_cow.get(j);
                if (dm.getStats().getDownloadCompleted(false) == 1000) {
                    ++endPosComplete;
                    continue;
                }
                ++endPosIncomplete;
            }
            for (int i = manager.length - 1; i >= 0; --i) {
                if (manager[i].getStats().getDownloadCompleted(false) == 1000 && endPosComplete > 0) {
                    this.moveTo(manager[i], endPosComplete--);
                    continue;
                }
                if (endPosIncomplete <= 0) continue;
                this.moveTo(manager[i], endPosIncomplete--);
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTo(DownloadManager manager, int newPosition) {
        boolean curCompleted;
        boolean bl = curCompleted = manager.getStats().getDownloadCompleted(false) == 1000;
        if (newPosition < 1 || newPosition > this.downloadManagerCount(curCompleted)) {
            return;
        }
        try {
            this.managers_mon.enter();
            int curPosition = manager.getPosition();
            if (newPosition > curPosition) {
                int numToMove = newPosition - curPosition;
                for (int i = 0; i < this.managers_cow.size(); ++i) {
                    int dmPosition;
                    boolean dmCompleted;
                    DownloadManager dm = (DownloadManager)this.managers_cow.get(i);
                    boolean bl2 = dmCompleted = dm.getStats().getDownloadCompleted(false) == 1000;
                    if (dmCompleted != curCompleted || (dmPosition = dm.getPosition()) <= curPosition || dmPosition > newPosition) continue;
                    dm.setPosition(dmPosition - 1);
                    if (--numToMove <= 0) break;
                }
                manager.setPosition(newPosition);
            } else if (newPosition < curPosition && curPosition > 1) {
                int numToMove = curPosition - newPosition;
                for (int i = 0; i < this.managers_cow.size(); ++i) {
                    DownloadManager dm = (DownloadManager)this.managers_cow.get(i);
                    boolean dmCompleted = dm.getStats().getDownloadCompleted(false) == 1000;
                    int dmPosition = dm.getPosition();
                    if (dmCompleted != curCompleted || dmPosition < newPosition || dmPosition >= curPosition) continue;
                    dm.setPosition(dmPosition + 1);
                    if (--numToMove <= 0) break;
                }
                manager.setPosition(newPosition);
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixUpDownloadManagerPositions() {
        try {
            this.managers_mon.enter();
            int posComplete = 1;
            int posIncomplete = 1;
            Collections.sort(this.managers_cow, new Comparator(){

                public final int compare(Object a, Object b) {
                    return ((DownloadManager)a).getPosition() - ((DownloadManager)b).getPosition();
                }
            });
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                DownloadManager dm = (DownloadManager)this.managers_cow.get(i);
                if (dm.getStats().getDownloadCompleted(false) == 1000) {
                    dm.setPosition(posComplete++);
                    continue;
                }
                dm.setPosition(posIncomplete++);
            }
        }
        finally {
            this.managers_mon.exit();
        }
    }

    protected void informDestroyed() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.listeners.dispatch(4, null, true);
    }

    public void informDestroyInitiated() {
        this.listeners.dispatch(3, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(GlobalManagerListener listener) {
        if (this.isStopping) {
            listener.destroyed();
        } else {
            this.listeners.addListener(listener);
            try {
                this.managers_mon.enter();
                for (int i = 0; i < this.managers_cow.size(); ++i) {
                    listener.downloadManagerAdded((DownloadManager)this.managers_cow.get(i));
                }
            }
            finally {
                this.managers_mon.exit();
            }
        }
    }

    public void removeListener(GlobalManagerListener listener) {
        this.listeners.removeListener(listener);
    }

    public void addDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener l) {
        this.removal_listeners.addListener(l);
    }

    public void removeDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener l) {
        this.removal_listeners.removeListener(l);
    }

    public void stateChanged(DownloadManager manager, int new_state) {
        this.needsSaving = true;
        PEPeerManager pm_manager = manager.getPeerManager();
        if (new_state == 50 && pm_manager != null && pm_manager.hasDownloadablePiece()) {
            this.setSeedingOnlyState(false);
        } else {
            this.checkSeedingOnlyState();
        }
    }

    protected void checkSeedingOnlyState() {
        boolean seeding = false;
        List managers = this.managers_cow;
        for (int i = 0; i < managers.size(); ++i) {
            DownloadManager dm = (DownloadManager)managers.get(i);
            PEPeerManager pm = dm.getPeerManager();
            if (dm.getDiskManager() == null || pm == null) continue;
            int state = dm.getState();
            if (state == 50) {
                if (!pm.hasDownloadablePiece()) {
                    seeding = true;
                    continue;
                }
                seeding = false;
                break;
            }
            if (state != 60) continue;
            seeding = true;
        }
        this.setSeedingOnlyState(seeding);
    }

    protected void setSeedingOnlyState(boolean seeding) {
        if (seeding != this.seeding_only_mode) {
            this.seeding_only_mode = seeding;
            this.listeners.dispatch(5, new Boolean(this.seeding_only_mode));
        }
    }

    public boolean isSeedingOnly() {
        return this.seeding_only_mode;
    }

    public void downloadComplete(DownloadManager manager) {
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public long getTotalSwarmsPeerRate(boolean downloading, boolean seeding) {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_swarm_stats_calc_time || now - this.last_swarm_stats_calc_time >= 1000L) {
            long total = 0L;
            List managers = this.managers_cow;
            for (int i = 0; i < managers.size(); ++i) {
                boolean is_seeding;
                DownloadManager manager = (DownloadManager)managers.get(i);
                boolean bl = is_seeding = manager.getState() == 60;
                if ((!downloading || is_seeding) && (!seeding || !is_seeding)) continue;
                total += manager.getStats().getTotalAveragePerPeer();
            }
            this.last_swarm_stats = total;
            this.last_swarm_stats_calc_time = now;
        }
        return this.last_swarm_stats;
    }

    protected void computeNATStatus() {
        int num_ok = 0;
        int num_probably_ok = 0;
        int num_bad = 0;
        Iterator it = this.managers_cow.iterator();
        while (it.hasNext()) {
            DownloadManager manager = (DownloadManager)it.next();
            int status = manager.getNATStatus();
            if (status == 1) {
                ++num_ok;
                continue;
            }
            if (status == 2) {
                ++num_probably_ok;
                continue;
            }
            if (status != 3) continue;
            ++num_bad;
        }
        if (num_ok > 0) {
            this.nat_status = 1;
        } else if (num_probably_ok > 0 || this.nat_status_probably_ok) {
            this.nat_status = 2;
            this.nat_status_probably_ok = true;
        } else {
            this.nat_status = num_bad > 0 ? 3 : 0;
        }
    }

    public int getNATStatus() {
        return this.nat_status;
    }

    protected void checkNetwork() {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            HashSet<NetworkInterface> network_interfaces = new HashSet<NetworkInterface>();
            boolean changed = false;
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                if (this.old_network_interfaces != null && !this.old_network_interfaces.contains(ni)) {
                    changed = true;
                }
                network_interfaces.add(ni);
            }
            if (changed) {
                long now = SystemTime.getCurrentTime();
                if (this.last_network_change > 0L) {
                    if (now - this.last_network_change > 1800000L) {
                        Logger.log(new LogEvent(LOGID, "Network interfaces have changed, updating trackers"));
                        List managers = this.managers_cow;
                        for (int i = 0; i < managers.size(); ++i) {
                            DownloadManager manager = (DownloadManager)managers.get(i);
                            TRTrackerAnnouncer anouncer = manager.getTrackerClient();
                            if (anouncer == null) continue;
                            anouncer.update(true);
                        }
                    } else {
                        Logger.log(new LogEvent(LOGID, "Network interfaces have changed, not updating trackers as too soon after previous change"));
                    }
                }
                this.last_network_change = now;
            }
            this.old_network_interfaces = network_interfaces;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("Global Manager");
        try {
            writer.indent();
            this.managers_mon.enter();
            writer.println("  managers: " + this.managers_cow.size());
            for (int i = 0; i < this.managers_cow.size(); ++i) {
                DownloadManager manager = (DownloadManager)this.managers_cow.get(i);
                TOTorrent torrent = manager.getTorrent();
                String hash = "<unknown>";
                try {
                    hash = ByteFormatter.encodeString(torrent.getHash());
                }
                catch (Throwable e) {
                    // empty catch block
                }
                writer.println("    " + manager.getDisplayName() + "/" + hash + " (" + manager + ")");
            }
        }
        finally {
            this.managers_mon.exit();
            writer.exdent();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"C:\\temp\\downloads.config", "C:\\temp\\downloads-9-3-05.config", "C:\\temp\\merged.config"};
        } else if (args.length != 3) {
            System.out.println("Usage: newer_config_file older_config_file save_config_file");
            return;
        }
        try {
            Map map1 = FileUtil.readResilientFile(new File(args[0]));
            Map map2 = FileUtil.readResilientFile(new File(args[1]));
            List downloads1 = (List)map1.get("downloads");
            List downloads2 = (List)map2.get("downloads");
            HashSet<HashWrapper> torrents = new HashSet<HashWrapper>();
            Iterator it1 = downloads1.iterator();
            while (it1.hasNext()) {
                Map m = (Map)it1.next();
                byte[] hash = (byte[])m.get("torrent_hash");
                System.out.println("1:" + ByteFormatter.nicePrint(hash));
                torrents.add(new HashWrapper(hash));
            }
            ArrayList<Map> to_add = new ArrayList<Map>();
            Iterator it2 = downloads2.iterator();
            while (it2.hasNext()) {
                Map m = (Map)it2.next();
                byte[] hash = (byte[])m.get("torrent_hash");
                HashWrapper wrapper = new HashWrapper(hash);
                if (torrents.contains(wrapper)) {
                    System.out.println("-:" + ByteFormatter.nicePrint(hash));
                    continue;
                }
                System.out.println("2:" + ByteFormatter.nicePrint(hash));
                to_add.add(m);
            }
            downloads1.addAll(to_add);
            System.out.println(to_add.size() + " copied from " + args[1] + " to " + args[2]);
            FileUtil.writeResilientFile(new File(args[2]), map1);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public class Checker
    extends AEThread {
        int loopFactor;
        private static final int waitTime = 10000;
        private int saveResumeLoopCount;
        private int netCheckLoopCount;
        private int natCheckLoopCount;
        private AESemaphore run_sem;

        public Checker() {
            super("Global Status Checker");
            this.saveResumeLoopCount = 30;
            this.netCheckLoopCount = 6;
            this.natCheckLoopCount = 3;
            this.run_sem = new AESemaphore("GM:Checker:run");
            this.loopFactor = 0;
            this.setPriority(1);
        }

        private void determineSaveResumeDataInterval() {
            int saveResumeInterval = COConfigurationManager.getIntParameter("Save Resume Interval", 5);
            if (saveResumeInterval >= 1 && saveResumeInterval <= 90) {
                this.saveResumeLoopCount = saveResumeInterval * 60000 / 10000;
            }
        }

        public void runSupport() {
            while (true) {
                try {
                    ++this.loopFactor;
                    this.determineSaveResumeDataInterval();
                    if (this.loopFactor % this.saveResumeLoopCount == 0 || GlobalManagerImpl.this.needsSaving) {
                        GlobalManagerImpl.this.saveDownloads(true);
                    }
                    if (this.loopFactor % this.netCheckLoopCount == 0) {
                        GlobalManagerImpl.this.checkNetwork();
                    }
                    if (this.loopFactor % this.natCheckLoopCount == 0) {
                        GlobalManagerImpl.this.computeNATStatus();
                        GlobalManagerImpl.this.checkSeedingOnlyState();
                    }
                    Iterator it = GlobalManagerImpl.this.managers_cow.iterator();
                    while (it.hasNext()) {
                        DownloadManager manager = (DownloadManager)it.next();
                        if (this.loopFactor % this.saveResumeLoopCount == 0) {
                            manager.saveResumeData();
                        }
                        if (manager.getState() != 40 || !manager.isForceStart()) continue;
                        manager.startDownload();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                try {
                    this.run_sem.reserve(10000L);
                    if (!this.run_sem.isReleasedForever()) continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    continue;
                }
                break;
            }
        }

        public void stopIt() {
            this.run_sem.releaseForever();
        }
    }
}

