/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.util.SystemTime;

public class DiskManagerReadRequestImpl
implements DiskManagerReadRequest {
    private static final int EXPIRATION_TIME = 60000;
    private int pieceNumber;
    private int offset;
    private int length;
    private long timeCreated;
    private final int hashcode;
    private boolean flush;
    private boolean cancelled;
    private boolean use_cache = true;

    public DiskManagerReadRequestImpl(int _pieceNumber, int _offset, int _length) {
        this.pieceNumber = _pieceNumber;
        this.offset = _offset;
        this.length = _length;
        this.timeCreated = SystemTime.getCurrentTime();
        this.hashcode = this.pieceNumber + this.offset + this.length;
    }

    public boolean isExpired() {
        long now = SystemTime.getCurrentTime();
        if (this.timeCreated > 0L && now > this.timeCreated) {
            return now - this.timeCreated > 60000L;
        }
        this.timeCreated = now;
        return false;
    }

    public void reSetTime() {
        this.timeCreated = SystemTime.getCurrentTime();
    }

    public void resetTime() {
        this.reSetTime();
    }

    public int getPieceNumber() {
        return this.pieceNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setFlush(boolean _flush) {
        this.flush = _flush;
    }

    public boolean getFlush() {
        return this.flush;
    }

    public void setUseCache(boolean cache) {
        this.use_cache = cache;
    }

    public boolean getUseCache() {
        return this.use_cache;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DiskManagerReadRequestImpl)) {
            return false;
        }
        DiskManagerReadRequestImpl otherRequest = (DiskManagerReadRequestImpl)o;
        if (otherRequest.pieceNumber != this.pieceNumber) {
            return false;
        }
        if (otherRequest.offset != this.offset) {
            return false;
        }
        return otherRequest.length == this.length;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }
}

