/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckInstance;
import org.gudy.azureus2.core3.util.AEMonitor;

public class DiskManagerRecheckScheduler {
    private static boolean friendly_hashing;
    private List instances = new ArrayList();
    private AEMonitor instance_mon = new AEMonitor("DiskManagerRecheckScheduler");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskManagerRecheckInstance register(DiskManagerHelper helper, boolean low_priority) {
        try {
            this.instance_mon.enter();
            DiskManagerRecheckInstance res = new DiskManagerRecheckInstance(this, helper.getTorrent().getSize(), (int)helper.getTorrent().getPieceLength(), low_priority);
            this.instances.add(res);
            Collections.sort(this.instances, new Comparator(){

                public int compare(Object o1, Object o2) {
                    long comp = ((DiskManagerRecheckInstance)o1).getMetric() - ((DiskManagerRecheckInstance)o2).getMetric();
                    if (comp < 0L) {
                        return -1;
                    }
                    if (comp == 0L) {
                        return 0;
                    }
                    return 1;
                }
            });
            DiskManagerRecheckInstance diskManagerRecheckInstance = res;
            return diskManagerRecheckInstance;
        }
        finally {
            this.instance_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getPermission(DiskManagerRecheckInstance instance) {
        boolean result = false;
        int delay = 250;
        try {
            this.instance_mon.enter();
            if (this.instances.get(0) == instance) {
                if (friendly_hashing) {
                    delay = 0;
                } else if (!instance.isLowPriority()) {
                    delay = 1;
                } else {
                    delay = instance.getPieceLength() / 1024 / 10;
                    delay = Math.min(delay, 409);
                    delay = Math.max(delay, 12);
                }
                result = true;
            }
        }
        finally {
            this.instance_mon.exit();
        }
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregister(DiskManagerRecheckInstance instance) {
        try {
            this.instance_mon.enter();
            this.instances.remove(instance);
        }
        finally {
            this.instance_mon.exit();
        }
    }

    static {
        ParameterListener param_listener = new ParameterListener(){

            public void parameterChanged(String str) {
                friendly_hashing = COConfigurationManager.getBooleanParameter("diskmanager.friendly.hashchecking");
            }
        };
        COConfigurationManager.addAndFireParameterListener("diskmanager.friendly.hashchecking", param_listener);
    }
}

