/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.SystemTime;

public class DiskManagerPieceImpl
implements DiskManagerPiece {
    private static final LogIDs LOGID = LogIDs.PIECES;
    private final DiskManagerImpl diskManager;
    private final int pieceNumber;
    private volatile int statusFlags;
    private volatile long time_last_write;
    protected boolean[] written;
    private static boolean statusTested = false;

    protected DiskManagerPieceImpl(DiskManagerImpl _disk_manager, int pieceIndex) {
        this.diskManager = _disk_manager;
        this.pieceNumber = pieceIndex;
        this.statusFlags = 1;
    }

    public DiskManager getManager() {
        return this.diskManager;
    }

    public int getPieceNumber() {
        return this.pieceNumber;
    }

    public int getLength() {
        if (this.pieceNumber != this.diskManager.getNbPieces() - 1) {
            return this.diskManager.getPieceLength();
        }
        return this.diskManager.getLastPieceLength();
    }

    public int getNbBlocks() {
        return (this.getLength() + 16384 - 1) / 16384;
    }

    public int getBlockSize(int blockNumber) {
        int length;
        if (blockNumber == this.getNbBlocks() - 1 && (length = this.getLength()) % 16384 != 0) {
            return length % 16384;
        }
        return 16384;
    }

    public boolean isNeeded() {
        return (this.statusFlags & 1) != 0;
    }

    public boolean calcNeeded() {
        boolean filesNeeded = false;
        DMPieceList pieceList = this.diskManager.getPieceList(this.pieceNumber);
        for (int i = 0; i < pieceList.size(); ++i) {
            DiskManagerFileInfoImpl file = pieceList.get(i).getFile();
            long fileLength = file.getLength();
            filesNeeded |= fileLength > 0L && file.getDownloaded() < fileLength && !file.isSkipped();
        }
        if (filesNeeded) {
            this.statusFlags |= 1;
            return true;
        }
        this.statusFlags &= 0xFFFFFFFE;
        return false;
    }

    public void clearNeeded() {
        this.statusFlags &= 0xFFFFFFFE;
    }

    public void setNeeded() {
        this.statusFlags |= 1;
    }

    public void setNeeded(boolean b) {
        if (b) {
            this.setNeeded();
        } else {
            this.clearNeeded();
        }
    }

    public boolean isAvail() {
        return (this.statusFlags & 2) != 0;
    }

    public boolean calcAvail() {
        return this.isAvail();
    }

    public void clearAvail() {
        this.statusFlags &= 0xFFFFFFFD;
    }

    public void setAvail() {
        this.statusFlags |= 2;
    }

    public void setAvail(boolean b) {
        if (b) {
            this.setAvail();
        } else {
            this.clearAvail();
        }
    }

    public boolean isRequested() {
        return (this.statusFlags & 4) != 0;
    }

    public boolean calcRequested() {
        return this.isRequested();
    }

    public void clearRequested() {
        this.statusFlags &= 0xFFFFFFFB;
    }

    public void setRequested() {
        this.statusFlags |= 4;
    }

    public void setRequested(boolean b) {
        if (b) {
            this.setRequested();
        } else {
            this.clearRequested();
        }
    }

    public boolean isDownloaded() {
        return (this.statusFlags & 0x10) != 0;
    }

    public boolean calcDownloaded() {
        return this.isDownloaded();
    }

    public void clearDownloaded() {
        this.statusFlags &= 0xFFFFFFEF;
    }

    public void setDownloaded() {
        this.statusFlags |= 0x10;
    }

    public boolean calcWritten() {
        if (this.written == null) {
            if (this.isDone()) {
                this.statusFlags |= 0x20;
                return true;
            }
            this.statusFlags &= 0xFFFFFFDF;
            return false;
        }
        boolean[] written_ref = this.written;
        for (int i = 0; i < written_ref.length; ++i) {
            if (written_ref[i]) continue;
            this.statusFlags &= 0xFFFFFFDF;
            return false;
        }
        this.statusFlags |= 0x20;
        return true;
    }

    public void clearWritten() {
        this.statusFlags &= 0xFFFFFFDF;
    }

    public boolean isWritten() {
        return (this.statusFlags & 0x20) != 0;
    }

    public void setWritten() {
        this.statusFlags |= 0x20;
    }

    public boolean[] getWritten() {
        return this.written;
    }

    public boolean isWritten(int blockNumber) {
        if (this.isDone()) {
            return true;
        }
        if (this.written == null) {
            return false;
        }
        return this.written[blockNumber];
    }

    public int getNbWritten() {
        if (this.isDone()) {
            return this.getNbBlocks();
        }
        if (this.written == null) {
            return 0;
        }
        boolean[] written_ref = this.written;
        int res = 0;
        for (int i = 0; i < written_ref.length; ++i) {
            if (!written_ref[i]) continue;
            ++res;
        }
        return res;
    }

    public void setWritten(int blockNumber) {
        if (this.written == null) {
            this.written = new boolean[this.getNbBlocks()];
        }
        this.written[blockNumber] = true;
        this.time_last_write = SystemTime.getCurrentTime();
    }

    public boolean isChecking() {
        return (this.statusFlags & 0x40) != 0;
    }

    public boolean calcChecking() {
        return this.isChecking();
    }

    public void clearChecking() {
        this.statusFlags &= 0xFFFFFFBF;
    }

    public void setChecking() {
        this.statusFlags |= 0x40;
    }

    public void setChecking(boolean b) {
        this.statusFlags = b ? (this.statusFlags |= 0x40) : (this.statusFlags &= 0xFFFFFFBF);
    }

    public boolean calcDone() {
        return this.isDone();
    }

    public boolean isDone() {
        return (this.statusFlags & 0x80) != 0;
    }

    public void setDone(boolean b) {
        if (b != this.isDone()) {
            this.diskManager.setPieceDone(this, b);
        }
        if (this.isDone()) {
            this.written = null;
        }
    }

    protected void setDoneSupport(boolean b) {
        if (b) {
            this.statusFlags |= 0x80;
            this.written = null;
        } else {
            this.statusFlags &= 0xFFFFFF7F;
        }
    }

    public long getLastWriteTime() {
        long now = SystemTime.getCurrentTime();
        if (now >= this.time_last_write) {
            return this.time_last_write;
        }
        this.time_last_write = now;
        return this.time_last_write;
    }

    public void setRequestable() {
        this.statusFlags &= 0xFFFFFF0A;
        this.calcNeeded();
    }

    public boolean isRequestable() {
        return (this.statusFlags & 0xF5) == 1;
    }

    public boolean isInteresting() {
        return (this.statusFlags & 0x81) == 1;
    }

    public boolean isEGMActive() {
        return (this.statusFlags & 5) == 5;
    }

    public boolean isEGMIgnored() {
        return (this.statusFlags & 0xF1) != 1;
    }

    public void reset() {
        this.setRequestable();
        this.written = null;
        this.time_last_write = 0L;
    }

    public void reDownloadBlock(int blockNumber) {
        if (this.written != null) {
            this.written[blockNumber] = false;
            this.setRequestable();
        }
    }

    public void testStatus() {
        if (statusTested) {
            return;
        }
        statusTested = true;
        int originalStatus = this.statusFlags;
        int i = 0;
        while (i < 256) {
            this.statusFlags = i++;
            Logger.log(new LogEvent((Object)this, LOGID, 0, "Done:" + this.isDone() + "  Checking:" + this.isChecking() + "  Written:" + this.isWritten() + "  Downloaded:" + this.isDownloaded() + "  Requested:" + this.isRequested() + "  Needed:" + this.isNeeded() + "  Interesting:" + this.isInteresting() + "  Requestable:" + this.isRequestable() + "  EGMActive:" + this.isEGMActive() + "  EGMIgnored:" + this.isEGMIgnored()));
        }
        this.statusFlags = originalStatus;
    }
}

