/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.ssdp;

import com.aelitis.net.udp.mc.MCGroup;
import com.aelitis.net.udp.mc.MCGroupAdapter;
import com.aelitis.net.udp.mc.MCGroupFactory;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPSSDP;
import com.aelitis.net.upnp.UPnPSSDPAdapter;
import com.aelitis.net.upnp.UPnPSSDPListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;

public class SSDPCore
implements UPnPSSDP,
MCGroupAdapter {
    private static final String HTTP_VERSION = "1.1";
    private static final String NL = "\r\n";
    private static Map singletons = new HashMap();
    private static AEMonitor class_mon = new AEMonitor("SSDPCore:class");
    private MCGroup mc_group;
    private UPnPSSDPAdapter adapter;
    private String group_address_str;
    private int group_port;
    private int control_port;
    private boolean first_response = true;
    private List listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("SSDP");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSDPCore getSingleton(UPnPSSDPAdapter adapter, String group_address, int group_port, int control_port, String[] selected_interfaces) throws UPnPException {
        try {
            class_mon.enter();
            String key = group_address + ":" + group_port + ":" + control_port;
            SSDPCore singleton = (SSDPCore)singletons.get(key);
            if (singleton == null) {
                singleton = new SSDPCore(adapter, group_address, group_port, control_port, selected_interfaces);
                singletons.put(key, singleton);
            }
            SSDPCore sSDPCore = singleton;
            return sSDPCore;
        }
        finally {
            class_mon.exit();
        }
    }

    public SSDPCore(UPnPSSDPAdapter _adapter, String _group_address, int _group_port, int _control_port, String[] _selected_interfaces) throws UPnPException {
        this.adapter = _adapter;
        this.group_address_str = _group_address;
        this.group_port = _group_port;
        this.control_port = _control_port;
        try {
            this.mc_group = MCGroupFactory.getSingleton(this, _group_address, this.group_port, this.control_port, _selected_interfaces);
        }
        catch (Throwable e) {
            throw new UPnPException("Failed to initialise SSDP", e);
        }
    }

    public void trace(String str) {
        this.adapter.log(str);
    }

    public void log(Throwable e) {
        this.adapter.log(e);
    }

    public void notify(String NT, String NTS) {
        String str = "NOTIFY * HTTP/1.1\r\nHOST: " + this.group_address_str + ":" + this.group_port + NL + "CACHE-CONTROL: max-age=3600" + NL + "LOCATION: http://127.0.0.1:" + this.control_port + "/" + NL + "NT: " + NT + NL + "NTS: " + NTS + NL + "SERVER: Azureus (UPnP/1.0)" + NL + "USN: uuid:UUID-Azureus-1234::" + NT + NL + NL;
        this.sendMC(str);
    }

    public void search(String user_agent, String ST) {
        String str = "M-SEARCH * HTTP/1.1\r\nST: " + ST + NL + "MX: 3" + NL + "MAN: \"ssdp:discover\"" + NL + "HOST: " + this.group_address_str + ":" + this.group_port + NL + (user_agent == null ? NL : "USER-AGENT: " + user_agent + NL + NL);
        this.sendMC(str);
    }

    protected void sendMC(String str) {
        byte[] data = str.getBytes();
        try {
            this.mc_group.sendToGroup(data);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void received(NetworkInterface network_interface, InetAddress local_address, InetSocketAddress originator, byte[] packet_data, int length) {
        int p1;
        String str = new String(packet_data, 0, length);
        if (this.first_response) {
            this.first_response = false;
            this.adapter.trace("UPnP:SSDP: first response:\n" + str);
        }
        ArrayList<String> lines = new ArrayList<String>();
        int pos = 0;
        do {
            String line;
            if ((p1 = str.indexOf(NL, pos)) == -1) {
                line = str.substring(pos);
            } else {
                line = str.substring(pos, p1);
                pos = p1 + 1;
            }
            lines.add(line.trim());
        } while (p1 != -1);
        if (lines.size() == 0) {
            this.adapter.trace("SSDP::receive packet - 0 line reply");
            return;
        }
        String header = (String)lines.get(0);
        URL location = null;
        String nt = null;
        String nts = null;
        String st = null;
        String al = null;
        String user_agent = null;
        for (int i = 1; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            int c_pos = line.indexOf(":");
            if (c_pos == -1) continue;
            String key = line.substring(0, c_pos).trim().toUpperCase();
            String val = line.substring(c_pos + 1).trim();
            if (key.equals("LOCATION")) {
                try {
                    location = new URL(val);
                }
                catch (MalformedURLException e) {
                    this.adapter.log(e);
                }
                continue;
            }
            if (key.equals("NT")) {
                nt = val;
                continue;
            }
            if (key.equals("NTS")) {
                nts = val;
                continue;
            }
            if (key.equals("ST")) {
                st = val;
                continue;
            }
            if (key.equals("AL")) {
                al = val;
                continue;
            }
            if (!key.equals("USER-AGENT")) continue;
            user_agent = val;
        }
        if (header.startsWith("M-SEARCH")) {
            if (st != null) {
                String response = this.informSearch(network_interface, local_address, originator.getAddress(), user_agent, st);
                if (response != null) {
                    String data = "HTTP/1.1 200 OK\r\nSERVER: Azureus (UPnP/1.0)\r\nCACHE-CONTROL: max-age=3600\r\nLOCATION: http://" + local_address.getHostAddress() + ":" + this.control_port + "/" + NL + "ST: " + st + NL + "USN: uuid:UUID-Azureus-1234::" + st + NL + "AL: " + response;
                    byte[] data_bytes = data.getBytes();
                    try {
                        this.mc_group.sendToMember(originator, data_bytes);
                    }
                    catch (Throwable e) {
                        this.adapter.log(e);
                    }
                }
            } else {
                this.adapter.trace("SSDP::receive M-SEARCH - bad header:" + header);
            }
        } else if (header.startsWith("NOTIFY")) {
            if (location != null && nt != null && nts != null) {
                this.informNotify(network_interface, local_address, originator.getAddress(), location, nt, nts);
            } else {
                this.adapter.trace("SSDP::receive NITOFY - bad header:" + header);
            }
        } else if (header.startsWith("HTTP") && header.indexOf("200") != -1) {
            if (location != null && st != null) {
                this.informResult(network_interface, local_address, originator.getAddress(), location, st, al);
            } else {
                this.adapter.trace("SSDP::receive HTTP - bad header:" + header);
            }
        } else {
            this.adapter.trace("SSDP::receive packet - bad header:" + header);
        }
    }

    protected void informResult(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, URL location, String st, String al) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((UPnPSSDPListener)this.listeners.get(i)).receivedResult(network_interface, local_address, originator, location, st, al);
                continue;
            }
            catch (Throwable e) {
                this.adapter.log(e);
            }
        }
    }

    protected void informNotify(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, URL location, String nt, String nts) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((UPnPSSDPListener)this.listeners.get(i)).receivedNotify(network_interface, local_address, originator, location, nt, nts);
                continue;
            }
            catch (Throwable e) {
                this.adapter.log(e);
            }
        }
    }

    protected String informSearch(NetworkInterface network_interface, InetAddress local_address, InetAddress originator, String user_agent, String st) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                String res = ((UPnPSSDPListener)this.listeners.get(i)).receivedSearch(network_interface, local_address, originator, user_agent, st);
                if (res == null) continue;
                return res;
            }
            catch (Throwable e) {
                this.adapter.log(e);
            }
        }
        return null;
    }

    public void addListener(UPnPSSDPListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UPnPSSDPListener l) {
        this.listeners.remove(l);
    }
}

