/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl;

import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAction;
import com.aelitis.net.upnp.UPnPActionArgument;
import com.aelitis.net.upnp.UPnPActionInvocation;
import com.aelitis.net.upnp.UPnPAdapter;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPFactory;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPLogListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.UPnPStateVariable;
import com.aelitis.net.upnp.impl.SSDPIGD;
import com.aelitis.net.upnp.impl.SSDPIGDFactory;
import com.aelitis.net.upnp.impl.SSDPIGDListener;
import com.aelitis.net.upnp.impl.device.UPnPRootDeviceImpl;
import com.aelitis.net.upnp.services.UPnPWANConnectionPortMapping;
import com.aelitis.net.upnp.services.UPnPWANIPConnection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;

public class UPnPImpl
extends ResourceDownloaderAdapter
implements UPnP,
SSDPIGDListener {
    public static final String NL = "\r\n";
    private static UPnPImpl singleton;
    private static AEMonitor class_mon;
    private UPnPAdapter adapter;
    private SSDPIGD ssdp;
    private Map root_locations = new HashMap();
    private List log_listeners = new ArrayList();
    private List log_history = new ArrayList();
    private List log_alert_history = new ArrayList();
    private List rd_listeners = new ArrayList();
    private AEMonitor rd_listeners_mon = new AEMonitor("UPnP:L");
    private int http_calls_ok = 0;
    private int direct_calls_ok = 0;
    private int trace_index = 0;
    private String secondary_route_log = "";
    private ThreadPool device_dispatcher = new ThreadPool("UPnPDispatcher", 1, true);
    protected AEMonitor this_mon = new AEMonitor("UPnP");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UPnP getSingleton(UPnPAdapter adapter, String[] selected_interfaces) throws UPnPException {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new UPnPImpl(adapter, selected_interfaces);
            }
            UPnPImpl uPnPImpl = singleton;
            return uPnPImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected UPnPImpl(UPnPAdapter _adapter, String[] _selected_interfaces) throws UPnPException {
        this.adapter = _adapter;
        this.ssdp = SSDPIGDFactory.create(this, _selected_interfaces);
        this.ssdp.addListener(this);
        this.ssdp.start();
    }

    public void rootDiscovered(final NetworkInterface network_interface, final InetAddress local_address, final URL location) {
        this.device_dispatcher.run(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                UPnPRootDeviceImpl old_root_device;
                try {
                    UPnPImpl.this.rd_listeners_mon.enter();
                    old_root_device = (UPnPRootDeviceImpl)UPnPImpl.this.root_locations.get(location.getHost());
                }
                finally {
                    UPnPImpl.this.rd_listeners_mon.exit();
                }
                if (old_root_device != null && old_root_device.getLocation().equals(location)) {
                    if (old_root_device.getLocalAddress().equals(local_address)) {
                        return;
                    }
                    if (!old_root_device.getNetworkInterface().getName().equals(network_interface.getName())) {
                        String msg = "UPnP: secondary route to = " + location + ", local = " + local_address.toString() + " - using initial network interface (" + old_root_device.getNetworkInterface();
                        if (!UPnPImpl.this.secondary_route_log.equals(msg)) {
                            UPnPImpl.this.secondary_route_log = msg;
                            UPnPImpl.this.log(msg);
                        }
                        return;
                    }
                }
                if (old_root_device != null) {
                    try {
                        UPnPImpl.this.rd_listeners_mon.enter();
                        UPnPImpl.this.root_locations.remove(location.getHost());
                    }
                    finally {
                        UPnPImpl.this.rd_listeners_mon.exit();
                    }
                    old_root_device.destroy(true);
                }
                UPnPImpl.this.log("UPnP: root discovered = " + location + ", local = " + local_address.toString());
                try {
                    ArrayList listeners;
                    UPnPRootDeviceImpl new_root_device = new UPnPRootDeviceImpl(UPnPImpl.this, network_interface, local_address, location);
                    try {
                        UPnPImpl.this.rd_listeners_mon.enter();
                        UPnPImpl.this.root_locations.put(location.getHost(), new_root_device);
                        listeners = new ArrayList(UPnPImpl.this.rd_listeners);
                    }
                    finally {
                        UPnPImpl.this.rd_listeners_mon.exit();
                    }
                    for (int i = 0; i < listeners.size(); ++i) {
                        ((UPnPListener)listeners.get(i)).rootDeviceFound(new_root_device);
                    }
                }
                catch (UPnPException e) {
                    UPnPImpl.this.log(e.toString());
                    UPnPImpl.this.adapter.log(e);
                }
            }
        });
    }

    public void rootAlive(URL location) {
        UPnPRootDeviceImpl root_device = (UPnPRootDeviceImpl)this.root_locations.get(location.getHost());
        if (root_device == null) {
            this.ssdp.searchNow();
        }
    }

    public void rootLost(final InetAddress local_address, final URL location) {
        this.device_dispatcher.run(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                UPnPRootDeviceImpl root_device;
                try {
                    UPnPImpl.this.rd_listeners_mon.enter();
                    root_device = (UPnPRootDeviceImpl)UPnPImpl.this.root_locations.remove(location.getHost());
                }
                finally {
                    UPnPImpl.this.rd_listeners_mon.exit();
                }
                if (root_device == null) {
                    return;
                }
                UPnPImpl.this.log("UPnP: root lost = " + location + ", local = " + local_address.toString());
                root_device.destroy(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList roots;
        this.log("UPnP: reset");
        try {
            this.rd_listeners_mon.enter();
            roots = new ArrayList(this.root_locations.values());
            this.root_locations.clear();
        }
        finally {
            this.rd_listeners_mon.exit();
        }
        for (int i = 0; i < roots.size(); ++i) {
            ((UPnPRootDeviceImpl)roots.get(i)).destroy(true);
        }
        this.ssdp.searchNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleXMLParserDocument parseXML(InputStream _is) throws SimpleXMLParserDocumentException, IOException {
        ByteArrayOutputStream baos = null;
        try {
            int len;
            baos = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[8192];
            while ((len = _is.read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
        }
        finally {
            baos.close();
        }
        byte[] bytes_in = baos.toByteArray();
        ByteArrayInputStream is = new ByteArrayInputStream(bytes_in);
        try {
            String line;
            StringBuffer data = new StringBuffer(1024);
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)is, "UTF-8"));
            while ((line = lnr.readLine()) != null) {
                data.append(line.trim() + "\n");
            }
            String data_str = data.toString();
            this.adapter.trace("UPnP:Response:" + data_str);
            return this.adapter.parseXML(data_str);
        }
        catch (Throwable e) {
            try {
                FileOutputStream trace = new FileOutputStream(this.getTraceFile());
                trace.write(bytes_in);
                trace.close();
            }
            catch (Throwable f) {
                this.adapter.log(f);
            }
            if (e instanceof SimpleXMLParserDocumentException) {
                throw (SimpleXMLParserDocumentException)e;
            }
            throw new SimpleXMLParserDocumentException(e);
        }
    }

    public SimpleXMLParserDocument downloadXML(URL url) throws UPnPException {
        ResourceDownloaderFactory rdf = this.adapter.getResourceDownloaderFactory();
        ResourceDownloader rd = rdf.getRetryDownloader(rdf.create(url), 3);
        rd.addListener(this);
        try {
            InputStream data = rd.download();
            return this.parseXML(data);
        }
        catch (Throwable e) {
            this.adapter.log(e);
            if (e instanceof UPnPException) {
                throw (UPnPException)e;
            }
            throw new UPnPException("Root device location '" + url + "' - data read failed", e);
        }
    }

    public SimpleXMLParserDocument performSOAPRequest(UPnPService service, String soap_action, String request2) throws SimpleXMLParserDocumentException, UPnPException, IOException {
        SimpleXMLParserDocument res;
        block2: {
            try {
                res = this.performSOAPRequest(service, soap_action, request2, true);
                ++this.http_calls_ok;
            }
            catch (IOException e) {
                res = this.performSOAPRequest(service, soap_action, request2, false);
                ++this.direct_calls_ok;
                if (this.direct_calls_ok != 1) break block2;
                this.log("Invocation via http connection failed (" + e.getMessage() + ") but socket connection succeeded");
            }
        }
        return res;
    }

    public SimpleXMLParserDocument performSOAPRequest(UPnPService service, String soap_action, String request2, boolean use_http_connection) throws SimpleXMLParserDocumentException, UPnPException, IOException {
        byte[] buffer;
        URL control = service.getControlURL();
        this.adapter.trace("UPnP:Request: -> " + control + "," + request2);
        if (use_http_connection) {
            HttpURLConnection con = (HttpURLConnection)control.openConnection();
            con.setRequestProperty("SOAPAction", "\"" + soap_action + "\"");
            con.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
            con.setRequestProperty("User-Agent", "Azureus (UPnP/1.0)");
            con.setRequestMethod("POST");
            con.setDoInput(true);
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
            pw.println(request2);
            pw.flush();
            con.connect();
            if (con.getResponseCode() == 405 || con.getResponseCode() == 500) {
                con = (HttpURLConnection)control.openConnection();
                con.setRequestProperty("Content-Type", "text/xml; charset=\"utf-8\"");
                con.setRequestMethod("M-POST");
                con.setRequestProperty("MAN", "\"http://schemas.xmlsoap.org/soap/envelope/\"; ns=01");
                con.setRequestProperty("01-SOAPACTION", "\"" + soap_action + "\"");
                con.setDoInput(true);
                con.setDoOutput(true);
                os = con.getOutputStream();
                pw = new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
                pw.println(request2);
                pw.flush();
                con.connect();
                return this.parseXML(con.getInputStream());
            }
            return this.parseXML(con.getInputStream());
        }
        Socket socket = new Socket(control.getHost(), control.getPort());
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF8"));
        String url_target = control.toString();
        int p1 = url_target.indexOf("://") + 3;
        p1 = url_target.indexOf("/", p1);
        url_target = url_target.substring(p1);
        pw.print("POST " + url_target + " HTTP/1.1" + NL);
        pw.print("Content-Type: text/xml; charset=\"utf-8\"\r\n");
        pw.print("SOAPAction: \"" + soap_action + "\"" + NL);
        pw.print("User-Agent: Azureus (UPnP/1.0)\r\n");
        pw.print("Host: " + control.getHost() + NL);
        pw.print("Content-Length: " + request2.getBytes("UTF8").length + NL);
        pw.print("Connection: Keep-Alive\r\n");
        pw.print("Pragma: no-cache\r\n\r\n");
        pw.print(request2);
        pw.flush();
        InputStream is = socket.getInputStream();
        String reply_header = "";
        do {
            if (is.read(buffer = new byte[1]) > 0) continue;
            throw new IOException("Premature end of input stream");
        } while (!(reply_header = reply_header + (char)buffer[0]).endsWith("\r\n\r\n"));
        p1 = reply_header.indexOf(NL);
        String first_line = reply_header.substring(0, p1).trim();
        if (first_line.indexOf("200") == -1) {
            throw new IOException("HTTP request failed:" + first_line);
        }
        return this.parseXML(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getTraceFile() {
        try {
            this.this_mon.enter();
            ++this.trace_index;
            if (this.trace_index == 6) {
                this.trace_index = 1;
            }
            File file = new File(this.adapter.getTraceDir(), "upnp_trace" + this.trace_index + ".log");
            return file;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public UPnPAdapter getAdapter() {
        return this.adapter;
    }

    public void reportActivity(ResourceDownloader downloader, String activity) {
        this.log(activity);
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        this.log(e);
    }

    public void log(Throwable e) {
        this.log(e.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String str) {
        ArrayList old_listeners;
        try {
            this.this_mon.enter();
            old_listeners = new ArrayList(this.log_listeners);
            this.log_history.add(str);
            if (this.log_history.size() > 32) {
                this.log_history.remove(0);
            }
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < old_listeners.size(); ++i) {
            ((UPnPLogListener)old_listeners.get(i)).log(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAlert(String str, boolean error, int type) {
        ArrayList old_listeners;
        try {
            this.this_mon.enter();
            old_listeners = new ArrayList(this.log_listeners);
            this.log_alert_history.add(new Object[]{str, new Boolean(error), new Integer(type)});
            if (this.log_alert_history.size() > 32) {
                this.log_alert_history.remove(0);
            }
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < old_listeners.size(); ++i) {
            ((UPnPLogListener)old_listeners.get(i)).logAlert(str, error, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(UPnPLogListener l) {
        int i;
        ArrayList old_alerts;
        ArrayList old_logs;
        try {
            this.this_mon.enter();
            old_logs = new ArrayList(this.log_history);
            old_alerts = new ArrayList(this.log_alert_history);
            this.log_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
        for (i = 0; i < old_logs.size(); ++i) {
            l.log((String)old_logs.get(i));
        }
        for (i = 0; i < old_alerts.size(); ++i) {
            Object[] entry2 = (Object[])old_alerts.get(i);
            l.logAlert((String)entry2[0], (Boolean)entry2[1], (Integer)entry2[2]);
        }
    }

    public void removeLogListener(UPnPLogListener l) {
        this.log_listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRootDeviceListener(UPnPListener l) {
        ArrayList old_locations;
        try {
            this.this_mon.enter();
            old_locations = new ArrayList(this.root_locations.values());
            this.rd_listeners.add(l);
        }
        finally {
            this.this_mon.exit();
        }
        for (int i = 0; i < old_locations.size(); ++i) {
            l.rootDeviceFound((UPnPRootDevice)old_locations.get(i));
        }
    }

    public void removeRootDeviceListener(UPnPListener l) {
        this.rd_listeners.remove(l);
    }

    public static void main(String[] args) {
        try {
            UPnP upnp = UPnPFactory.getSingleton(null, null);
            upnp.addRootDeviceListener(new UPnPListener(){

                public void rootDeviceFound(UPnPRootDevice device) {
                    try {
                        UPnPImpl.processDevice(device.getDevice());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
            upnp.addLogListener(new UPnPLogListener(){

                public void log(String str) {
                    System.out.println(str);
                }

                public void logAlert(String str, boolean error, int type) {
                    System.out.println(str);
                }
            });
            Thread.sleep(20000L);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected static void processDevice(UPnPDevice device) throws UPnPException {
        if (device.getDeviceType().equalsIgnoreCase("urn:schemas-upnp-org:device:WANConnectionDevice:1")) {
            System.out.println("got device");
            UPnPService[] services = device.getServices();
            for (int i = 0; i < services.length; ++i) {
                UPnPService s = services[i];
                if (!s.getServiceType().equalsIgnoreCase("urn:schemas-upnp-org:service:WANIPConnection:1")) continue;
                System.out.println("got service");
                UPnPAction[] actions = s.getActions();
                for (int j = 0; j < actions.length; ++j) {
                    System.out.println(actions[j].getName());
                }
                UPnPStateVariable[] vars = s.getStateVariables();
                for (int j = 0; j < vars.length; ++j) {
                    System.out.println(vars[j].getName());
                }
                UPnPStateVariable noe = s.getStateVariable("PortMappingNumberOfEntries");
                System.out.println("noe = " + noe.getValue());
                UPnPWANIPConnection wan_ip = (UPnPWANIPConnection)s.getSpecificService();
                UPnPWANConnectionPortMapping[] ports = wan_ip.getPortMappings();
                wan_ip.addPortMapping(true, 7007, "Moo!");
                UPnPAction act = s.getAction("GetGenericPortMappingEntry");
                UPnPActionInvocation inv = act.getInvocation();
                inv.addArgument("NewPortMappingIndex", "0");
                UPnPActionArgument[] outs = inv.invoke();
                for (int j = 0; j < outs.length; ++j) {
                    System.out.println(outs[j].getName() + " = " + outs[j].getValue());
                }
            }
        } else {
            UPnPDevice[] kids = device.getSubDevices();
            for (int i = 0; i < kids.length; ++i) {
                UPnPImpl.processDevice(kids[i]);
            }
        }
    }

    static {
        class_mon = new AEMonitor("UPnP:class");
    }
}

