/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.jpc.cache.impl.messaging;

import com.aelitis.azureus.plugins.jpc.cache.impl.messaging.JPCCacheMessage;
import java.nio.ByteBuffer;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.utils.StaticUtilities;

public class JPCRequest
implements JPCCacheMessage {
    private final String description;
    private final ByteBuffer buffer;
    private final int session_id;
    private final byte[] infohash;
    private final int piece_number;
    private final int piece_offset;
    private final int piece_length;

    public JPCRequest(int session_id, byte[] infohash, int piece_number, int piece_offset, int length) {
        this.session_id = session_id;
        this.infohash = infohash;
        this.piece_number = piece_number;
        this.piece_offset = piece_offset;
        this.piece_length = length;
        this.description = this.getID() + " session id# " + session_id + " infohash " + StaticUtilities.getFormatters().formatByteArray(infohash, true) + " piece #" + piece_number + ": " + piece_offset + "->" + (piece_offset + length - 1);
        this.buffer = ByteBuffer.allocate(36);
        this.buffer.putInt(session_id);
        this.buffer.put(infohash);
        this.buffer.putInt(piece_number);
        this.buffer.putInt(piece_offset);
        this.buffer.putInt(length);
        this.buffer.flip();
    }

    public int getSessionID() {
        return this.session_id;
    }

    public byte[] getInfohash() {
        return this.infohash;
    }

    public int getPieceNumber() {
        return this.piece_number;
    }

    public int getPieceOffset() {
        return this.piece_offset;
    }

    public int getPieceLength() {
        return this.piece_length;
    }

    public String getID() {
        return "JPC_REQUEST";
    }

    public byte getVersion() {
        return 1;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        return this.description;
    }

    public ByteBuffer[] getPayload() {
        return new ByteBuffer[]{this.buffer};
    }

    public void destroy() {
    }

    public Message create(ByteBuffer data) throws MessageException {
        if (data == null) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: data == null");
        }
        if (data.remaining() != 36) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: payload.remaining[" + data.remaining() + "] != 36");
        }
        int id = data.getInt();
        byte[] hash = new byte[20];
        data.get(hash);
        int number = data.getInt();
        if (number < 0) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: number < 0");
        }
        int offset = data.getInt();
        if (offset < 0) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: offset < 0");
        }
        int length = data.getInt();
        if (length < 0) {
            throw new MessageException("[" + this.getID() + ":" + this.getVersion() + "] decode error: length < 0");
        }
        return new JPCRequest(id, hash, number, offset, length);
    }
}

