/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.extseed;

import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReader;
import com.aelitis.azureus.plugins.extseed.ExternalSeedReaderListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.utils.Monitor;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;

public class ExternalSeedPeer
implements Peer,
ExternalSeedReaderListener {
    private ExternalSeedPlugin plugin;
    private PeerManager manager;
    private PeerStats stats;
    private Map user_data;
    private ExternalSeedReader reader;
    private int state;
    private byte[] peer_id;
    private boolean[] available;
    private boolean availabilityAdded = false;
    private long snubbed;
    private boolean is_optimistic;
    private Monitor connection_mon;
    private boolean peer_added;
    private List listenerList;
    private Monitor listenerListMon;

    protected ExternalSeedPeer(ExternalSeedPlugin _plugin, ExternalSeedReader _reader) {
        this.plugin = _plugin;
        this.reader = _reader;
        this.connection_mon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        Torrent torrent = this.reader.getTorrent();
        this.available = new boolean[(int)torrent.getPieceCount()];
        Arrays.fill(this.available, true);
        this.peer_id = new byte[20];
        new Random().nextBytes(this.peer_id);
        this.peer_id[0] = 69;
        this.peer_id[1] = 120;
        this.peer_id[2] = 116;
        this.peer_id[3] = 32;
        this.listenerList = new ArrayList();
        this.listenerListMon = this.plugin.getPluginInterface().getUtilities().getMonitor();
        _reader.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setManager(PeerManager _manager) {
        this.setState(10);
        try {
            this.connection_mon.enter();
            this.manager = _manager;
            if (this.manager != null) {
                this.stats = this.manager.createPeerStats(this);
            }
            this.checkConnection();
        }
        finally {
            this.connection_mon.exit();
        }
    }

    public PeerManager getManager() {
        return this.manager;
    }

    protected void setState(int newState) {
        this.state = newState;
        this.fireEvent(1, new Integer(newState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConnection() {
        boolean state_changed = false;
        try {
            this.connection_mon.enter();
            boolean active = this.reader.checkActivation(this.manager);
            if (this.manager != null && active != this.peer_added) {
                state_changed = true;
                boolean peer_was_added = this.peer_added;
                this.peer_added = active;
                if (active) {
                    this.addPeer();
                } else if (peer_was_added) {
                    this.removePeer();
                }
            }
        }
        finally {
            this.connection_mon.exit();
        }
        return state_changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPeer() {
        this.setState(20);
        this.manager.addPeer(this);
        this.setState(30);
        try {
            this.listenerListMon.enter();
            this.fireEvent(3, this.getAvailable());
            this.availabilityAdded = true;
        }
        finally {
            this.listenerListMon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePeer() {
        this.setState(40);
        try {
            this.listenerListMon.enter();
            if (this.availabilityAdded) {
                this.fireEvent(4, this.getAvailable());
                this.availabilityAdded = false;
            }
        }
        finally {
            this.listenerListMon.exit();
        }
        this.manager.removePeer(this);
    }

    public void requestComplete(PeerReadRequest request2, PooledByteBuffer data) {
        PeerManager man = this.manager;
        if (request2.isCancelled() || man == null) {
            data.returnToPool();
        } else {
            try {
                man.requestComplete(request2, data, this);
                this.stats.received(request2.getLength());
            }
            catch (Throwable e) {
                data.returnToPool();
                e.printStackTrace();
            }
        }
    }

    public void requestCancelled(PeerReadRequest request2) {
        PeerManager man = this.manager;
        if (man != null) {
            man.requestCancelled(request2, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFailed(PeerReadRequest request2) {
        PeerManager man = this.manager;
        if (man != null) {
            man.requestCancelled(request2, this);
            try {
                this.connection_mon.enter();
                if (this.peer_added) {
                    this.plugin.log(this.reader.getName() + " failed - " + this.reader.getStatus() + ", permanent = " + this.reader.isPermanentlyUnavailable());
                    this.removePeer();
                    this.peer_added = false;
                }
            }
            finally {
                this.connection_mon.exit();
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public byte[] getId() {
        return this.peer_id;
    }

    public String getIp() {
        return this.reader.getIP();
    }

    public int getTCPListenPort() {
        return 0;
    }

    public int getUDPListenPort() {
        return 0;
    }

    public int getPort() {
        return this.reader.getPort();
    }

    public final boolean[] getAvailable() {
        return this.available;
    }

    public final boolean isPieceAvailable(int pieceNumber) {
        return true;
    }

    public boolean isTransferAvailable() {
        return this.reader.isActive();
    }

    public boolean isDownloadPossible() {
        return this.peer_added && this.reader.isActive();
    }

    public boolean isChoked() {
        return false;
    }

    public boolean isChoking() {
        return false;
    }

    public boolean isInterested() {
        return false;
    }

    public boolean isInteresting() {
        return true;
    }

    public boolean isSeed() {
        return true;
    }

    public boolean isSnubbed() {
        return this.snubbed != 0L;
    }

    public long getSnubbedTime() {
        if (this.snubbed == 0L) {
            return 0L;
        }
        long now = this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
        if (now < this.snubbed) {
            this.snubbed = now - 26L;
        }
        return now - this.snubbed;
    }

    public void setSnubbed(boolean b) {
        if (!b) {
            this.snubbed = 0L;
        } else if (this.snubbed == 0L) {
            this.snubbed = this.plugin.getPluginInterface().getUtilities().getCurrentSystemTime();
        }
    }

    public boolean isOptimisticUnchoke() {
        return this.is_optimistic;
    }

    public void setOptimisticUnchoke(boolean _is_optimistic) {
        this.is_optimistic = _is_optimistic;
    }

    public PeerStats getStats() {
        return this.stats;
    }

    public boolean isIncoming() {
        return false;
    }

    public int getPercentDone() {
        return 1000;
    }

    public int getPercentDoneInThousandNotation() {
        return 1000;
    }

    public String getClient() {
        return this.reader.getName();
    }

    public List getExpiredRequests() {
        return this.reader.getExpiredRequests();
    }

    public List getRequests() {
        return this.reader.getRequests();
    }

    public int getNumberOfRequests() {
        return this.reader.getRequestCount();
    }

    public void cancelRequest(PeerReadRequest request2) {
        this.reader.cancelRequest(request2);
    }

    public boolean addRequest(PeerReadRequest request2) {
        this.reader.addRequest(request2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason, boolean closedOnError, boolean attemptReconnect) {
        try {
            this.connection_mon.enter();
            this.reader.cancelAllRequests();
            this.reader.deactivate(reason);
            this.peer_added = false;
        }
        finally {
            this.connection_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PeerListener listener) {
        try {
            this.listenerListMon.enter();
            this.listenerList.add(listener);
        }
        finally {
            this.listenerListMon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerListener listener) {
        try {
            this.listenerListMon.enter();
            this.listenerList.remove(listener);
        }
        finally {
            this.listenerListMon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PeerListener2 listener) {
        try {
            this.listenerListMon.enter();
            this.listenerList.add(listener);
        }
        finally {
            this.listenerListMon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PeerListener2 listener) {
        try {
            this.listenerListMon.enter();
            this.listenerList.remove(listener);
        }
        finally {
            this.listenerListMon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(final int type, final Object data) {
        try {
            this.listenerListMon.enter();
            for (int i = 0; i < this.listenerList.size(); ++i) {
                try {
                    Object listener;
                    Object _listener = this.listenerList.get(i);
                    if (_listener instanceof PeerListener) {
                        listener = (PeerListener)_listener;
                        if (type == 1) {
                            listener.stateChanged((Integer)data);
                            continue;
                        }
                        if (type != 2) continue;
                        Integer[] d = (Integer[])data;
                        listener.sentBadChunk(d[0], d[1]);
                        continue;
                    }
                    listener = (PeerListener2)_listener;
                    listener.eventOccurred(new PeerEvent(){

                        public int getType() {
                            return type;
                        }

                        public Object getData() {
                            return data;
                        }
                    });
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.listenerListMon.exit();
        }
    }

    public Connection getConnection() {
        return null;
    }

    public boolean supportsMessaging() {
        return false;
    }

    public Message[] getSupportedMessages() {
        return new Message[0];
    }

    public int getPercentDoneOfCurrentIncomingRequest() {
        return 0;
    }

    public int getPercentDoneOfCurrentOutgoingRequest() {
        return 0;
    }

    public Map getProperties() {
        return new HashMap();
    }

    public void setUserData(Object key, Object value) {
        if (this.user_data == null) {
            this.user_data = new HashMap();
        }
        this.user_data.put(key, value);
    }

    public Object getUserData(Object key) {
        if (this.user_data == null) {
            return null;
        }
        return this.user_data.get(key);
    }
}

