/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util.average;

import com.aelitis.azureus.core.util.average.Average;

public class MovingAverage
implements Average {
    private final int periods;
    private double[] data;
    private int pos = 0;

    public MovingAverage(int periods) {
        this.periods = periods;
        this.data = new double[periods];
        for (int i = 0; i < periods; ++i) {
            this.data[i] = 0.0;
        }
    }

    public double update(double newValue) {
        this.data[this.pos] = newValue;
        ++this.pos;
        if (this.pos == this.periods) {
            this.pos = 0;
        }
        return this.calculateAve();
    }

    public double getAverage() {
        return this.calculateAve();
    }

    private double calculateAve() {
        double sum = 0.0;
        for (int i = 0; i < this.periods; ++i) {
            sum += this.data[i];
        }
        return sum / (double)this.periods;
    }
}

